/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.lookup;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.recipe.lookup.IRecipeNode;
import crazypants.enderio.util.FuncUtil;
import crazypants.enderio.util.NNPair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class RecipeNode<REC, LOB, LID, CHL extends IRecipeNode<?, ?, ?>>
implements IRecipeNode<REC, LOB, LID> {
    @Nonnull
    private final Function<LOB, LID> toId;
    @Nonnull
    private final Map<LID, NNPair<NNList<REC>, CHL>> map = new HashMap<LID, NNPair<NNList<REC>, CHL>>();

    public RecipeNode(@Nonnull Function<LOB, LID> toId) {
        this.toId = toId;
    }

    @Override
    @Nonnull
    public NNList<REC> getRecipes(@Nonnull LOB key) {
        return FuncUtil.runIfOrNN(this.map.get(this.toId.apply(key)), p -> (NNList)p.getLeft(), NNList.emptyList());
    }

    public CHL getNext(@Nonnull LOB key) {
        return (CHL)FuncUtil.runIf(this.map.get(this.toId.apply(key)), p -> (IRecipeNode)p.getRight());
    }

    @Nonnull
    public CHL makeNext(@Nonnull REC recipe, @Nonnull LOB key, Supplier<CHL> maker) {
        NNPair next = this.map.computeIfAbsent(this.toId.apply(key), unused -> new NNPair<NNList, Object>(new NNList(), NullHelper.notnull(maker.get(), (String)"bad maker")));
        if (!((NNList)next.getLeft()).contains(recipe)) {
            ((NNList)next.getLeft()).add(recipe);
        }
        return (CHL)((IRecipeNode)next.getRight());
    }
}

