/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.util.Prep;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.energy.IEnergyStorage;

public class SetRandomEnergy
extends LootFunction {
    public SetRandomEnergy(LootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public ItemStack func_186553_a(@Nonnull ItemStack stack, @Nonnull Random rand, @Nonnull LootContext context) {
        IEnergyStorage capability;
        if (Prep.isValid(stack) && (capability = PowerHandlerUtil.getCapability(stack)) != null) {
            int maxEnergyStored = capability.getMaxEnergyStored();
            for (int realEnergy = (int)((double)maxEnergyStored * 0.1 + (double)maxEnergyStored * 0.5 * (double)rand.nextFloat()); realEnergy > 0; realEnergy -= Math.max(1, capability.receiveEnergy(realEnergy, false))) {
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetRandomEnergy> {
        protected Serializer() {
            super(new ResourceLocation("enderio", "set_random_energy"), SetRandomEnergy.class);
        }

        public void serialize(@Nonnull JsonObject object, @Nonnull SetRandomEnergy functionClazz, @Nonnull JsonSerializationContext serializationContext) {
        }

        @Nonnull
        public SetRandomEnergy deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext deserializationContext, @Nonnull LootCondition[] conditionsIn) {
            return new SetRandomEnergy(conditionsIn);
        }
    }
}

