/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Enchantment;
import crazypants.enderio.base.config.recipes.xml.ItemIntegerAmount;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.enchanter.EnchanterRecipe;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Enchanting
extends AbstractConditional {
    private Optional<ItemIntegerAmount> input = this.empty();
    private Optional<Enchantment> enchantment = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (!this.input.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            if (!this.enchantment.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <enchantment>");
            }
            this.valid = this.input.get().isValid() && this.enchantment.get().isValid();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <enchanting>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.input.get().enforceValidity();
        this.enchantment.get().enforceValidity();
        if (this.input.get().getThing().isEmpty()) {
            throw new InvalidRecipeConfigException("Valid child elements are invalid in <enchanting>");
        }
    }

    @Override
    public void register(@Nonnull String recipeName, @Nonnull RecipeLevel recipeLevel) {
        if (this.isValid() && this.isActive()) {
            MachineRecipeRegistry.instance.registerRecipe("enchanter", new EnchanterRecipe(recipeLevel, this.input.get().getThing(), this.input.get().getAmount(), this.enchantment.get().getEnchantment(), this.enchantment.get().getCostMultiplier()));
        }
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name) && !this.input.isPresent()) {
            this.input = this.of(factory.read(new ItemIntegerAmount().setAllowDelaying(false), startElement));
            return true;
        }
        if ("enchantment".equals(name) && !this.enchantment.isPresent()) {
            this.enchantment = this.of(factory.read(new Enchantment(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

