/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.assets.render;

import divinerpg.config.GeneralConfig;
import divinerpg.objects.entities.assets.model.ModelHat;
import divinerpg.utils.Utils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class PlayerHatRender
implements LayerRenderer<EntityPlayer> {
    private ModelHat modelHat;
    private RenderPlayer renderManager;
    private ResourceLocation dev = new ResourceLocation("divinerpg", "textures/model/devhats/hat_red.png");
    private ResourceLocation tester = new ResourceLocation("divinerpg", "textures/model/devhats/hat_blue.png");
    private ResourceLocation artist = new ResourceLocation("divinerpg", "textures/model/devhats/hat_purple.png");
    private ResourceLocation patreon = new ResourceLocation("divinerpg", "textures/model/devhats/hat_yellow.png");
    private ResourceLocation friend = new ResourceLocation("divinerpg", "textures/model/devhats/hat_pink.png");

    public PlayerHatRender(RenderPlayer renderManager) {
        this.renderManager = renderManager;
        this.modelHat = new ModelHat(renderManager.func_177087_b());
    }

    public void doRenderLayer(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!GeneralConfig.generalOptions.enablePlayerHats) {
            return;
        }
        ResourceLocation texture = this.getTexture(player);
        if (texture == null) {
            return;
        }
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        this.renderManager.func_110776_a(texture);
        this.modelHat.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179121_F();
    }

    @Nullable
    private ResourceLocation getTexture(EntityPlayer entity) {
        if (entity != null) {
            UUID id = entity.func_110124_au();
            if (Utils.isDeveloperName(id)) {
                return this.dev;
            }
            if (Utils.isPatreon(id)) {
                return this.patreon;
            }
            if (Utils.isTesterName(id)) {
                return this.tester;
            }
            if (Utils.isArtist(id)) {
                return this.artist;
            }
            if (Utils.isFriend(id)) {
                return this.friend;
            }
        }
        return null;
    }

    public boolean func_177142_b() {
        return false;
    }
}

