/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.enums;

import divinerpg.enums.ParticleType;
import java.awt.Color;
import net.minecraft.util.ResourceLocation;

public enum BulletType {
    NONE(0.0f, null),
    FROST_CANNON_SHOT(6.0f, BulletType.ProjectileLoc("frost_cannon")),
    CYCLOPSIAN_STAFF_SHOT(6.0f, BulletType.ItemLoc("cyclops_eye_shards")),
    MAELSTROM_SHOT(12.0f, BulletType.ProjectileLoc("maelstrom")),
    CRAB_ANCHOR_SHOT(3.0f, BulletType.ProjectileLoc("crab_anchor")),
    SHARK_ANCHOR_SHOT(4.0f, BulletType.ProjectileLoc("bowhead_anchor")),
    BOWHEAD_ANCHOR_SHOT(5.0f, BulletType.ProjectileLoc("bowhead_anchor")),
    LIOPLEURODON_ANCHOR_SHOT(6.0f, BulletType.ProjectileLoc("liopleurodon_anchor")),
    GOLDEN_FURY_SHOT(30.0f, BulletType.VanillaItemLoc("gold_nugget")),
    GHAST_CANNON_SHOT(16.0f, BulletType.ProjectileLoc("ghast_cannon")),
    CRABCLAW_CANNON_SHOT(12.0f, BulletType.ProjectileLoc("crab_anchor")),
    BOWHEAD_CANNON_SHOT(12.0f, BulletType.ProjectileLoc("bowhead_anchor")),
    FROSTCLAW_CANNON_SHOT(16.0f, BulletType.ProjectileLoc("frostclaw_cannon")),
    FRACTITE_CANNON_SHOT(14.0f, BulletType.ProjectileLoc("fractite_cannon")),
    EDEN_BLITZ_SHOT(10.0f, BulletType.ProjectileLoc("eden_blitz"), ParticleType.EDEN_PORTAL),
    WILDWOOD_BLITZ_SHOT(12.0f, BulletType.ProjectileLoc("wildwood_blitz"), ParticleType.WILDWOOD_PORTAL),
    APALACHIA_BLITZ_SHOT(14.0f, BulletType.ProjectileLoc("apalachia_blitz"), ParticleType.APALACHIA_PORTAL),
    SKYTHERN_BLITZ_SHOT(16.0f, BulletType.ProjectileLoc("skythern_blitz"), ParticleType.SKYTHERN_PORTAL),
    MORTUM_BLITZ_SHOT(18.0f, BulletType.ProjectileLoc("mortum_blitz"), ParticleType.MORTUM_PORTAL),
    HALITE_BLITZ_SHOT(20.0f, BulletType.ProjectileLoc("halite_blitz"), ParticleType.GREEN_PORTAL),
    EDEN_PHASER_SHOT(14.0f, BulletType.ProjectileLoc("eden_phaser"), ParticleType.EDEN_PORTAL),
    WILDWOOD_PHASER_SHOT(17.0f, BulletType.ProjectileLoc("wildwood_phaser"), ParticleType.WILDWOOD_PORTAL),
    APALACHIA_PHASER_SHOT(20.0f, BulletType.ProjectileLoc("apalachia_phaser"), ParticleType.APALACHIA_PORTAL),
    SKYTHERN_PHASER_SHOT(23.0f, BulletType.ProjectileLoc("skythern_phaser"), ParticleType.SKYTHERN_PORTAL),
    MORTUM_PHASER_SHOT(26.0f, BulletType.ProjectileLoc("mortum_phaser"), ParticleType.MORTUM_PORTAL),
    HALITE_PHASER_SHOT(29.0f, BulletType.ProjectileLoc("halite_phaser"), ParticleType.GREEN_PORTAL),
    SCYTHE_SHOT(6.0f, BulletType.ProjectileLoc("scythe")),
    MEGA_SCYTHE_SHOT(18.0f, BulletType.ProjectileLoc("scythe")),
    SHURIKEN_SHOT(4.0f, BulletType.ItemLoc("shuriken")),
    SNOWFLAKE_SHURIKEN_SHOT(7.0f, BulletType.ItemLoc("snowflake_shuriken")),
    EDEN_SLICER_SHOT(8.0f, BulletType.ItemLoc("eden_slicer")),
    WILDWOOD_SLICER_SHOT(10.0f, BulletType.ItemLoc("wildwood_slicer")),
    APALACHIA_SLICER_SHOT(12.0f, BulletType.ItemLoc("apalachia_slicer")),
    SKYTHERN_SLICER_SHOT(14.0f, BulletType.ItemLoc("skythern_slicer")),
    MORTUM_SLICER_SHOT(16.0f, BulletType.ItemLoc("mortum_slicer")),
    HALITE_SLICER_SHOT(22.0f, BulletType.ItemLoc("halite_slicer")),
    ARCANITE_BLASTER(23.0f, BulletType.ProjectileLoc("blaster_shot")),
    GENERALS_STAFF_SHOT(18.0f, BulletType.ProjectileLoc("generals_staff"), new Color(31, 93, 210)),
    GENERALS_STAFF_SPRAY(18.0f, BulletType.ProjectileLoc("generals_staff"), new Color(56, 152, 186)),
    MAGE_SHOT(5.0f, BulletType.ProjectileLoc("blank"), new Color(62, 212, 254)),
    SPELLBINDER_SHOT(7.0f, BulletType.ProjectileLoc("blank"), new Color(234, 158, 253)),
    MYSTIC_SHOT(10.0f, BulletType.ProjectileLoc("blank"), new Color(234, 223, 228)),
    SORCERER_SHOT(12.0f, BulletType.ProjectileLoc("blank"), new Color(97, 31, 54)),
    TWILIGHT_DEMON_BLACK_SHOT(16.0f, BulletType.ProjectileLoc("twilight_demon_shot"), new Color(0, 0, 0)),
    TWILIGHT_DEMON_RED_SHOT(16.0f, BulletType.ProjectileLoc("twilight_demon_shot"), new Color(255, 0, 0)),
    SOUL_FIEND_SHOT(0.0f, BulletType.ProjectileLoc("blank")),
    SUNSTORM(12.0f, BulletType.ProjectileLoc("blank"), new Color(255, 235, 0)),
    TEAKER_CANNON_SHOT(3.0f, BulletType.ProjectileLoc("cannon")),
    AMTHIRMIS_CANNON_SHOT(5.0f, BulletType.ProjectileLoc("cannon")),
    DARVEN_CANNON_SHOT(8.0f, BulletType.ProjectileLoc("cannon")),
    CERMILE_CANNON_SHOT(12.0f, BulletType.ProjectileLoc("cannon")),
    PARDIMAL_CANNON_SHOT(15.0f, BulletType.ProjectileLoc("cannon")),
    QUADROTIC_CANNON_SHOT(19.0f, BulletType.ProjectileLoc("cannon")),
    KAROS_CANNON_SHOT(21.0f, BulletType.ProjectileLoc("cannon")),
    HELIOSIS_CANNON_SHOT(28.0f, BulletType.ProjectileLoc("cannon")),
    ARKSIANE_CANNON_SHOT(36.0f, BulletType.ProjectileLoc("cannon")),
    EVERSIGHT_SHOT(42.0f, BulletType.ProjectileLoc("cannon")),
    LUNA_SPARKLER(12.0f, BulletType.ProjectileLoc("blank"), new Color(139, 103, 255), ParticleType.WILDWOOD_PORTAL);

    private final float damage;
    private final ResourceLocation texture;
    private final ParticleType particle;
    private final Color color;

    private BulletType(float damage, ResourceLocation texture, ParticleType particle) {
        this.damage = damage;
        this.texture = texture;
        this.particle = particle;
        this.color = null;
    }

    private BulletType(float damage, ResourceLocation texture, Color color) {
        this.damage = damage;
        this.texture = texture;
        this.particle = ParticleType.NONE;
        this.color = color;
    }

    private BulletType(float damage, ResourceLocation texture, Color color, ParticleType particle) {
        this.damage = damage;
        this.texture = texture;
        this.particle = particle;
        this.color = color;
    }

    private BulletType(float damage, ResourceLocation texture) {
        this.damage = damage;
        this.texture = texture;
        this.particle = ParticleType.NONE;
        this.color = null;
    }

    public float getDamage() {
        return this.damage;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ParticleType getParticle() {
        return this.particle;
    }

    public Color getColor() {
        return this.color;
    }

    public static BulletType getBulletFromOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal > BulletType.values().length) {
            ordinal = 0;
        }
        return BulletType.values()[ordinal];
    }

    private static ResourceLocation ProjectileLoc(String name) {
        return new ResourceLocation("divinerpg", "textures/projectiles/" + name + ".png");
    }

    private static ResourceLocation ItemLoc(String name) {
        return new ResourceLocation("divinerpg", "textures/items/" + name + ".png");
    }

    private static ResourceLocation VanillaItemLoc(String name) {
        return new ResourceLocation("minecraft:textures/items/" + name + ".png");
    }
}

