/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.config;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.config.Configuration;

public class MobStatInfo {
    private static final Map<IAttribute, String> knownAttributesPostfix = new HashMap<IAttribute, String>();
    private static final Map<IAttribute, String> knownAttributesComments = new HashMap<IAttribute, String>();
    public final Map<IAttribute, Float> values = new HashMap<IAttribute, Float>();

    private static void initAttr(IAttribute attr, String postfix, String comment) {
        knownAttributesPostfix.put(attr, postfix);
        knownAttributesComments.put(attr, comment);
    }

    public static MobStatInfo fromEntity(EntityLivingBase e) {
        MobStatInfo result = new MobStatInfo(0.0, 0.0, 0.0);
        knownAttributesPostfix.entrySet().stream().collect(Collectors.toMap(x -> x, x -> {
            if (e.func_110148_a((IAttribute)x.getKey()) != null) {
                return Float.valueOf((float)e.func_110148_a((IAttribute)x.getKey()).func_111126_e());
            }
            return Float.valueOf(0.0f);
        })).forEach((iAttributeStringEntry, aFloat) -> result.values.put((IAttribute)iAttributeStringEntry.getKey(), (Float)aFloat));
        return result;
    }

    public MobStatInfo(double health, double attack, double armor) {
        this.values.put(SharedMonsterAttributes.field_111264_e, Float.valueOf((float)attack));
        this.values.put(SharedMonsterAttributes.field_111267_a, Float.valueOf((float)health));
        this.values.put(SharedMonsterAttributes.field_188791_g, Float.valueOf((float)armor));
    }

    public void initConfig(Configuration cfg, ResourceLocation id) {
        String entityName = id.func_110623_a();
        String comment = new TextComponentTranslation(String.format("entity.%s.%s.name", id.func_110624_b(), entityName), new Object[0]).func_150261_e();
        cfg.addCustomCategoryComment(entityName, comment);
        for (Map.Entry<IAttribute, String> entry : knownAttributesPostfix.entrySet()) {
            IAttribute attr = entry.getKey();
            float value = cfg.getFloat(entityName + "_" + entry.getValue(), entityName, this.values.getOrDefault(attr, Float.valueOf(0.0f)).floatValue(), Float.MIN_NORMAL, Float.MAX_VALUE, knownAttributesComments.get(attr));
            this.values.put(attr, Float.valueOf(value));
        }
    }

    public void initEntity(EntityLivingBase e) {
        this.values.forEach((attribute, aFloat) -> this.getOrRegister(e, (IAttribute)attribute).func_111128_a((double)aFloat.floatValue()));
    }

    private IAttributeInstance getOrRegister(EntityLivingBase e, IAttribute attr) {
        AbstractAttributeMap map = e.func_110140_aT();
        IAttributeInstance instance = map.func_111151_a(attr);
        if (instance == null) {
            map.func_111150_b(attr);
            instance = map.func_111151_a(attr);
        }
        return instance;
    }

    static {
        MobStatInfo.initAttr(SharedMonsterAttributes.field_188791_g, "armor", "Armor value");
        MobStatInfo.initAttr(SharedMonsterAttributes.field_111267_a, "health", "Max mob health");
        MobStatInfo.initAttr(SharedMonsterAttributes.field_111264_e, "attack", "Attack value");
    }
}

