/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.contenttweaker.api.ctobjects.itemlist;

import com.teamacronymcoders.contenttweaker.api.ctobjects.itemlist.ICTItemList;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class CTItemList
implements ICTItemList {
    private static final Random RANDOM = new Random();
    private final NonNullList<ItemStack> nonNullList;

    public CTItemList(NonNullList<ItemStack> nonNullList) {
        this.nonNullList = nonNullList;
    }

    @Override
    public void add(IItemStack iItemStack) {
        this.nonNullList.add((Object)CraftTweakerMC.getItemStack((IItemStack)iItemStack));
    }

    @Override
    public void add(WeightedItemStack weightedItemStack) {
        if (RANDOM.nextFloat() < weightedItemStack.getChance()) {
            this.add(weightedItemStack.getStack());
        }
    }

    @Override
    public void remove(int index) {
        this.nonNullList.remove(index);
    }

    @Override
    public IItemStack get(int index) {
        return new MCItemStack((ItemStack)this.nonNullList.get(index));
    }

    @Override
    public IItemStack[] getArray() {
        return (IItemStack[])this.nonNullList.parallelStream().map(MCItemStack::new).toArray(IItemStack[]::new);
    }

    @Override
    public List<IItemStack> getList() {
        return this.nonNullList.parallelStream().map(MCItemStack::new).collect(Collectors.toList());
    }

    @Override
    public int getLength() {
        return this.nonNullList.size();
    }

    @Override
    public void clear() {
        this.nonNullList.clear();
    }
}

