/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.util.random.WeightedBlock;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class WorldGen
extends WorldGenerator {
    public abstract boolean func_180709_b(World var1, Random var2, BlockPos var3);

    public static List<WeightedBlock> fabricateList(WeightedBlock resource) {
        ArrayList<WeightedBlock> list = new ArrayList<WeightedBlock>();
        list.add(resource);
        return list;
    }

    public static List<WeightedBlock> fabricateList(Block resource) {
        ArrayList<WeightedBlock> list = new ArrayList<WeightedBlock>();
        list.add(new WeightedBlock(new ItemStack(resource, 1, 0)));
        return list;
    }

    public static boolean canGenerateInBlock(World world, int x, int y, int z, WeightedBlock[] mat) {
        return WorldGen.canGenerateInBlock(world, new BlockPos(x, y, z), mat);
    }

    public static boolean canGenerateInBlock(World world, BlockPos pos, WeightedBlock[] mat) {
        if (mat == null || mat.length == 0) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        for (WeightedBlock genBlock : mat) {
            if (-1 != genBlock.metadata && genBlock.metadata != state.func_177230_c().func_176201_c(state) || !state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos, (Predicate)BlockMatcher.func_177642_a((Block)genBlock.block)) && !state.func_177230_c().func_149667_c(genBlock.block)) continue;
            return true;
        }
        return false;
    }

    public static boolean generateBlock(World world, Random rand, int x, int y, int z, WeightedBlock[] mat, List<WeightedBlock> o) {
        if (mat == null || mat.length == 0) {
            return WorldGen.generateBlock(world, rand, x, y, z, o);
        }
        if (WorldGen.canGenerateInBlock(world, x, y, z, mat)) {
            return WorldGen.generateBlock(world, rand, x, y, z, o);
        }
        return false;
    }

    public static boolean generateBlock(World world, Random rand, int x, int y, int z, List<WeightedBlock> o) {
        return WorldGen.setBlock(world, new BlockPos(x, y, z), WorldGen.selectBlock(rand, o));
    }

    public static boolean setBlock(World world, BlockPos pos, WeightedBlock ore) {
        if (ore != null && world.func_180501_a(pos, ore.getState(), 18)) {
            TileEntity tile;
            if (ore.block.hasTileEntity(ore.getState()) && (tile = world.func_175625_s(pos)) != null) {
                tile.func_145839_a(ore.getData(tile.func_189515_b(new NBTTagCompound())));
            }
            return true;
        }
        return false;
    }

    public static WeightedBlock selectBlock(Random rand, List<WeightedBlock> o) {
        int size = o.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            return (WeightedBlock)WeightedRandom.func_76271_a((Random)rand, o);
        }
        return o.get(0);
    }
}

