/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui;

import com.direwolf20.buildinggadgets.client.gui.GuiButtonIcon;
import com.direwolf20.buildinggadgets.client.gui.ModeRadialMenu;
import java.awt.Color;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class GuiButtonActionCallback
extends GuiButtonIcon {
    private Predicate<Boolean> action;
    private ModeRadialMenu.ScreenPosition screenPosition;
    private boolean togglable = true;

    public GuiButtonActionCallback(String name, ModeRadialMenu.ScreenPosition screenPosition, Predicate<Boolean> action) {
        this(0, 0, 0, 0, String.join((CharSequence)".", "tooltip.gadget", name), Color.GREEN, Color.GRAY, Color.WHITE, new ResourceLocation("buildinggadgets", String.format("textures/gui/setting/%s.png", name.replace(".", "_"))), screenPosition, action);
        this.selected = action.test(false);
        this.setFaded(false);
    }

    public GuiButtonActionCallback(int x, int y, int width, int height, String helpTextKey, Color colorSelected, Color colorDeselected, Color colorHovered, ResourceLocation texture, ModeRadialMenu.ScreenPosition screenPosition, Predicate<Boolean> action) {
        super(x, y, width, height, helpTextKey, colorSelected, colorDeselected, colorHovered, texture, null);
        this.screenPosition = screenPosition;
        this.action = action;
    }

    public ModeRadialMenu.ScreenPosition getScreenPosition() {
        return this.screenPosition;
    }

    public GuiButtonActionCallback setTogglable(boolean togglable) {
        this.togglable = togglable;
        return this;
    }

    public void setFaded(boolean faded) {
        this.setAlpha(faded ? 70 : 90);
        this.setFaded(faded, 70);
    }

    @Override
    public String getHoverHelpText() {
        return I18n.func_135052_a((String)this.helpTextKey, (Object[])new Object[0]);
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        boolean pressed = super.func_146116_c(mc, mouseX, mouseY);
        if (pressed) {
            this.action.test(true);
            if (this.togglable) {
                this.toggleSelected();
            }
        }
        return pressed;
    }
}

