/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.ar.com.hjg.pngj.pixels;

import java.util.LinkedList;
import me.superckl.biometweaker.ar.com.hjg.pngj.FilterType;
import me.superckl.biometweaker.ar.com.hjg.pngj.ImageInfo;
import me.superckl.biometweaker.ar.com.hjg.pngj.PngHelperInternal;
import me.superckl.biometweaker.ar.com.hjg.pngj.pixels.CompressorStream;
import me.superckl.biometweaker.ar.com.hjg.pngj.pixels.CompressorStreamDeflater;
import me.superckl.biometweaker.ar.com.hjg.pngj.pixels.CompressorStreamLz4;
import me.superckl.biometweaker.ar.com.hjg.pngj.pixels.FiltersPerformance;
import me.superckl.biometweaker.ar.com.hjg.pngj.pixels.PixelsWriter;

public class PixelsWriterMultiple
extends PixelsWriter {
    protected LinkedList<byte[]> rows;
    protected CompressorStream[] filterBank = new CompressorStream[6];
    protected byte[][] filteredRows = new byte[5][];
    protected byte[] filteredRowTmp;
    protected FiltersPerformance filtersPerf;
    protected int rowsPerBand = 0;
    protected int rowsPerBandCurrent = 0;
    protected int rowInBand = -1;
    protected int bandNum = -1;
    protected int firstRowInThisBand;
    protected int lastRowInThisBand;
    private boolean tryAdaptive = true;
    protected static final int HINT_MEMORY_DEFAULT_KB = 100;
    protected int hintMemoryKb = 100;
    private int hintRowsPerBand = 1000;
    private boolean useLz4 = true;

    public PixelsWriterMultiple(ImageInfo imgInfo) {
        super(imgInfo);
        this.filtersPerf = new FiltersPerformance(imgInfo);
        this.rows = new LinkedList();
        for (int i = 0; i < 2; ++i) {
            this.rows.add(new byte[this.buflen]);
        }
        this.filteredRowTmp = new byte[this.buflen];
    }

    protected void filterAndWrite(byte[] rowb) {
        if (!this.initdone) {
            this.init();
        }
        if (rowb != this.rows.get(0)) {
            throw new RuntimeException("?");
        }
        this.setBandFromNewRown();
        byte[] rowbprev = this.rows.get(1);
        for (FilterType ftype : FilterType.getAllStandardNoneLast()) {
            if (this.currentRow == 0 && ftype != FilterType.FILTER_NONE && ftype != FilterType.FILTER_SUB) continue;
            byte[] filtered = this.filterRowWithFilterType(ftype, rowb, rowbprev, this.filteredRows[ftype.val]);
            this.filterBank[ftype.val].write(filtered);
            if (this.currentRow == 0 && ftype == FilterType.FILTER_SUB) {
                this.filterBank[FilterType.FILTER_PAETH.val].write(filtered);
                this.filterBank[FilterType.FILTER_AVERAGE.val].write(filtered);
                this.filterBank[FilterType.FILTER_UP.val].write(filtered);
            }
            if (!this.tryAdaptive) continue;
            this.filtersPerf.updateFromFiltered(ftype, filtered, this.currentRow);
        }
        this.filteredRows[0] = rowb;
        if (this.tryAdaptive) {
            FilterType preferredAdaptive = this.filtersPerf.getPreferred();
            this.filterBank[5].write(this.filteredRows[preferredAdaptive.val]);
        }
        if (this.currentRow == this.lastRowInThisBand) {
            int best = this.getBestCompressor();
            byte[] filtersAdapt = this.filterBank[best].getFirstBytes();
            int r = this.firstRowInThisBand;
            int i = 0;
            int j = this.lastRowInThisBand - this.firstRowInThisBand;
            while (r <= this.lastRowInThisBand) {
                byte fti = filtersAdapt[i];
                byte[] filtered = null;
                filtered = r != this.lastRowInThisBand ? this.filterRowWithFilterType(FilterType.getByVal(fti), this.rows.get(j), this.rows.get(j + 1), this.filteredRowTmp) : this.filteredRows[fti];
                this.sendToCompressedStream(filtered);
                ++r;
                --j;
                ++i;
            }
        }
        if (this.rows.size() > this.rowsPerBandCurrent) {
            this.rows.addFirst(this.rows.removeLast());
        } else {
            this.rows.addFirst(new byte[this.buflen]);
        }
    }

    public byte[] getRowb() {
        return this.rows.get(0);
    }

    private void setBandFromNewRown() {
        boolean newBand;
        boolean bl = newBand = this.currentRow == 0 || this.currentRow > this.lastRowInThisBand;
        if (this.currentRow == 0) {
            this.bandNum = -1;
        }
        if (newBand) {
            ++this.bandNum;
            this.rowInBand = 0;
        } else {
            ++this.rowInBand;
        }
        if (newBand) {
            this.firstRowInThisBand = this.currentRow;
            this.lastRowInThisBand = this.firstRowInThisBand + this.rowsPerBand - 1;
            int lastRowInNextBand = this.firstRowInThisBand + 2 * this.rowsPerBand - 1;
            if (lastRowInNextBand >= this.imgInfo.rows) {
                this.lastRowInThisBand = this.imgInfo.rows - 1;
            }
            this.rowsPerBandCurrent = 1 + this.lastRowInThisBand - this.firstRowInThisBand;
            this.tryAdaptive = this.rowsPerBandCurrent > 3 && (this.rowsPerBandCurrent >= 10 || this.imgInfo.bytesPerRow >= 64);
            this.rebuildFiltersBank();
        }
    }

    private void rebuildFiltersBank() {
        long bytesPerBandCurrent = (long)this.rowsPerBandCurrent * (long)this.buflen;
        int DEFLATER_COMP_LEVEL = 4;
        for (int i = 0; i <= 5; ++i) {
            CompressorStream cp = this.filterBank[i];
            if (cp == null || cp.totalbytes != bytesPerBandCurrent) {
                if (cp != null) {
                    cp.close();
                }
                cp = this.useLz4 ? new CompressorStreamLz4(null, this.buflen, bytesPerBandCurrent) : new CompressorStreamDeflater(null, this.buflen, bytesPerBandCurrent, 4, 0);
                this.filterBank[i] = cp;
            } else {
                cp.reset();
            }
            cp.setStoreFirstByte(true, this.rowsPerBandCurrent);
        }
    }

    private int computeInitialRowsPerBand() {
        int r = (int)((double)this.hintMemoryKb * 1024.0 / (double)(this.imgInfo.bytesPerRow + 1) - 5.0);
        if (r < 1) {
            r = 1;
        }
        if (this.hintRowsPerBand > 0 && r > this.hintRowsPerBand) {
            r = this.hintRowsPerBand;
        }
        if (r > this.imgInfo.rows) {
            r = this.imgInfo.rows;
        }
        if (r > 2 && r > this.imgInfo.rows / 8) {
            int k = (this.imgInfo.rows + (r - 1)) / r;
            r = (this.imgInfo.rows + k / 2) / k;
        }
        PngHelperInternal.debug("rows :" + r + "/" + this.imgInfo.rows);
        return r;
    }

    private int getBestCompressor() {
        int i;
        double bestcr = Double.MAX_VALUE;
        int bestb = -1;
        int n = i = this.tryAdaptive ? 5 : 4;
        while (i >= 0) {
            CompressorStream fb = this.filterBank[i];
            double cr = fb.getCompressionRatio();
            if (cr <= bestcr) {
                bestb = i;
                bestcr = cr;
            }
            --i;
        }
        return bestb;
    }

    protected void initParams() {
        if (this.imgInfo.cols < 3 && !FilterType.isValidStandard(this.filterType)) {
            this.filterType = FilterType.FILTER_DEFAULT;
        }
        if (this.imgInfo.rows < 3 && !FilterType.isValidStandard(this.filterType)) {
            this.filterType = FilterType.FILTER_DEFAULT;
        }
        for (int i = 1; i <= 4; ++i) {
            if (this.filteredRows[i] != null && this.filteredRows[i].length >= this.buflen) continue;
            this.filteredRows[i] = new byte[this.buflen];
        }
        if (this.rowsPerBand == 0) {
            this.rowsPerBand = this.computeInitialRowsPerBand();
        }
    }

    public void close() {
        super.close();
        this.rows.clear();
        for (CompressorStream f : this.filterBank) {
            f.close();
        }
    }

    public void setHintMemoryKb(int hintMemoryKb) {
        this.hintMemoryKb = hintMemoryKb <= 0 ? 100 : (hintMemoryKb > 10000 ? 10000 : hintMemoryKb);
    }

    public void setHintRowsPerBand(int hintRowsPerBand) {
        this.hintRowsPerBand = hintRowsPerBand;
    }

    public void setUseLz4(boolean lz4) {
        this.useLz4 = lz4;
    }

    public FiltersPerformance getFiltersPerf() {
        return this.filtersPerf;
    }
}

