/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript.script;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.superckl.api.superscript.APIInfo;
import me.superckl.api.superscript.script.ScriptLine;
import me.superckl.api.superscript.script.ScriptParser;
import me.superckl.api.superscript.script.object.ScriptObject;

public class ScriptHandler {
    private static final Map<String, Class<? extends ScriptObject>> staticObjects = new HashMap<String, Class<? extends ScriptObject>>();
    private final List<ScriptLine> lines;
    private final Map<String, String> shortcuts = new HashMap<String, String>();
    private final Map<String, ScriptObject> objects = new HashMap<String, ScriptObject>();

    public ScriptHandler(List<ScriptLine> scriptLines) {
        this.lines = scriptLines;
        for (Map.Entry<String, Class<? extends ScriptObject>> entry : staticObjects.entrySet()) {
            try {
                this.objects.put(entry.getKey(), entry.getValue().newInstance());
            }
            catch (Exception e) {
                APIInfo.log.error("Failed to instantiate static object " + entry.getKey() + "! Reason: " + e.getMessage());
                APIInfo.log.debug("Full stacktrace of error provided below for bug reports.", (Throwable)e);
            }
        }
    }

    public void parse() throws Exception {
        Iterator<ScriptLine> it = this.lines.iterator();
        if (!it.hasNext()) {
            return;
        }
        while (it.hasNext()) {
            ScriptLine line = it.next();
            String s = line.getLine().split("#", 2)[0].trim();
            try {
                if (s.contains("=")) {
                    Map<String, Object> map = ScriptParser.parseAssignment(s, line.getContext(), this);
                    if (map == null) continue;
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            this.shortcuts.put(entry.getKey(), (String)entry.getValue());
                            continue;
                        }
                        if (!(entry.getValue() instanceof ScriptObject)) continue;
                        ((ScriptObject)entry.getValue()).setContext(line.getContext());
                        this.objects.put(entry.getKey(), (ScriptObject)entry.getValue());
                    }
                    continue;
                }
                if (!s.contains(".")) continue;
                String[] split = s.split("[.]", 2);
                if (split.length != 2) {
                    APIInfo.log.error("Failed to handle a script line! " + s + " @ " + line.getContext() + ". Reason: Found operator '.' in invalid context.");
                    continue;
                }
                if (!this.objects.containsKey(split[0])) {
                    APIInfo.log.error("Failed to handle a script line! " + s + " @ " + line.getContext() + ". Reason: Object not found: " + split[0]);
                    continue;
                }
                ScriptObject obj = this.objects.get(split[0]);
                obj.handleCall(split[1], line.getContext(), this);
            }
            catch (Exception e) {
                APIInfo.log.error("Failed to handle a script line! " + s + " @ " + line.getContext() + ". Reason: " + e.getMessage());
                APIInfo.log.debug("Full stacktrace of error provided below for bug reports.", (Throwable)e);
            }
        }
    }

    public static void registerStaticObject(String name, Class<? extends ScriptObject> clazz) {
        staticObjects.put(name, clazz);
    }

    public List<ScriptLine> getLines() {
        return this.lines;
    }

    public Map<String, String> getShortcuts() {
        return this.shortcuts;
    }

    public Map<String, ScriptObject> getObjects() {
        return this.objects;
    }
}

