/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.block;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import wanion.biggercraftingtables.block.TileEntityBiggerCraftingTable;
import wanion.biggercraftingtables.inventory.CraftResultBiggerCraftingTable;
import wanion.biggercraftingtables.inventory.slot.BiggerCraftingSlot;
import wanion.lib.common.WContainer;
import wanion.lib.recipe.advanced.AbstractRecipeRegistry;
import wanion.lib.recipe.advanced.IAdvancedRecipe;

public abstract class ContainerBiggerCraftingTable<R extends IAdvancedRecipe, T extends TileEntityBiggerCraftingTable>
extends WContainer<T> {
    private final InventoryCrafting craftingMatrix;
    private final IInventory craftingResult;
    private final TileEntityBiggerCraftingTable tileEntityBiggerCraftingTable;
    private final int playerInventoryEnds;
    private final int playerInventoryStarts;
    private final int result;

    public ContainerBiggerCraftingTable(int root, int inventoryStartsX, int inventoryStartsY, int playerStartsX, int playerStartsY, int resultX, int resultY, @Nonnull T tileEntityBiggerCraftingTable, InventoryPlayer inventoryPlayer) {
        super(tileEntityBiggerCraftingTable);
        int x;
        int y;
        this.tileEntityBiggerCraftingTable = tileEntityBiggerCraftingTable;
        this.craftingMatrix = new CraftingBiggerCraftingTable(this, root);
        this.craftingResult = new CraftResultBiggerCraftingTable((TileEntityBiggerCraftingTable)((Object)tileEntityBiggerCraftingTable), root * root);
        for (y = 0; y < root; ++y) {
            for (x = 0; x < root; ++x) {
                this.func_75146_a(new Slot((IInventory)this.craftingMatrix, y * root + x, inventoryStartsX + 18 * x, inventoryStartsY + 18 * y));
            }
        }
        this.func_75146_a((Slot)new BiggerCraftingSlot(this, this.craftingResult, (IInventory)this.craftingMatrix, 0, resultX, resultY));
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, 9 + y * 9 + x, playerStartsX + 18 * x, playerStartsY + 18 * y));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, playerStartsX + 18 * i, playerStartsY + 58));
        }
        this.playerInventoryEnds = this.field_75151_b.size();
        this.playerInventoryStarts = this.playerInventoryEnds - 36;
        this.result = this.playerInventoryStarts - 1;
        this.func_75130_a((IInventory)this.craftingMatrix);
    }

    @Nonnull
    public final ItemStack func_82846_b(@Nonnull EntityPlayer entityPlayer, int slot) {
        ItemStack itemstack = null;
        Slot actualSlot = (Slot)this.field_75151_b.get(slot);
        if (actualSlot != null && actualSlot.func_75216_d()) {
            ItemStack itemstack1 = actualSlot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slot > this.result) {
                if (!this.func_75135_a(itemstack1, 0, this.result, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (slot == this.result) {
                if (!this.func_75135_a(itemstack1, this.playerInventoryStarts, this.playerInventoryEnds, true)) {
                    return ItemStack.field_190927_a;
                }
                actualSlot.func_75220_a(itemstack1, itemstack);
            } else if (!this.func_75135_a(itemstack1, this.playerInventoryStarts, this.playerInventoryEnds, true)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                actualSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                actualSlot.func_75218_e();
            }
            if (itemstack1.func_190916_E() != itemstack.func_190916_E()) {
                actualSlot.func_190901_a(entityPlayer, itemstack1);
            }
        }
        return itemstack != null ? itemstack : ItemStack.field_190927_a;
    }

    public final void func_75130_a(@Nonnull IInventory inventory) {
        IAdvancedRecipe recipe = this.getRecipeRegistry().findMatchingRecipe(this.craftingMatrix);
        this.craftingResult.func_70299_a(0, recipe != null ? recipe.getOutput() : ItemStack.field_190927_a);
    }

    @Nonnull
    public abstract AbstractRecipeRegistry<R> getRecipeRegistry();

    private class CraftingBiggerCraftingTable
    extends InventoryCrafting {
        private final int root;
        private final int square;

        private CraftingBiggerCraftingTable(ContainerBiggerCraftingTable container, int root) {
            super((Container)container, root, root);
            this.root = root;
            this.square = this.root * root;
        }

        @Nonnull
        public ItemStack func_70301_a(int slot) {
            return slot >= this.func_70302_i_() ? ItemStack.field_190927_a : ContainerBiggerCraftingTable.this.tileEntityBiggerCraftingTable.func_70301_a(slot);
        }

        @Nonnull
        public ItemStack func_70463_b(int row, int column) {
            int slot = row * this.root + column;
            return slot < this.square ? this.func_70301_a(slot) : ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack func_70298_a(int slot, int decrement) {
            ItemStack stack = ContainerBiggerCraftingTable.this.tileEntityBiggerCraftingTable.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                if (stack.func_190916_E() <= decrement) {
                    ItemStack itemstack = stack.func_77946_l();
                    ContainerBiggerCraftingTable.this.tileEntityBiggerCraftingTable.func_70299_a(slot, ItemStack.field_190927_a);
                    ContainerBiggerCraftingTable.this.func_75130_a((IInventory)this);
                    return itemstack;
                }
                ItemStack itemstack = stack.func_77979_a(decrement);
                ContainerBiggerCraftingTable.this.func_75130_a((IInventory)this);
                return itemstack;
            }
            return ItemStack.field_190927_a;
        }

        public void func_70299_a(int slot, @Nonnull ItemStack itemstack) {
            ContainerBiggerCraftingTable.this.tileEntityBiggerCraftingTable.func_70299_a(slot, itemstack);
            ContainerBiggerCraftingTable.this.func_75130_a((IInventory)this);
        }
    }
}

