/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.entity;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import morph.avaritia.entity.EntityImmortalItem;
import morph.avaritia.init.ModSounds;
import morph.avaritia.proxy.Proxy;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGapingVoid
extends Entity {
    public static final DataParameter<Integer> AGE_PARAMETER = EntityDataManager.func_187226_a(EntityGapingVoid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static Random randy = new Random();
    public static final int maxLifetime = 186;
    public static double collapse = 0.95;
    public static double suckRange = 20.0;
    public static final Predicate<Entity> SUCK_PREDICATE = input -> {
        if (input instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)input;
            if (p.field_71075_bZ.field_75098_d && p.field_71075_bZ.field_75100_b) {
                return false;
            }
        }
        return true;
    };
    public static final Predicate<Entity> OMNOM_PREDICATE = input -> {
        if (!(input instanceof EntityLivingBase)) {
            return false;
        }
        if (input instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)input;
            if (p.field_71075_bZ.field_75098_d) {
                return false;
            }
        } else if (input instanceof EntityImmortalItem) {
            return false;
        }
        return true;
    };
    private FakePlayer fakePlayer;

    public EntityGapingVoid(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(0.1f, 0.1f);
        this.field_70158_ak = true;
        if (world instanceof WorldServer) {
            this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)Proxy.avaritiaFakePlayer);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(AGE_PARAMETER, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int age = this.getAge();
        if (age >= 186) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 6.0f, true);
            this.func_70106_y();
        } else {
            if (age == 0) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.GAPING_VOID, SoundCategory.HOSTILE, 8.0f, 1.0f, true);
            }
            this.setAge(age + 1);
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.fakePlayer == null) {
            this.func_70106_y();
            return;
        }
        Vector3 pos = Vector3.fromEntity((Entity)this);
        double particlespeed = 4.5;
        double size = EntityGapingVoid.getVoidScale(age) * 0.5 - 0.2;
        for (int i = 0; i < 50; ++i) {
            Vector3 particlePos = new Vector3(0.0, 0.0, size);
            particlePos.rotate((double)(randy.nextFloat() * 180.0f), new Vector3(0.0, 1.0, 0.0));
            particlePos.rotate((double)(randy.nextFloat() * 360.0f), new Vector3(1.0, 0.0, 0.0));
            Vector3 velocity = particlePos.copy().normalize();
            velocity.multiply(particlespeed);
            particlePos.add(pos);
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, particlePos.x, particlePos.y, particlePos.z, velocity.x, velocity.y, velocity.z, new int[0]);
        }
        Cuboid6 cuboid = new Cuboid6().add(pos);
        cuboid.expand(suckRange);
        List sucked = this.field_70170_p.func_175647_a(Entity.class, cuboid.aabb(), SUCK_PREDICATE);
        double radius = EntityGapingVoid.getVoidScale(age) * 0.5;
        for (Entity suckee : sucked) {
            if (suckee == this) continue;
            double dx = this.field_70165_t - suckee.field_70165_t;
            double dy = this.field_70163_u - suckee.field_70163_u;
            double dz = this.field_70161_v - suckee.field_70161_v;
            double lensquared = dx * dx + dy * dy + dz * dz;
            double len = Math.sqrt(lensquared);
            double lenn = len / suckRange;
            if (!(len <= suckRange)) continue;
            double strength = (1.0 - lenn) * (1.0 - lenn);
            double power = 0.075 * radius;
            suckee.field_70159_w += dx / len * strength * power;
            suckee.field_70181_x += dy / len * strength * power;
            suckee.field_70179_y += dz / len * strength * power;
        }
        double nomrange = radius * 0.95;
        cuboid = new Cuboid6().add(pos);
        cuboid.expand(nomrange);
        List nommed = this.field_70170_p.func_175647_a(EntityLivingBase.class, cuboid.aabb(), OMNOM_PREDICATE);
        for (Entity nommee : nommed) {
            if (nommee == this) continue;
            Vector3 nomedPos = Vector3.fromEntity((Entity)nommee);
            Vector3 diff = pos.copy().subtract(nomedPos);
            double len = diff.mag();
            if (!(len <= nomrange)) continue;
            nommee.func_70097_a(DamageSource.field_76380_i, 3.0f);
        }
        if (age % 10 == 0) {
            Vector3 posFloor = pos.copy().floor();
            int blockrange = (int)Math.round(nomrange);
            for (int y = -blockrange; y <= blockrange; ++y) {
                for (int z = -blockrange; z <= blockrange; ++z) {
                    for (int x = -blockrange; x <= blockrange; ++x) {
                        float resist;
                        double dist;
                        Vector3 pos2 = new Vector3((double)x, (double)y, (double)z);
                        Vector3 rPos = posFloor.copy().add(pos2);
                        BlockPos blockPos = rPos.pos();
                        if (blockPos.func_177956_o() < 0 || blockPos.func_177956_o() > 255 || !((dist = pos2.mag()) <= nomrange) || this.field_70170_p.func_175623_d(blockPos)) continue;
                        IBlockState state = this.field_70170_p.func_180495_p(blockPos);
                        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.field_70170_p, blockPos, state, (EntityPlayer)this.fakePlayer);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (event.isCanceled() || !((double)(resist = state.func_177230_c().func_149638_a((Entity)this)) <= 10.0)) continue;
                        state.func_177230_c().func_180653_a(this.field_70170_p, blockPos, state, 0.9f, 0);
                        this.field_70170_p.func_175698_g(blockPos);
                    }
                }
            }
        }
    }

    private void setAge(int age) {
        this.field_70180_af.func_187227_b(AGE_PARAMETER, (Object)age);
    }

    public int getAge() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_PARAMETER);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.setAge(tag.func_74762_e("age"));
        if (this.field_70170_p instanceof WorldServer) {
            this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_70170_p), (GameProfile)Proxy.avaritiaFakePlayer);
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("age", this.getAge());
    }

    public static double getVoidScale(double age) {
        double life = age / 186.0;
        double curve = life < collapse ? 0.005 + EntityGapingVoid.ease(1.0 - (collapse - life) / collapse) * 0.995 : EntityGapingVoid.ease(1.0 - (life - collapse) / (1.0 - collapse));
        return 10.0 * curve;
    }

    private static double ease(double in) {
        double t = in - 1.0;
        return Math.sqrt(1.0 - t * t);
    }

    public boolean func_70067_L() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }
}

