/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items;

import com.teammetallurgy.atum.blocks.base.BlockAtumSlab;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAtumSlab
extends ItemBlock {
    private final BlockAtumSlab slab;

    public ItemAtumSlab(Block block, BlockAtumSlab slab) {
        super(block);
        this.slab = slab;
        this.func_77656_e(0);
    }

    public int func_77647_b(int damage) {
        return 0;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return this.slab.func_149739_a();
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && player.func_175151_a(pos.func_177972_a(facing), facing, heldItem)) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == this.slab) {
                BlockAtumSlab.Type type = (BlockAtumSlab.Type)((Object)state.func_177229_b(BlockAtumSlab.TYPE));
                if (facing == EnumFacing.UP && type == BlockAtumSlab.Type.BOTTOM || facing == EnumFacing.DOWN && type == BlockAtumSlab.Type.TOP) {
                    IBlockState doubleState = state.func_177226_a(BlockAtumSlab.TYPE, (Comparable)((Object)BlockAtumSlab.Type.DOUBLE));
                    AxisAlignedBB axisalignedbb = doubleState.func_185890_d((IBlockAccess)world, pos);
                    if (axisalignedbb != null && axisalignedbb != Block.field_185506_k && world.func_72855_b(axisalignedbb.func_186670_a(pos)) && world.func_180501_a(pos, doubleState, 11)) {
                        SoundType soundType = this.slab.getSoundType(doubleState, world, pos, (Entity)player);
                        world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                        heldItem.func_190918_g(1);
                        if (player instanceof EntityPlayerMP) {
                            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, heldItem);
                        }
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
            return this.tryPlace(player, heldItem, world, pos.func_177972_a(facing)) ? EnumActionResult.SUCCESS : super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull EntityPlayer player, ItemStack stack) {
        IBlockState stateOffset;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.slab) {
            boolean flag;
            boolean bl = flag = state.func_177229_b(BlockAtumSlab.TYPE) == BlockAtumSlab.Type.TOP;
            if (side == EnumFacing.UP && !flag || side == EnumFacing.DOWN && flag) {
                return true;
            }
        }
        return (stateOffset = world.func_180495_p(pos = pos.func_177972_a(side))).func_177230_c() == this.slab || super.func_179222_a(world, pos, side, player, stack);
    }

    private boolean tryPlace(EntityPlayer player, @Nonnull ItemStack stack, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.slab) {
            IBlockState doubleState = state.func_177226_a(BlockAtumSlab.TYPE, (Comparable)((Object)BlockAtumSlab.Type.DOUBLE));
            AxisAlignedBB axisalignedbb = doubleState.func_185890_d((IBlockAccess)world, pos);
            if (axisalignedbb != Block.field_185506_k && world.func_72855_b(axisalignedbb.func_186670_a(pos)) && world.func_180501_a(pos, doubleState, 11)) {
                SoundType soundtype = this.slab.getSoundType(doubleState, world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }
}

