/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.jei.quern;

import com.google.common.base.Preconditions;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.AtumUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class QuernRecipeWrapper
implements IRecipeWrapper {
    private final IDrawable quern;
    private final ResourceLocation id;
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;
    private final String rotations;

    public QuernRecipeWrapper(IGuiHelper guiHelper, ResourceLocation id, NonNullList<ItemStack> input, ItemStack output, int quernRotations) {
        Preconditions.checkArgument((quernRotations > 0 ? 1 : 0) != 0, (Object)"quern rotations must be greater than 0");
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>((Collection<ItemStack>)input);
        this.id = id;
        this.inputs = Collections.singletonList(inputList);
        this.output = output;
        this.rotations = AtumUtils.format("gui.atum.rotations", quernRotations);
        this.quern = guiHelper.createDrawableIngredient((Object)new ItemStack(AtumBlocks.QUERN));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public void drawInfo(Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        mc.field_71466_p.func_78276_b(this.rotations, 32, 0, Color.gray.getRGB());
        this.quern.draw(mc, 29, 8);
    }
}

