/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.stone;

import com.teammetallurgy.atum.entity.IUnderground;
import com.teammetallurgy.atum.entity.bandit.EntityBanditBase;
import com.teammetallurgy.atum.entity.undead.EntityUndeadBase;
import com.teammetallurgy.atum.init.AtumItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityStoneBase
extends EntityMob
implements IUnderground {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityStoneBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> PLAYER_CREATED = EntityDataManager.func_187226_a(EntityStoneBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private int homeCheckTimer;

    EntityStoneBase(World world) {
        super(world);
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, input -> !this.isPlayerCreated()));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityStoneBase.class, 10, true, false, input -> input != null && (!input.isPlayerCreated() && this.isPlayerCreated() || input.isPlayerCreated() && !this.isPlayerCreated())));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityUndeadBase.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityBanditBase.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 10, true, false, input -> input != null && this.isPlayerCreated() && !(input instanceof EntityStoneBase) && input.func_70668_bt() == EnumCreatureAttribute.UNDEAD));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    void setFriendlyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(PLAYER_CREATED, (Object)0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.isPlayerCreated()) {
            this.setFriendlyAttributes();
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    protected int getVariantAmount() {
        return 1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
        }
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K || !this.isPlayerCreated() || this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            super.func_70106_y();
        }
    }

    protected void func_70619_bc() {
        if (--this.homeCheckTimer <= 0) {
            this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(50);
            if (!this.func_110175_bO()) {
                this.func_175449_a(new BlockPos((Entity)this), 16);
            }
        }
        super.func_70619_bc();
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == AtumItems.KHNUMITE) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70691_i(5.0f);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70687_e(@Nonnull PotionEffect potionEffect) {
        return potionEffect.func_188419_a() != MobEffects.field_76436_u && super.func_70687_e(potionEffect);
    }

    public void func_70653_a(@Nonnull Entity entity, float strength, double xRatio, double zRatio) {
    }

    protected boolean func_70692_ba() {
        return !this.isPlayerCreated();
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187902_gb;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187843_fX;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187835_fT;
    }

    @Nonnull
    protected SoundEvent func_184588_d(int height) {
        return height > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187841_fW;
    }

    public int func_70627_aG() {
        return 120;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187902_gb, 0.15f, 1.0f);
    }

    protected boolean func_70814_o() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, pos) != 0) {
            return false;
        }
        return this.field_70170_p.func_175671_l(pos) <= this.field_70146_Z.nextInt(10);
    }

    boolean isPlayerCreated() {
        return ((Byte)this.field_70180_af.func_187225_a(PLAYER_CREATED) & 1) != 0;
    }

    public void setPlayerCreated(boolean playerCreated) {
        byte b = (Byte)this.field_70180_af.func_187225_a(PLAYER_CREATED);
        if (playerCreated) {
            this.field_70180_af.func_187227_b(PLAYER_CREATED, (Object)((byte)(b | 1)));
        } else {
            this.field_70180_af.func_187227_b(PLAYER_CREATED, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("PlayerCreated", this.isPlayerCreated());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setPlayerCreated(compound.func_74767_n("PlayerCreated"));
    }
}

