/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.efreet;

import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityEfreetBase
extends EntityAgeable {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityEfreetBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private String texturePath;
    private int angerLevel;
    private UUID angerTargetUUID;

    public EntityEfreetBase(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByAggressor(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AITargetAggressor(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        if (this.hasSkinVariants()) {
            this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        }
    }

    int getVariantAmount() {
        return 3;
    }

    boolean hasSkinVariants() {
        return this.getVariantAmount() > 0;
    }

    void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            String entityName = Objects.requireNonNull(Objects.requireNonNull(EntityRegistry.getEntry(((Object)((Object)this)).getClass())).getRegistryName()).func_110623_a();
            this.texturePath = this.hasSkinVariants() ? new ResourceLocation("atum", "textures/entity/" + entityName + "_" + this.getVariant()) + ".png" : new ResourceLocation("atum", "textures/entity/" + entityName) + ".png";
        }
        return this.texturePath;
    }

    @Nonnull
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193783_dc;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_193787_df;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_193786_de;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_180481_a(difficulty);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        if (this.hasSkinVariants()) {
            int variant = MathHelper.func_76136_a((Random)this.field_70170_p.field_73012_v, (int)0, (int)this.getVariantAmount());
            this.setVariant(variant);
        }
        return livingdata;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.texturePath = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return this.isAngry() && this.field_190534_ay > 0;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70619_bc() {
        EntityPlayer player;
        if (this.isAngry() && this.angerTargetUUID != null && this.func_70643_av() == null && (player = this.field_70170_p.func_152378_a(this.angerTargetUUID)) != null) {
            this.func_70604_c((EntityLivingBase)player);
            this.field_70717_bb = player;
            this.field_70718_bc = this.func_142015_aE();
        }
        super.func_70619_bc();
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            this.becomeAngryAt(entity);
        }
        this.field_190534_ay = 1000;
        return super.func_70097_a(source, amount);
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    private void becomeAngryAt(Entity entity) {
        this.angerLevel = 200 + this.field_70146_Z.nextInt(400);
        if (entity instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)entity);
        }
    }

    private boolean isAngry() {
        return this.angerLevel > 0;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.hasSkinVariants()) {
            compound.func_74768_a("Variant", this.getVariant());
        }
        compound.func_74777_a("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.hasSkinVariants()) {
            this.setVariant(compound.func_74762_e("Variant"));
        }
        this.angerLevel = compound.func_74765_d("Anger");
        String hurtBy = compound.func_74779_i("HurtBy");
        if (!hurtBy.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(hurtBy);
            EntityPlayer player = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            if (player != null) {
                this.func_70604_c((EntityLivingBase)player);
                this.field_70717_bb = player;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    public boolean func_70652_k(@Nonnull Entity entity) {
        boolean causeDamage;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knocback = 0;
        if (entity instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entity).func_70668_bt());
            knocback += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (causeDamage = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            int fireAspect;
            if (knocback > 0 && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70653_a((Entity)this, (float)knocback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entity.func_70015_d(fireAspect * 4);
            }
            if (entity instanceof EntityPlayer) {
                ItemStack stackActive;
                EntityPlayer player = (EntityPlayer)entity;
                ItemStack heldStack = this.func_184614_ca();
                ItemStack itemStack = stackActive = player.func_184587_cr() ? player.func_184607_cu() : ItemStack.field_190927_a;
                if (!heldStack.func_190926_b() && !stackActive.func_190926_b() && heldStack.func_77973_b().canDisableShield(heldStack, stackActive, (EntityLivingBase)player, (EntityLivingBase)this) && stackActive.func_77973_b().isShield(stackActive, (EntityLivingBase)player)) {
                    float efficiency = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < efficiency) {
                        player.func_184811_cZ().func_185145_a(stackActive.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)player, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return causeDamage;
    }

    static class AITargetAggressor
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        AITargetAggressor(EntityEfreetBase efreet) {
            super((EntityCreature)efreet, EntityPlayer.class, true);
        }

        public boolean func_75250_a() {
            return ((EntityEfreetBase)this.field_75299_d).isAngry();
        }
    }

    static class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        AIHurtByAggressor(EntityEfreetBase efreet) {
            super((EntityCreature)efreet, true, new Class[0]);
        }

        protected void func_179446_a(EntityCreature creature, @Nonnull EntityLivingBase livingBase) {
            if (creature instanceof EntityEfreetBase) {
                ((EntityEfreetBase)creature).becomeAngryAt((Entity)livingBase);
            }
        }
    }
}

