/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.alabaster;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockAlabasterBricks
extends Block
implements IOreDictEntry {
    private static final Map<Type, BlockAlabasterBricks> BRICKS = Maps.newEnumMap(Type.class);

    private BlockAlabasterBricks() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151677_p;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public static void registerBricks() {
        for (Type type : Type.values()) {
            BlockAlabasterBricks brick = new BlockAlabasterBricks();
            BRICKS.put(type, brick);
            AtumRegistry.registerBlock(brick, "alabaster_brick_" + type.func_176610_l());
        }
    }

    public static BlockAlabasterBricks getBrick(Type type) {
        return BRICKS.get((Object)type);
    }

    @Override
    public void getOreDictEntries() {
        if (this == BlockAlabasterBricks.getBrick(Type.POLISHED)) {
            OreDictHelper.add(this, "stoneAlabasterPolished");
        }
    }

    public static enum Type implements IStringSerializable
    {
        SMOOTH("smooth"),
        POLISHED("polished"),
        CARVED("carved"),
        TILED("tiled"),
        PILLAR("pillar");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }
}

