/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.world;

import com.shinoow.abyssalcraft.api.biome.IDarklandsBiome;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.structures.StructureShoggothPit;
import com.shinoow.abyssalcraft.common.world.DarklandsStructureGenerator;
import com.shinoow.abyssalcraft.init.InitHandler;
import com.shinoow.abyssalcraft.lib.ACConfig;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class AbyssalCraftWorldGenerator
implements IWorldGenerator {
    private StructureShoggothPit shoggothLair = new StructureShoggothPit();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w instanceof WorldProviderSurface) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    public void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        boolean blacklisted = InitHandler.INSTANCE.isDimBlacklistedFromStructureGen(world.field_73011_w.getDimension());
        if (ACConfig.generateDarklandsStructures && !blacklisted && world.func_180494_b(new BlockPos(chunkX, 0, chunkZ)) instanceof IDarklandsBiome) {
            int x = chunkX + random.nextInt(16) + 8;
            int z = chunkZ + random.nextInt(16) + 8;
            DarklandsStructureGenerator.generate(1, world, random, world.func_175645_m(new BlockPos(x, 0, z)));
            x = chunkX + random.nextInt(16) + 8;
            z = chunkZ + random.nextInt(16) + 8;
            DarklandsStructureGenerator.generate(2, world, random, world.func_175645_m(new BlockPos(x, 0, z)));
            x = chunkX + random.nextInt(16) + 8;
            z = chunkZ + random.nextInt(16) + 8;
            DarklandsStructureGenerator.generate(3, world, random, world.func_175645_m(new BlockPos(x, 0, z)));
            x = chunkX + random.nextInt(16) + 8;
            z = chunkZ + random.nextInt(16) + 8;
            DarklandsStructureGenerator.generate(4, world, random, world.func_175645_m(new BlockPos(x, 0, z)), Blocks.field_150349_c.func_176223_P(), ACBlocks.stone.func_176223_P());
            x = chunkX + random.nextInt(16) + 8;
            z = chunkZ + random.nextInt(16) + 8;
            DarklandsStructureGenerator.generate(0, world, random, world.func_175645_m(new BlockPos(x, 0, z)));
        }
        if (!InitHandler.INSTANCE.isDimBlacklistedFromOreGen(world.field_73011_w.getDimension())) {
            int z;
            int y;
            int x;
            int veinSize;
            int rarity;
            if (ACConfig.generateCoraliumOre) {
                for (rarity = 0; rarity < InitHandler.coraliumOreGeneration[0] / 2; ++rarity) {
                    veinSize = InitHandler.coraliumOreGeneration[1];
                    x = chunkX + random.nextInt(16);
                    y = random.nextInt(InitHandler.coraliumOreGeneration[2]);
                    z = chunkZ + random.nextInt(16);
                    if (!BiomeDictionary.hasType((Biome)world.func_180494_b(new BlockPos(x, 0, z)), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) continue;
                    new WorldGenMinable(ACBlocks.coralium_ore.func_176223_P(), veinSize).func_180709_b(world, random, new BlockPos(x, y, z));
                }
                for (rarity = 0; rarity < InitHandler.coraliumOreGeneration[0]; ++rarity) {
                    veinSize = InitHandler.coraliumOreGeneration[1];
                    x = chunkX + random.nextInt(16);
                    y = random.nextInt(InitHandler.coraliumOreGeneration[2]);
                    z = chunkZ + random.nextInt(16);
                    if (BiomeDictionary.hasType((Biome)world.func_180494_b(new BlockPos(x, 0, z)), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && world.func_180494_b(new BlockPos(x, 0, z)) != Biomes.field_150575_M) {
                        new WorldGenMinable(ACBlocks.coralium_ore.func_176223_P(), veinSize).func_180709_b(world, random, new BlockPos(x, y, z));
                    }
                    if (world.func_180494_b(new BlockPos(x, 0, z)) != Biomes.field_150575_M) continue;
                    new WorldGenMinable(ACBlocks.coralium_ore.func_176223_P(), veinSize).func_180709_b(world, random, new BlockPos(x, y - 20, z));
                }
            }
            if (ACConfig.generateNitreOre) {
                for (rarity = 0; rarity < 3; ++rarity) {
                    veinSize = 4 + random.nextInt(2);
                    x = chunkX + random.nextInt(16);
                    y = random.nextInt(30);
                    z = chunkZ + random.nextInt(16);
                    new WorldGenMinable(ACBlocks.nitre_ore.func_176223_P(), veinSize).func_180709_b(world, random, new BlockPos(x, y, z));
                }
            }
        }
        if (ACConfig.generateShoggothLairs && !blacklisted) {
            for (int i = 0; i < 1; ++i) {
                int x = chunkX + random.nextInt(16) + 8;
                int z = chunkZ + random.nextInt(2) + 28;
                BlockPos pos1 = world.func_175645_m(new BlockPos(x, 0, z));
                boolean swamp = BiomeDictionary.hasType((Biome)world.func_180494_b(pos1), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP);
                if (world.func_180495_p(pos1).func_185904_a() == Material.field_151585_k) {
                    pos1 = pos1.func_177977_b();
                }
                if (!swamp && (!BiomeDictionary.hasType((Biome)world.func_180494_b(pos1), (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || BiomeDictionary.hasType((Biome)world.func_180494_b(pos1), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) || !(swamp ? ACConfig.shoggothLairSpawnRate > 0 && random.nextInt(ACConfig.shoggothLairSpawnRate) == 0 : ACConfig.shoggothLairSpawnRateRivers > 0 && random.nextInt(ACConfig.shoggothLairSpawnRateRivers) == 0) || world.func_175623_d(pos1.func_177964_d(13)) || world.func_175623_d(pos1.func_177964_d(20)) || world.func_175623_d(pos1.func_177964_d(27))) continue;
                this.shoggothLair.func_180709_b(world, random, pos1);
            }
        }
    }
}

