/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.structures.omothol;

import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityCrate;
import com.shinoow.abyssalcraft.common.entity.EntityRemnant;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.ACLoot;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureCity
extends WorldGenerator {
    private Set<BlockPos> positions = new HashSet<BlockPos>();

    public boolean tooClose(BlockPos pos) {
        return this.positions.stream().anyMatch(b -> b.func_185332_f(pos.func_177958_n(), b.func_177956_o(), pos.func_177952_p()) <= 18.0);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        int num = rand.nextInt(7);
        pos = num == 2 || num == 5 || num == 6 ? pos.func_177982_a(rand.nextInt(4) + 4, 0, rand.nextInt(4) + 4) : pos.func_177982_a(rand.nextInt(8) + 8, 0, rand.nextInt(8) + 8);
        pos = worldIn.func_175645_m(pos);
        while (worldIn.func_175623_d(pos) && pos.func_177956_o() > 2) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 1) {
            return false;
        }
        Rotation[] arotation = Rotation.values();
        PlacementSettings placeSettings = new PlacementSettings().func_186220_a(arotation[rand.nextInt(arotation.length)]).func_186225_a(Blocks.field_189881_dj);
        BlockPos center = pos;
        int distX = 0;
        int distZ = 0;
        int widthX = 0;
        int widthZ = 0;
        switch (num) {
            case 0: {
                widthX = 14;
                widthZ = 14;
                distX = 7;
                distZ = 7;
                break;
            }
            case 1: {
                widthX = 11;
                widthZ = 14;
                distX = 5;
                distZ = 7;
                break;
            }
            case 2: {
                widthX = 9;
                widthZ = 14;
                distX = 4;
                distZ = 7;
                break;
            }
            case 3: {
                widthX = 11;
                widthZ = 14;
                distX = 5;
                distZ = 7;
                break;
            }
            case 4: {
                widthX = 9;
                widthZ = 8;
                distX = 4;
                distZ = 4;
                break;
            }
            case 5: {
                widthX = 19;
                widthZ = 14;
                distX = 9;
                distZ = 7;
                break;
            }
            case 6: {
                widthX = 12;
                widthZ = 16;
                distX = 6;
                distZ = 8;
                break;
            }
            default: {
                widthX = 14;
                widthZ = 14;
                distX = 7;
                distZ = 7;
            }
        }
        switch (placeSettings.func_186215_c()) {
            case CLOCKWISE_180: {
                pos = pos.func_177982_a(widthX, 0, widthZ);
                center = pos.func_177964_d(distZ).func_177985_f(distX);
                break;
            }
            case CLOCKWISE_90: {
                this.swap(widthX, widthZ);
                this.swap(distX, distZ);
                pos = pos.func_177982_a(widthX, 0, 0);
                center = pos.func_177970_e(distZ).func_177985_f(distX);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                this.swap(widthX, widthZ);
                this.swap(distX, distZ);
                pos = pos.func_177982_a(0, 0, widthZ);
                center = pos.func_177964_d(distZ).func_177965_g(distX);
                break;
            }
            case NONE: {
                pos = pos.func_177982_a(0, 0, 0);
                center = pos.func_177970_e(distZ).func_177965_g(distX);
                break;
            }
            default: {
                pos = pos.func_177982_a(0, 0, 0);
                center = pos.func_177970_e(distZ).func_177965_g(distX);
            }
        }
        if (worldIn.func_180495_p(center).func_177230_c() != ACBlocks.stone || worldIn.func_180495_p(center.func_177964_d(distZ)).func_177230_c() != ACBlocks.stone || worldIn.func_180495_p(center.func_177970_e(distZ)).func_177230_c() != ACBlocks.stone || worldIn.func_180495_p(center.func_177985_f(distX)).func_177230_c() != ACBlocks.stone || worldIn.func_180495_p(center.func_177965_g(distX)).func_177230_c() != ACBlocks.stone) {
            return false;
        }
        if ((center = worldIn.func_175645_m(center)).func_177956_o() > pos.func_177956_o()) {
            pos = pos.func_177981_b(center.func_177956_o() - pos.func_177956_o());
        }
        if (num == 0) {
            pos = pos.func_177979_c(4);
        } else if (num == 3) {
            pos = pos.func_177977_b();
        }
        MinecraftServer server = worldIn.func_73046_m();
        TemplateManager templateManager = worldIn.func_72860_G().func_186340_h();
        Template template = templateManager.func_186237_a(server, new ResourceLocation("abyssalcraft", this.getRandomStructure(num)));
        template.func_186253_b(worldIn, pos, placeSettings);
        this.positions.add(pos);
        Map map = template.func_186258_a(pos, placeSettings);
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getValue()).equals("chest")) {
                worldIn.func_175656_a((BlockPos)entry.getKey(), ACBlocks.wooden_crate.func_176223_P());
                TileEntityCrate crate = (TileEntityCrate)worldIn.func_175625_s((BlockPos)entry.getKey());
                if (crate == null) continue;
                crate.func_189404_a(this.getLootTable(num), worldIn.field_73012_v.nextLong());
                continue;
            }
            if (((String)entry.getValue()).equals("remnant")) {
                worldIn.func_175698_g((BlockPos)entry.getKey());
                EntityRemnant remnant = new EntityRemnant(worldIn);
                remnant.func_70012_b((double)((BlockPos)entry.getKey()).func_177958_n() + 0.5, ((BlockPos)entry.getKey()).func_177956_o(), (double)((BlockPos)entry.getKey()).func_177952_p() + 0.5, 0.0f, 0.0f);
                remnant.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)remnant)), null);
                int profession = 0;
                switch (num) {
                    case 0: {
                        profession = rand.nextBoolean() ? 4 : 0;
                        break;
                    }
                    case 1: {
                        profession = rand.nextInt(3) == 0 ? 6 : 3;
                        break;
                    }
                    case 2: {
                        profession = 2;
                        break;
                    }
                    case 4: {
                        profession = 4;
                        break;
                    }
                    case 5: {
                        profession = rand.nextBoolean() ? 5 : 0;
                        break;
                    }
                    case 6: {
                        profession = 1;
                        break;
                    }
                }
                remnant.setProfession(profession);
                worldIn.func_72838_d((Entity)remnant);
                continue;
            }
            if (((String)entry.getValue()).startsWith("crystal")) {
                if (rand.nextBoolean()) {
                    if (rand.nextInt(100) == 0) {
                        worldIn.func_175656_a((BlockPos)entry.getKey(), ACBlocks.dreadlands_infused_powerstone.func_176223_P());
                        continue;
                    }
                    int meta = rand.nextInt(ACLib.crystalNames.length);
                    if (meta > 15) {
                        worldIn.func_175656_a((BlockPos)entry.getKey(), ACBlocks.crystal_cluster2.func_176203_a(meta -= 16));
                        continue;
                    }
                    worldIn.func_175656_a((BlockPos)entry.getKey(), ACBlocks.crystal_cluster.func_176203_a(meta));
                    continue;
                }
                worldIn.func_175698_g((BlockPos)entry.getKey());
                continue;
            }
            if (!((String)entry.getValue()).equals("pedestal")) continue;
            int meta = rand.nextInt(4);
            worldIn.func_175656_a((BlockPos)entry.getKey(), ACBlocks.tiered_energy_pedestal.func_176203_a(meta));
        }
        return true;
    }

    private void swap(int a, int b) {
        int temp2;
        int temp1 = a;
        a = temp2 = b;
        b = temp1;
    }

    private String getRandomStructure(int num) {
        switch (num) {
            case 0: {
                return "omothol/bar";
            }
            case 1: {
                return "omothol/blacksmith";
            }
            case 2: {
                return "omothol/church";
            }
            case 3: {
                return "omothol/farm";
            }
            case 4: {
                return "omothol/farmhouse";
            }
            case 5: {
                return "omothol/house";
            }
            case 6: {
                return "omothol/library";
            }
        }
        return "omothol/bar";
    }

    private ResourceLocation getLootTable(int num) {
        switch (num) {
            case 1: {
                return ACLoot.CHEST_OMOTHOL_BLACKSMITH;
            }
            case 4: {
                return ACLoot.CHEST_OMOTHOL_FARMHOUSE;
            }
            case 5: {
                return ACLoot.CHEST_OMOTHOL_HOUSE;
            }
            case 6: {
                return ACLoot.CHEST_OMOTHOL_LIBRARY;
            }
        }
        return ACLoot.CHEST_OMOTHOL_HOUSE;
    }
}

