/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.ritual;

import com.shinoow.abyssalcraft.api.ritual.EnumRitualParticle;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NecronomiconEnchantmentRitual
extends NecronomiconRitual {
    private EnchantmentData enchantment;

    public NecronomiconEnchantmentRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, EnchantmentData enchantment, Object ... offerings) {
        super(unlocalizedName, bookType, dimension, requiredEnergy, requiresSacrifice, offerings);
        this.enchantment = enchantment;
        this.setRitualParticle(EnumRitualParticle.GLYPHS);
    }

    public NecronomiconEnchantmentRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, EnchantmentData enchantment, Object ... offerings) {
        this(unlocalizedName, bookType, dimension, requiredEnergy, false, enchantment, offerings);
    }

    public NecronomiconEnchantmentRitual(String unlocalizedName, int bookType, float requiredEnergy, EnchantmentData enchantment, Object ... offerings) {
        this(unlocalizedName, bookType, -1, requiredEnergy, enchantment, offerings);
    }

    @Override
    public boolean requiresItemSacrifice() {
        return true;
    }

    public EnchantmentData getEnchantment() {
        return this.enchantment;
    }

    @Override
    public boolean canCompleteRitual(World world, BlockPos pos, EntityPlayer player) {
        TileEntity altar = world.func_175625_s(pos);
        NBTTagCompound compound = new NBTTagCompound();
        altar.func_189515_b(compound);
        NBTTagCompound nbtItem = compound.func_74775_l("Item");
        return this.canEnchant(new ItemStack(nbtItem));
    }

    private boolean canEnchant(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77948_v()) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            for (Enchantment ench : enchantments.keySet()) {
                if (ench.func_191560_c(this.enchantment.field_76302_b)) continue;
                return false;
            }
            return this.enchantment.field_76302_b.func_92089_a(stack);
        }
        return this.enchantment.field_76302_b.func_92089_a(stack);
    }

    @Override
    protected void completeRitualClient(World world, BlockPos pos, EntityPlayer player) {
    }

    @Override
    protected void completeRitualServer(World world, BlockPos pos, EntityPlayer player) {
        TileEntity altar = world.func_175625_s(pos);
        NBTTagCompound compound = new NBTTagCompound();
        altar.func_189515_b(compound);
        NBTTagCompound nbtItem = compound.func_74775_l("Item");
        if (this.canEnchant(new ItemStack(nbtItem))) {
            ItemStack item = new ItemStack(nbtItem);
            item.func_77966_a(this.enchantment.field_76302_b, this.enchantment.field_76303_c);
            item.func_77955_b(nbtItem);
            compound.func_74782_a("Item", (NBTBase)nbtItem);
        }
        altar.func_145839_a(compound);
    }
}

