/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.Main;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.network.MessageToClientUpdateMerchantScreen;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessageMerchantTradeLimitButton
implements Message<MessageMerchantTradeLimitButton> {
    private int limit;
    private int index;
    private UUID uuid;

    public MessageMerchantTradeLimitButton() {
    }

    public MessageMerchantTradeLimitButton(int index, int limit, UUID uuid) {
        this.index = index;
        this.limit = limit;
        this.uuid = uuid;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        List list = Objects.requireNonNull(context.getSender()).f_19853_.m_45976_(MerchantEntity.class, context.getSender().m_20191_().m_82400_(16.0));
        for (MerchantEntity merchant : list) {
            if (!merchant.m_20148_().equals(this.uuid)) continue;
            merchant.setTradeLimit(this.index, this.limit);
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), (Object)new MessageToClientUpdateMerchantScreen(merchant.WAYPOINTS, merchant.WAYPOINT_ITEMS, merchant.getCurrentTrades(), merchant.getTradeLimits(), merchant.getTraveling(), merchant.getReturning()));
        }
    }

    @Override
    public MessageMerchantTradeLimitButton fromBytes(FriendlyByteBuf buf) {
        this.limit = buf.readInt();
        this.uuid = buf.m_130259_();
        this.index = buf.readInt();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.limit);
        buf.m_130077_(this.uuid);
        buf.writeInt(this.index);
    }
}

