/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.entities.MerchantEntity;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageMerchantHorse
implements Message<MessageMerchantHorse> {
    private UUID worker;

    public MessageMerchantHorse() {
    }

    public MessageMerchantHorse(UUID recruit) {
        this.worker = recruit;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        player.f_19853_.m_6443_(MerchantEntity.class, player.m_20191_().m_82400_(16.0), v -> v.m_20148_().equals(this.worker)).stream().filter(LivingEntity::m_6084_).findAny().ifPresent(this::setTraveling);
    }

    private void setTraveling(MerchantEntity merchant) {
        if (merchant.m_20202_() != null) {
            merchant.m_8127_();
        } else {
            List horseList = merchant.f_19853_.m_45976_(AbstractHorse.class, merchant.m_20191_().m_82400_(16.0));
            horseList.sort(Comparator.comparing(horseInList -> Float.valueOf(horseInList.m_20270_((Entity)merchant))));
            if (merchant.getHorseUUID() == null) {
                for (int i = 0; i < horseList.size(); ++i) {
                    merchant.setHorseUUID(Optional.of(((AbstractHorse)horseList.get(i)).m_20148_()));
                    merchant.m_20329_((Entity)horseList.get(i));
                }
            } else {
                for (AbstractHorse horse : horseList) {
                    if (merchant.getHorseUUID() == null || !horse.m_20148_().equals(merchant.getHorseUUID())) continue;
                    merchant.m_20329_((Entity)horse);
                }
            }
        }
    }

    @Override
    public MessageMerchantHorse fromBytes(FriendlyByteBuf buf) {
        this.worker = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.worker);
    }
}

