/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.CommandEvents;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageChestPos
implements Message<MessageChestPos> {
    private UUID player;
    private UUID worker;
    private BlockPos chestPos;

    public MessageChestPos() {
    }

    public MessageChestPos(UUID player, BlockPos chestPos, UUID worker) {
        this.worker = worker;
        this.player = player;
        this.chestPos = chestPos;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        List list = Objects.requireNonNull(context.getSender()).f_19853_.m_45976_(AbstractWorkerEntity.class, context.getSender().m_20191_().m_82400_(64.0));
        for (AbstractWorkerEntity worker : list) {
            if (!worker.m_20148_().equals(this.worker)) continue;
            CommandEvents.setChestPosWorker(this.player, worker, this.chestPos);
        }
    }

    @Override
    public MessageChestPos fromBytes(FriendlyByteBuf buf) {
        this.player = buf.m_130259_();
        this.worker = buf.m_130259_();
        this.chestPos = buf.m_130135_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        buf.m_130077_(this.worker);
        buf.m_130064_(this.chestPos);
    }
}

