/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai.navigation;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WorkersNodeEvaluator
extends NodeEvaluator {
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;
    protected float oldWaterCost;
    private final Long2ObjectMap<BlockPathTypes> pathTypesByPosCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();

    public void m_6028_(PathNavigationRegion p_77620_, Mob p_77621_) {
        super.m_6028_(p_77620_, p_77621_);
        this.oldWaterCost = p_77621_.m_21439_(BlockPathTypes.WATER);
    }

    public void m_6802_() {
        this.f_77313_.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        this.pathTypesByPosCache.clear();
        this.collisionCache.clear();
        super.m_6802_();
    }

    @Nullable
    public Node m_7171_() {
        int i;
        BlockPos.MutableBlockPos blockpos$mutableblockpos;
        block11: {
            blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            i = this.f_77313_.m_146904_();
            BlockState blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)i, this.f_77313_.m_20189_()));
            if (!this.f_77313_.m_203441_(blockstate.m_60819_())) {
                if (this.m_77361_() && this.f_77313_.m_20069_()) {
                    while (true) {
                        if (!blockstate.m_60713_(Blocks.f_49990_) && blockstate.m_60819_() != Fluids.f_76193_.m_76068_(false)) {
                            --i;
                            break block11;
                        }
                        blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)(++i), this.f_77313_.m_20189_()));
                    }
                }
                if (this.f_77313_.m_20096_()) {
                    i = Mth.m_14107_((double)(this.f_77313_.m_20186_() + 0.5));
                } else {
                    BlockPos blockpos = this.f_77313_.m_20183_();
                    while ((this.f_77312_.m_8055_(blockpos).m_60795_() || this.f_77312_.m_8055_(blockpos).m_60647_((BlockGetter)this.f_77312_, blockpos, PathComputationType.LAND)) && blockpos.m_123342_() > this.f_77313_.f_19853_.m_141937_()) {
                        blockpos = blockpos.m_7495_();
                    }
                    i = blockpos.m_7494_().m_123342_();
                }
            } else {
                while (this.f_77313_.m_203441_(blockstate.m_60819_())) {
                    blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)(++i), this.f_77313_.m_20189_()));
                }
                --i;
            }
        }
        BlockPos blockpos1 = this.f_77313_.m_20183_();
        BlockPathTypes blockpathtypes = this.getCachedBlockType(this.f_77313_, blockpos1.m_123341_(), i, blockpos1.m_123343_());
        if (this.f_77313_.m_21439_(blockpathtypes) < 0.0f) {
            AABB aabb = this.f_77313_.m_20191_();
            if (this.hasPositiveMalus((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82288_, (double)i, aabb.f_82290_)) || this.hasPositiveMalus((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82288_, (double)i, aabb.f_82293_)) || this.hasPositiveMalus((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82291_, (double)i, aabb.f_82290_)) || this.hasPositiveMalus((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82291_, (double)i, aabb.f_82293_))) {
                return this.getStartNode((BlockPos)blockpos$mutableblockpos);
            }
        }
        return this.getStartNode(new BlockPos(blockpos1.m_123341_(), i, blockpos1.m_123343_()));
    }

    @Nullable
    protected Node getStartNode(BlockPos p_230632_) {
        Node node = this.m_77349_(p_230632_);
        if (node != null) {
            node.f_77282_ = this.getBlockPathType(this.f_77313_, node.m_77288_());
            node.f_77281_ = this.f_77313_.m_21439_(node.f_77282_);
        }
        return node;
    }

    private boolean hasPositiveMalus(BlockPos p_77647_) {
        BlockPathTypes blockpathtypes = this.getBlockPathType(this.f_77313_, p_77647_);
        return this.f_77313_.m_21439_(blockpathtypes) >= 0.0f;
    }

    @Nullable
    public Target m_7568_(double p_77550_, double p_77551_, double p_77552_) {
        return this.m_230615_(this.m_5676_(Mth.m_14107_((double)p_77550_), Mth.m_14107_((double)p_77551_), Mth.m_14107_((double)p_77552_)));
    }

    public int m_6065_(Node[] p_77640_, Node p_77641_) {
        Node node7;
        Node node6;
        Node node5;
        Node node4;
        Node node3;
        Node node2;
        Node node1;
        double d0;
        Node node;
        int i = 0;
        int j = 0;
        BlockPathTypes blockpathtypes = this.getCachedBlockType(this.f_77313_, p_77641_.f_77271_, p_77641_.f_77272_ + 1, p_77641_.f_77273_);
        BlockPathTypes blockpathtypes1 = this.getCachedBlockType(this.f_77313_, p_77641_.f_77271_, p_77641_.f_77272_, p_77641_.f_77273_);
        if (this.f_77313_.m_21439_(blockpathtypes) >= 0.0f && blockpathtypes1 != BlockPathTypes.STICKY_HONEY) {
            j = Mth.m_14143_((float)Math.max(1.0f, this.f_77313_.getStepHeight()));
        }
        if (this.isNeighborValid(node = this.findAcceptedNode(p_77641_.f_77271_, p_77641_.f_77272_, p_77641_.f_77273_ + 1, j, d0 = this.getFloorLevel(new BlockPos(p_77641_.f_77271_, p_77641_.f_77272_, p_77641_.f_77273_)), Direction.SOUTH, blockpathtypes1), p_77641_)) {
            p_77640_[i++] = node;
        }
        if (this.isNeighborValid(node1 = this.findAcceptedNode(p_77641_.f_77271_ - 1, p_77641_.f_77272_, p_77641_.f_77273_, j, d0, Direction.WEST, blockpathtypes1), p_77641_)) {
            p_77640_[i++] = node1;
        }
        if (this.isNeighborValid(node2 = this.findAcceptedNode(p_77641_.f_77271_ + 1, p_77641_.f_77272_, p_77641_.f_77273_, j, d0, Direction.EAST, blockpathtypes1), p_77641_)) {
            p_77640_[i++] = node2;
        }
        if (this.isNeighborValid(node3 = this.findAcceptedNode(p_77641_.f_77271_, p_77641_.f_77272_, p_77641_.f_77273_ - 1, j, d0, Direction.NORTH, blockpathtypes1), p_77641_)) {
            p_77640_[i++] = node3;
        }
        if (this.isDiagonalValid(p_77641_, node1, node3, node4 = this.findAcceptedNode(p_77641_.f_77271_ - 1, p_77641_.f_77272_, p_77641_.f_77273_ - 1, j, d0, Direction.NORTH, blockpathtypes1))) {
            p_77640_[i++] = node4;
        }
        if (this.isDiagonalValid(p_77641_, node2, node3, node5 = this.findAcceptedNode(p_77641_.f_77271_ + 1, p_77641_.f_77272_, p_77641_.f_77273_ - 1, j, d0, Direction.NORTH, blockpathtypes1))) {
            p_77640_[i++] = node5;
        }
        if (this.isDiagonalValid(p_77641_, node1, node, node6 = this.findAcceptedNode(p_77641_.f_77271_ - 1, p_77641_.f_77272_, p_77641_.f_77273_ + 1, j, d0, Direction.SOUTH, blockpathtypes1))) {
            p_77640_[i++] = node6;
        }
        if (this.isDiagonalValid(p_77641_, node2, node, node7 = this.findAcceptedNode(p_77641_.f_77271_ + 1, p_77641_.f_77272_, p_77641_.f_77273_ + 1, j, d0, Direction.SOUTH, blockpathtypes1))) {
            p_77640_[i++] = node7;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable Node p_77627_, Node p_77628_) {
        return p_77627_ != null && !p_77627_.f_77279_ && (p_77627_.f_77281_ >= 0.0f || p_77628_.f_77281_ < 0.0f);
    }

    protected boolean isDiagonalValid(Node p_77630_, @Nullable Node p_77631_, @Nullable Node p_77632_, @Nullable Node p_77633_) {
        if (p_77633_ != null && p_77632_ != null && p_77631_ != null) {
            if (p_77633_.f_77279_) {
                return false;
            }
            if (p_77632_.f_77272_ <= p_77630_.f_77272_ && p_77631_.f_77272_ <= p_77630_.f_77272_) {
                if (p_77631_.f_77282_ != BlockPathTypes.WALKABLE_DOOR && p_77632_.f_77282_ != BlockPathTypes.WALKABLE_DOOR && p_77633_.f_77282_ != BlockPathTypes.WALKABLE_DOOR) {
                    boolean flag = p_77632_.f_77282_ == BlockPathTypes.FENCE && p_77631_.f_77282_ == BlockPathTypes.FENCE && (double)this.f_77313_.m_20205_() < 0.5;
                    return p_77633_.f_77281_ >= 0.0f && (p_77632_.f_77272_ < p_77630_.f_77272_ || p_77632_.f_77281_ >= 0.0f || flag) && (p_77631_.f_77272_ < p_77630_.f_77272_ || p_77631_.f_77281_ >= 0.0f || flag);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private static boolean doesBlockHavePartialCollision(BlockPathTypes p_230626_) {
        return p_230626_ == BlockPathTypes.FENCE || p_230626_ == BlockPathTypes.DOOR_WOOD_CLOSED || p_230626_ == BlockPathTypes.DOOR_IRON_CLOSED;
    }

    private boolean canReachWithoutCollision(Node p_77625_) {
        AABB aabb = this.f_77313_.m_20191_();
        Vec3 vec3 = new Vec3((double)p_77625_.f_77271_ - this.f_77313_.m_20185_() + aabb.m_82362_() / 2.0, (double)p_77625_.f_77272_ - this.f_77313_.m_20186_() + aabb.m_82376_() / 2.0, (double)p_77625_.f_77273_ - this.f_77313_.m_20189_() + aabb.m_82385_() / 2.0);
        int i = Mth.m_14165_((double)(vec3.m_82553_() / aabb.m_82309_()));
        vec3 = vec3.m_82490_((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.hasCollisions(aabb = aabb.m_82383_(vec3))) continue;
            return false;
        }
        return true;
    }

    protected double getFloorLevel(BlockPos p_164733_) {
        return WorkersNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, p_164733_);
    }

    public static double getFloorLevel(BlockGetter p_77612_, BlockPos p_77613_) {
        BlockPos blockpos = p_77613_.m_7495_();
        VoxelShape voxelshape = p_77612_.m_8055_(blockpos).m_60812_(p_77612_, blockpos);
        return (double)blockpos.m_123342_() + (voxelshape.m_83281_() ? 0.0 : voxelshape.m_83297_(Direction.Axis.Y));
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected Node findAcceptedNode(int p_164726_, int p_164727_, int p_164728_, int p_164729_, double p_164730_, Direction p_164731_, BlockPathTypes p_164732_) {
        Node node = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        double d0 = this.getFloorLevel((BlockPos)blockpos$mutableblockpos.m_122178_(p_164726_, p_164727_, p_164728_));
        if (d0 - p_164730_ > 1.125) {
            return null;
        }
        BlockPathTypes blockpathtypes = this.getCachedBlockType(this.f_77313_, p_164726_, p_164727_, p_164728_);
        float f = this.f_77313_.m_21439_(blockpathtypes);
        double d1 = (double)this.f_77313_.m_20205_() / 2.0;
        if (f >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(p_164726_, p_164727_, p_164728_, blockpathtypes, f);
        }
        if (WorkersNodeEvaluator.doesBlockHavePartialCollision(p_164732_) && node != null && node.f_77281_ >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (!(blockpathtypes == BlockPathTypes.WALKABLE || this.isAmphibious() && blockpathtypes == BlockPathTypes.WATER)) {
            double d3;
            double d2;
            AABB aabb;
            if ((node == null || node.f_77281_ < 0.0f) && p_164729_ > 0 && blockpathtypes != BlockPathTypes.FENCE && blockpathtypes != BlockPathTypes.UNPASSABLE_RAIL && blockpathtypes != BlockPathTypes.TRAPDOOR && blockpathtypes != BlockPathTypes.POWDER_SNOW && (node = this.findAcceptedNode(p_164726_, p_164727_ + 1, p_164728_, p_164729_ - 1, p_164730_, p_164731_, p_164732_)) != null && (node.f_77282_ == BlockPathTypes.OPEN || node.f_77282_ == BlockPathTypes.WALKABLE) && this.f_77313_.m_20205_() < 1.0f && this.hasCollisions(aabb = new AABB((d2 = (double)(p_164726_ - p_164731_.m_122429_()) + 0.5) - d1, WorkersNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, (BlockPos)blockpos$mutableblockpos.m_122169_(d2, (double)(p_164727_ + 1), d3 = (double)(p_164728_ - p_164731_.m_122431_()) + 0.5)) + 0.001, d3 - d1, d2 + d1, (double)this.f_77313_.m_20206_() + WorkersNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, (BlockPos)blockpos$mutableblockpos.m_122169_((double)node.f_77271_, (double)node.f_77272_, (double)node.f_77273_)) - 0.002, d3 + d1))) {
                node = null;
            }
            if (!this.isAmphibious() && blockpathtypes == BlockPathTypes.WATER && !this.m_77361_()) {
                if (this.getCachedBlockType(this.f_77313_, p_164726_, p_164727_ - 1, p_164728_) != BlockPathTypes.WATER) {
                    return node;
                }
                while (p_164727_ > this.f_77313_.f_19853_.m_141937_()) {
                    if ((blockpathtypes = this.getCachedBlockType(this.f_77313_, p_164726_, --p_164727_, p_164728_)) != BlockPathTypes.WATER) {
                        return node;
                    }
                    node = this.getNodeAndUpdateCostToMax(p_164726_, p_164727_, p_164728_, blockpathtypes, this.f_77313_.m_21439_(blockpathtypes));
                }
            }
            if (blockpathtypes == BlockPathTypes.OPEN) {
                int j = 0;
                int i = p_164727_;
                while (blockpathtypes == BlockPathTypes.OPEN) {
                    if (--p_164727_ < this.f_77313_.f_19853_.m_141937_()) {
                        return this.getBlockedNode(p_164726_, i, p_164728_);
                    }
                    if (j++ >= this.f_77313_.m_6056_()) {
                        return this.getBlockedNode(p_164726_, p_164727_, p_164728_);
                    }
                    blockpathtypes = this.getCachedBlockType(this.f_77313_, p_164726_, p_164727_, p_164728_);
                    f = this.f_77313_.m_21439_(blockpathtypes);
                    if (blockpathtypes != BlockPathTypes.OPEN && f >= 0.0f) {
                        node = this.getNodeAndUpdateCostToMax(p_164726_, p_164727_, p_164728_, blockpathtypes, f);
                        break;
                    }
                    if (!(f < 0.0f)) continue;
                    return this.getBlockedNode(p_164726_, p_164727_, p_164728_);
                }
            }
            if (WorkersNodeEvaluator.doesBlockHavePartialCollision(blockpathtypes) && (node = this.m_5676_(p_164726_, p_164727_, p_164728_)) != null) {
                node.f_77279_ = true;
                node.f_77282_ = blockpathtypes;
                node.f_77281_ = blockpathtypes.m_77124_();
            }
            return node;
        }
        return node;
    }

    @Nullable
    private Node getNodeAndUpdateCostToMax(int p_230620_, int p_230621_, int p_230622_, BlockPathTypes p_230623_, float p_230624_) {
        Node node = this.m_5676_(p_230620_, p_230621_, p_230622_);
        if (node != null) {
            node.f_77282_ = p_230623_;
            node.f_77281_ = Math.max(node.f_77281_, p_230624_);
        }
        return node;
    }

    @Nullable
    private Node getBlockedNode(int p_230628_, int p_230629_, int p_230630_) {
        Node node = this.m_5676_(p_230628_, p_230629_, p_230630_);
        if (node != null) {
            node.f_77282_ = BlockPathTypes.BLOCKED;
            node.f_77281_ = -1.0f;
        }
        return node;
    }

    private boolean hasCollisions(AABB p_77635_) {
        return this.collisionCache.computeIfAbsent((Object)p_77635_, p_192973_ -> !this.f_77312_.m_45756_((Entity)this.f_77313_, p_77635_));
    }

    public BlockPathTypes m_7209_(BlockGetter p_77594_, int p_77595_, int p_77596_, int p_77597_, Mob p_77598_, int p_77599_, int p_77600_, int p_77601_, boolean p_77602_, boolean p_77603_) {
        EnumSet<BlockPathTypes> enumset = EnumSet.noneOf(BlockPathTypes.class);
        BlockPathTypes blockpathtypes = BlockPathTypes.BLOCKED;
        BlockPos blockpos = p_77598_.m_20183_();
        blockpathtypes = this.getBlockPathTypes(p_77594_, p_77595_, p_77596_, p_77597_, p_77599_, p_77600_, p_77601_, p_77602_, p_77603_, enumset, blockpathtypes, blockpos);
        if (enumset.contains(BlockPathTypes.FENCE)) {
            return BlockPathTypes.FENCE;
        }
        if (enumset.contains(BlockPathTypes.UNPASSABLE_RAIL)) {
            return BlockPathTypes.UNPASSABLE_RAIL;
        }
        BlockPathTypes blockpathtypes1 = BlockPathTypes.BLOCKED;
        for (BlockPathTypes blockpathtypes2 : enumset) {
            if (p_77598_.m_21439_(blockpathtypes2) < 0.0f) {
                return blockpathtypes2;
            }
            if (!(p_77598_.m_21439_(blockpathtypes2) >= p_77598_.m_21439_(blockpathtypes1))) continue;
            blockpathtypes1 = blockpathtypes2;
        }
        return blockpathtypes == BlockPathTypes.OPEN && p_77598_.m_21439_(blockpathtypes1) == 0.0f && p_77599_ <= 1 ? BlockPathTypes.OPEN : blockpathtypes1;
    }

    public BlockPathTypes getBlockPathTypes(BlockGetter p_77581_, int p_77582_, int p_77583_, int p_77584_, int p_77585_, int p_77586_, int p_77587_, boolean p_77588_, boolean p_77589_, EnumSet<BlockPathTypes> p_77590_, BlockPathTypes p_77591_, BlockPos p_77592_) {
        for (int i = 0; i < p_77585_; ++i) {
            for (int j = 0; j < p_77586_; ++j) {
                for (int k = 0; k < p_77587_; ++k) {
                    int l = i + p_77582_;
                    int i1 = j + p_77583_;
                    int j1 = k + p_77584_;
                    BlockPathTypes blockpathtypes = this.m_8086_(p_77581_, l, i1, j1);
                    blockpathtypes = this.evaluateBlockPathType(p_77581_, p_77588_, p_77589_, p_77592_, blockpathtypes);
                    if (i == 0 && j == 0 && k == 0) {
                        p_77591_ = blockpathtypes;
                    }
                    p_77590_.add(blockpathtypes);
                }
            }
        }
        return p_77591_;
    }

    protected BlockPathTypes evaluateBlockPathType(BlockGetter p_77614_, boolean p_77615_, boolean p_77616_, BlockPos p_77617_, BlockPathTypes p_77618_) {
        if (p_77618_ == BlockPathTypes.DOOR_WOOD_CLOSED && p_77615_ && p_77616_) {
            p_77618_ = BlockPathTypes.WALKABLE_DOOR;
        }
        if (p_77618_ == BlockPathTypes.DOOR_OPEN && !p_77616_) {
            p_77618_ = BlockPathTypes.BLOCKED;
        }
        if (p_77618_ == BlockPathTypes.RAIL && !(p_77614_.m_8055_(p_77617_).m_60734_() instanceof BaseRailBlock) && !(p_77614_.m_8055_(p_77617_.m_7495_()).m_60734_() instanceof BaseRailBlock)) {
            p_77618_ = BlockPathTypes.UNPASSABLE_RAIL;
        }
        if (p_77618_ == BlockPathTypes.LEAVES) {
            p_77618_ = BlockPathTypes.BLOCKED;
        }
        return p_77618_;
    }

    private BlockPathTypes getBlockPathType(Mob p_77573_, BlockPos p_77574_) {
        return this.getCachedBlockType(p_77573_, p_77574_.m_123341_(), p_77574_.m_123342_(), p_77574_.m_123343_());
    }

    protected BlockPathTypes getCachedBlockType(Mob p_77568_, int p_77569_, int p_77570_, int p_77571_) {
        return (BlockPathTypes)this.pathTypesByPosCache.computeIfAbsent(BlockPos.m_121882_((int)p_77569_, (int)p_77570_, (int)p_77571_), p_77566_ -> this.m_7209_((BlockGetter)this.f_77312_, p_77569_, p_77570_, p_77571_, p_77568_, this.f_77315_, this.f_77316_, this.f_77317_, this.m_77360_(), this.m_77357_()));
    }

    public BlockPathTypes m_8086_(BlockGetter p_77576_, int p_77577_, int p_77578_, int p_77579_) {
        return WorkersNodeEvaluator.getBlockPathTypeStatic(p_77576_, new BlockPos.MutableBlockPos(p_77577_, p_77578_, p_77579_));
    }

    public static BlockPathTypes getBlockPathTypeStatic(BlockGetter p_77605_, BlockPos.MutableBlockPos p_77606_) {
        int i = p_77606_.m_123341_();
        int j = p_77606_.m_123342_();
        int k = p_77606_.m_123343_();
        BlockPathTypes blockpathtypes = WorkersNodeEvaluator.getBlockPathTypeRaw(p_77605_, (BlockPos)p_77606_);
        if (blockpathtypes == BlockPathTypes.OPEN && j >= p_77605_.m_141937_() + 1) {
            BlockPathTypes blockpathtypes1 = WorkersNodeEvaluator.getBlockPathTypeRaw(p_77605_, (BlockPos)p_77606_.m_122178_(i, j - 1, k));
            BlockPathTypes blockPathTypes = blockpathtypes = blockpathtypes1 != BlockPathTypes.WALKABLE && blockpathtypes1 != BlockPathTypes.OPEN && blockpathtypes1 != BlockPathTypes.WATER && blockpathtypes1 != BlockPathTypes.LAVA ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
            if (blockpathtypes1 == BlockPathTypes.DAMAGE_FIRE) {
                blockpathtypes = BlockPathTypes.DAMAGE_FIRE;
            }
            if (blockpathtypes1 == BlockPathTypes.DAMAGE_CACTUS) {
                blockpathtypes = BlockPathTypes.DAMAGE_CACTUS;
            }
            if (blockpathtypes1 == BlockPathTypes.DAMAGE_OTHER) {
                blockpathtypes = BlockPathTypes.DAMAGE_OTHER;
            }
            if (blockpathtypes1 == BlockPathTypes.STICKY_HONEY) {
                blockpathtypes = BlockPathTypes.STICKY_HONEY;
            }
            if (blockpathtypes1 == BlockPathTypes.POWDER_SNOW) {
                blockpathtypes = BlockPathTypes.DANGER_POWDER_SNOW;
            }
        }
        if (blockpathtypes == BlockPathTypes.WALKABLE) {
            blockpathtypes = WorkersNodeEvaluator.checkNeighbourBlocks(p_77605_, p_77606_.m_122178_(i, j, k), blockpathtypes);
        }
        return blockpathtypes;
    }

    public static BlockPathTypes checkNeighbourBlocks(BlockGetter p_77608_, BlockPos.MutableBlockPos p_77609_, BlockPathTypes p_77610_) {
        int i = p_77609_.m_123341_();
        int j = p_77609_.m_123342_();
        int k = p_77609_.m_123343_();
        for (int l = -1; l <= 1; ++l) {
            for (int i1 = -1; i1 <= 1; ++i1) {
                for (int j1 = -1; j1 <= 1; ++j1) {
                    if (l == 0 && j1 == 0) continue;
                    p_77609_.m_122178_(i + l, j + i1, k + j1);
                    BlockState blockstate = p_77608_.m_8055_((BlockPos)p_77609_);
                    BlockPathTypes blockPathType = blockstate.getAdjacentBlockPathType(p_77608_, (BlockPos)p_77609_, null, p_77610_);
                    if (blockPathType != null) {
                        return blockPathType;
                    }
                    FluidState fluidState = blockstate.m_60819_();
                    BlockPathTypes fluidPathType = fluidState.getAdjacentBlockPathType(p_77608_, (BlockPos)p_77609_, null, p_77610_);
                    if (fluidPathType != null) {
                        return fluidPathType;
                    }
                    if (blockstate.m_60713_(Blocks.f_50128_)) {
                        return BlockPathTypes.DANGER_CACTUS;
                    }
                    if (blockstate.m_60713_(Blocks.f_50685_)) {
                        return BlockPathTypes.DANGER_OTHER;
                    }
                    if (WorkersNodeEvaluator.isBurningBlock(blockstate)) {
                        return BlockPathTypes.DANGER_FIRE;
                    }
                    if (!p_77608_.m_6425_((BlockPos)p_77609_).m_205070_(FluidTags.f_13131_)) continue;
                    return BlockPathTypes.WATER_BORDER;
                }
            }
        }
        return p_77610_;
    }

    protected static BlockPathTypes getBlockPathTypeRaw(BlockGetter p_77644_, BlockPos p_77645_) {
        BlockState blockstate = p_77644_.m_8055_(p_77645_);
        BlockPathTypes type = blockstate.getBlockPathType(p_77644_, p_77645_, null);
        if (type != null) {
            return type;
        }
        Block block = blockstate.m_60734_();
        Material material = blockstate.m_60767_();
        if (blockstate.m_60795_()) {
            return BlockPathTypes.OPEN;
        }
        if (!(blockstate.m_204336_(BlockTags.f_13036_) || blockstate.m_60713_(Blocks.f_50196_) || blockstate.m_60713_(Blocks.f_152545_))) {
            if (blockstate.m_60713_(Blocks.f_152499_)) {
                return BlockPathTypes.POWDER_SNOW;
            }
            if (blockstate.m_60713_(Blocks.f_50128_)) {
                return BlockPathTypes.DAMAGE_CACTUS;
            }
            if (blockstate.m_60713_(Blocks.f_50685_)) {
                return BlockPathTypes.DAMAGE_OTHER;
            }
            if (blockstate.m_60713_(Blocks.f_50719_)) {
                return BlockPathTypes.STICKY_HONEY;
            }
            if (blockstate.m_60713_(Blocks.f_50262_)) {
                return BlockPathTypes.COCOA;
            }
            FluidState fluidstate = p_77644_.m_6425_(p_77645_);
            BlockPathTypes nonLoggableFluidPathType = fluidstate.getBlockPathType(p_77644_, p_77645_, null, false);
            if (nonLoggableFluidPathType != null) {
                return nonLoggableFluidPathType;
            }
            if (fluidstate.m_205070_(FluidTags.f_13132_)) {
                return BlockPathTypes.LAVA;
            }
            if (WorkersNodeEvaluator.isBurningBlock(blockstate)) {
                return BlockPathTypes.DAMAGE_FIRE;
            }
            if (DoorBlock.m_52817_((BlockState)blockstate) && !((Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                return BlockPathTypes.DOOR_WOOD_CLOSED;
            }
            if (block instanceof FenceGateBlock && !((Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                return BlockPathTypes.DOOR_WOOD_CLOSED;
            }
            if (block instanceof DoorBlock && material == Material.f_76279_ && !((Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                return BlockPathTypes.DOOR_IRON_CLOSED;
            }
            if (block instanceof DoorBlock && ((Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                return BlockPathTypes.DOOR_OPEN;
            }
            if (block instanceof FenceGateBlock && ((Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                return BlockPathTypes.DOOR_OPEN;
            }
            if (block instanceof BaseRailBlock) {
                return BlockPathTypes.RAIL;
            }
            if (block instanceof LeavesBlock) {
                return BlockPathTypes.LEAVES;
            }
            if (!(blockstate.m_204336_(BlockTags.f_13039_) || blockstate.m_204336_(BlockTags.f_13032_) || block instanceof FenceGateBlock && !((Boolean)blockstate.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue())) {
                if (!blockstate.m_60647_(p_77644_, p_77645_, PathComputationType.LAND)) {
                    return BlockPathTypes.BLOCKED;
                }
                BlockPathTypes loggableFluidPathType = fluidstate.getBlockPathType(p_77644_, p_77645_, null, true);
                if (loggableFluidPathType != null) {
                    return loggableFluidPathType;
                }
                return fluidstate.m_205070_(FluidTags.f_13131_) ? BlockPathTypes.WATER : BlockPathTypes.OPEN;
            }
            return BlockPathTypes.FENCE;
        }
        return BlockPathTypes.TRAPDOOR;
    }

    public static boolean isBurningBlock(BlockState p_77623_) {
        return p_77623_.m_204336_(BlockTags.f_13076_) || p_77623_.m_60713_(Blocks.f_49991_) || p_77623_.m_60713_(Blocks.f_50450_) || CampfireBlock.m_51319_((BlockState)p_77623_) || p_77623_.m_60713_(Blocks.f_152477_);
    }
}

