/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai.navigation;

import com.talhanation.workers.Main;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.IBoatController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SailorNavigator {
    private List<BlockPos> list;
    private final ServerLevel level;
    private BlockPos targetPos;
    public BlockPos currentPos;
    private int currentNodeIndex;
    private static final int RANGE = 528;
    private final AbstractWorkerEntity worker;
    private final IBoatController sailor;
    private int timer;
    private boolean isDone;

    public SailorNavigator(IBoatController sailor, ServerLevel level) {
        this.level = level;
        this.sailor = sailor;
        this.worker = sailor.getWorker();
    }

    public List<BlockPos> createPath() {
        this.targetPos = this.sailor.getSailPos();
        this.list = new ArrayList<BlockPos>();
        this.currentPos = this.worker.m_20097_();
        this.currentNodeIndex = 0;
        this.isDone = false;
        this.resetTimeOut();
        if (this.currentPos != null) {
            for (int i = 0; i < 528; ++i) {
                this.currentPos = this.findNextValidNode(this.currentPos);
                if (this.currentPos == this.targetPos) break;
                if (this.currentPos == null) continue;
                this.list.add(this.currentPos);
            }
        }
        for (BlockPos pos : this.list) {
            this.level.m_7731_(pos.m_6630_(2), Blocks.f_50126_.m_49966_(), 3);
        }
        Main.LOGGER.info("Path Created: ");
        Main.LOGGER.info("Path size: " + this.list.size());
        Main.LOGGER.info("Target Pos: " + this.targetPos);
        Main.LOGGER.info("Distance to target: " + this.getWorkerDistanceToTarget());
        return this.list;
    }

    private void resetTimeOut() {
        this.timer = 200;
    }

    private BlockPos findNextValidNode(BlockPos current) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        ArrayList<BlockPos> validPos = new ArrayList<BlockPos>();
        if (current != null) {
            list.add(current.m_122013_(1));
            list.add(current.m_122020_(1));
            list.add(current.m_122030_(1));
            list.add(current.m_122025_(1));
            list.add(current.m_122030_(1).m_122020_(1));
            list.add(current.m_122025_(1).m_122020_(1));
            list.add(current.m_122030_(1).m_122013_(1));
            list.add(current.m_122025_(1).m_122013_(1));
        }
        for (BlockPos pos2 : list) {
            if (!this.isValidWaterPos(pos2)) continue;
            validPos.add(pos2);
        }
        if (validPos.isEmpty()) {
            for (BlockPos pos2 : list) {
                if (!this.isValidWaterPosEasy(pos2)) continue;
                validPos.add(pos2);
            }
            validPos.sort(Comparator.comparing(pos -> this.getDistanceToPos(this.targetPos, (BlockPos)pos)));
            return (BlockPos)validPos.get(this.worker.m_217043_().m_188503_(validPos.size() - 1));
        }
        validPos.sort(Comparator.comparing(pos -> this.getDistanceToPos(this.targetPos, (BlockPos)pos)));
        if (validPos.isEmpty()) {
            return null;
        }
        return (BlockPos)validPos.get(0);
    }

    public double getWorkerDistanceToTarget() {
        return this.targetPos != null ? Vec3.m_82512_((Vec3i)this.targetPos).m_82557_(this.worker.m_20182_()) : 0.0;
    }

    public boolean isValidWaterPos(BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        if (state.m_60713_(Blocks.f_49990_)) {
            BlockState stateNorth = this.worker.m_9236_().m_8055_(pos.m_122012_());
            BlockState stateEast = this.worker.m_9236_().m_8055_(pos.m_122029_());
            BlockState stateSouth = this.worker.m_9236_().m_8055_(pos.m_122019_());
            BlockState stateWest = this.worker.m_9236_().m_8055_(pos.m_122024_());
            return stateNorth.m_60713_(Blocks.f_49990_) && stateEast.m_60713_(Blocks.f_49990_) && stateSouth.m_60713_(Blocks.f_49990_) && stateWest.m_60713_(Blocks.f_49990_);
        }
        return false;
    }

    public boolean isValidWaterPosEasy(BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        return state.m_60713_(Blocks.f_49990_);
    }

    public void tick() {
        double distance;
        if (!this.isDone() && (distance = this.getWorkerDistanceToTarget()) <= 3.0) {
            this.isDone = true;
        }
    }

    public void advance() {
        ++this.currentNodeIndex;
        this.resetTimeOut();
        this.currentPos = this.list.get(this.currentNodeIndex - 1);
    }

    public void setTargetPos(BlockPos pos) {
        this.targetPos = pos;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public int getCurrentNodeIndex() {
        return this.currentNodeIndex;
    }

    public int getNextNodeIndex() {
        return this.currentNodeIndex + 1;
    }

    public double getDistanceToPos(BlockPos target, BlockPos currentPos) {
        return this.getDistanceToPos(Vec3.m_82512_((Vec3i)target), Vec3.m_82512_((Vec3i)currentPos));
    }

    public double getDistanceToPos(Vec3 target, Vec3 currentPos) {
        return currentPos.m_82557_(target);
    }
}

