/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.Translatable;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SleepGoal
extends Goal {
    private final AbstractWorkerEntity worker;
    private final MutableComponent NEED_BED = Component.m_237115_((String)"chat.workers.needBed");
    private final MutableComponent CANT_FIND_BED = Component.m_237115_((String)"chat.workers.cantFindBed");
    private final MutableComponent BED_OCCUPIED = Component.m_237115_((String)"chat.workers.bedOccupied");
    private boolean messageCantFindBed;
    private boolean messageBedOccupied;
    private boolean noBed;

    public SleepGoal(AbstractWorkerEntity worker) {
        this.worker = worker;
    }

    public boolean m_8036_() {
        return this.worker.getStatus() == AbstractWorkerEntity.Status.SLEEP && (!this.noBed || this.worker.getBedPos() != null);
    }

    public boolean m_8045_() {
        return this.worker.needsToSleep() && this.worker.getStatus() != AbstractWorkerEntity.Status.FOLLOW;
    }

    public void m_8056_() {
        super.m_8056_();
        this.messageCantFindBed = true;
        this.messageBedOccupied = true;
        if (this.worker.getBedPos() == null) {
            if (this.worker.m_21826_() != null) {
                this.worker.tellPlayer(this.worker.m_21826_(), Translatable.NEED_BED);
            }
            this.noBed = true;
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.worker.m_5796_();
        this.worker.m_21258_();
        if (this.worker.getStatus() != AbstractWorkerEntity.Status.FOLLOW) {
            this.worker.setStatus(AbstractWorkerEntity.Status.IDLE);
        }
        this.worker.shouldDepositBeforeSleep = true;
    }

    public void m_8037_() {
        if (this.worker.m_5803_()) {
            this.worker.m_21573_().m_26573_();
            if (this.worker.needsToSleep()) {
                this.worker.m_5634_(0.025f);
            }
            return;
        }
        BlockPos sleepPos = this.worker.getBedPos();
        if (sleepPos != null) {
            LivingEntity owner = this.worker.m_21826_();
            BlockEntity bedEntity = this.worker.f_19853_.m_7702_(sleepPos);
            if (bedEntity == null || !bedEntity.m_58900_().isBed((BlockGetter)this.worker.f_19853_, sleepPos, (LivingEntity)this.worker)) {
                if (this.messageCantFindBed && owner != null) {
                    this.worker.tellPlayer(owner, (Component)this.CANT_FIND_BED);
                    this.messageCantFindBed = false;
                    this.noBed = true;
                }
                return;
            }
            if (((Boolean)bedEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61445_)).booleanValue()) {
                if (this.messageBedOccupied) {
                    if (owner != null) {
                        this.worker.tellPlayer(owner, (Component)this.BED_OCCUPIED);
                    }
                    this.messageBedOccupied = false;
                    this.noBed = true;
                }
            } else {
                this.goToBed(sleepPos);
            }
        }
    }

    private void goToBed(BlockPos bedPos) {
        if (bedPos == null) {
            return;
        }
        PathNavigation pathFinder = this.worker.m_21573_();
        pathFinder.m_26519_((double)bedPos.m_123341_(), (double)bedPos.m_123342_(), (double)bedPos.m_123343_(), 1.1);
        this.worker.m_21563_().m_24950_((double)bedPos.m_123341_(), (double)(bedPos.m_123342_() + 1), (double)bedPos.m_123343_(), 10.0f, (float)this.worker.m_8132_());
        if (bedPos.m_123333_((Vec3i)this.worker.getWorkerOnPos()) <= 5) {
            this.worker.m_5802_(bedPos);
            this.worker.m_21250_(bedPos);
            pathFinder.m_26573_();
        }
    }
}

