/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.RabbitFarmerEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class RabbitFarmerAI
extends Goal {
    private Optional<Rabbit> rabbit;
    private final RabbitFarmerEntity rabbitFarmer;
    private boolean breeding;
    private boolean slaughtering;
    private BlockPos workPos;

    public RabbitFarmerAI(RabbitFarmerEntity worker) {
        this.rabbitFarmer = worker;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rabbitFarmer.getStatus() == AbstractWorkerEntity.Status.WORK;
    }

    public void m_8056_() {
        super.m_8056_();
        this.workPos = this.rabbitFarmer.getStartPos();
        this.breeding = true;
        this.slaughtering = false;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.workPos != null && !this.workPos.m_123314_((Vec3i)this.rabbitFarmer.m_20097_(), 10.0)) {
            this.rabbitFarmer.m_21573_().m_26519_((double)this.workPos.m_123341_(), (double)this.workPos.m_123342_(), (double)this.workPos.m_123343_(), 1.0);
        }
        if (this.breeding) {
            this.rabbit = this.findRabbitBreeding();
            if (this.rabbit.isPresent()) {
                int i = this.rabbit.get().m_146764_();
                if (i == 0 && this.hasSeeds()) {
                    this.rabbitFarmer.m_21573_().m_5624_((Entity)this.rabbit.get(), 1.0);
                    this.rabbitFarmer.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42404_));
                    if (this.rabbit.get().m_19950_((Entity)this.rabbitFarmer, 1.5)) {
                        this.consumeSeed();
                        this.rabbitFarmer.m_21563_().m_24950_(this.rabbit.get().m_20185_(), this.rabbit.get().m_20188_(), this.rabbit.get().m_20189_(), 10.0f, (float)this.rabbitFarmer.m_8132_());
                        this.rabbit.get().m_27595_(null);
                        this.rabbit = Optional.empty();
                    }
                } else {
                    this.breeding = false;
                    this.slaughtering = true;
                    this.rabbitFarmer.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                }
            } else {
                this.breeding = false;
                this.slaughtering = true;
                this.rabbitFarmer.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
        if (this.slaughtering) {
            List<Rabbit> rabbits = this.findRabbitSlaughtering();
            if (rabbits.size() > this.rabbitFarmer.getMaxAnimalCount()) {
                this.rabbit = rabbits.stream().findFirst();
                if (this.rabbit.isPresent()) {
                    this.rabbitFarmer.m_21573_().m_26519_(this.rabbit.get().m_20185_(), this.rabbit.get().m_20186_(), this.rabbit.get().m_20189_(), 1.0);
                    if (this.rabbit.get().m_19950_((Entity)this.rabbitFarmer, 1.5)) {
                        this.rabbit.get().m_6074_();
                        this.rabbitFarmer.workerSwingArm();
                    }
                }
            } else {
                this.slaughtering = false;
                this.breeding = true;
            }
        }
    }

    private void consumeSeed() {
        SimpleContainer inventory = this.rabbitFarmer.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(Items.f_41939_) && !itemStack.m_41720_().equals(Items.f_42619_) && !itemStack.m_41720_().equals(Items.f_42677_)) continue;
            itemStack.m_41774_(1);
            break;
        }
    }

    private Optional<Rabbit> findRabbitBreeding() {
        return this.rabbitFarmer.f_19853_.m_6443_(Rabbit.class, this.rabbitFarmer.m_20191_().m_82400_(8.0), LivingEntity::m_6084_).stream().filter(((Predicate<Rabbit>)AgeableMob::m_6162_).negate()).filter(((Predicate<Rabbit>)Animal::m_27593_).negate()).findAny();
    }

    private List<Rabbit> findRabbitSlaughtering() {
        return this.rabbitFarmer.f_19853_.m_6443_(Rabbit.class, this.rabbitFarmer.m_20191_().m_82400_(8.0), LivingEntity::m_6084_).stream().filter(((Predicate<Rabbit>)AgeableMob::m_6162_).negate()).filter(((Predicate<Rabbit>)Animal::m_27593_).negate()).collect(Collectors.toList());
    }

    private boolean hasSeeds() {
        SimpleContainer inventory = this.rabbitFarmer.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(Items.f_41939_) && !itemStack.m_41720_().equals(Items.f_42619_) && !itemStack.m_41720_().equals(Items.f_42677_) || itemStack.m_41613_() < 2) continue;
            return true;
        }
        return false;
    }
}

