/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.google.common.collect.ImmutableSet;
import com.talhanation.workers.Translatable;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.MinerEntity;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class MinerAI
extends Goal {
    private final MinerEntity miner;
    private BlockPos minePos;
    private MineType mineType;
    private WorkState workState;
    private boolean messageNoPickaxe;
    private boolean messageNoShovel;

    public MinerAI(MinerEntity miner) {
        this.miner = miner;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        BlockPos pos = this.miner.getStartPos();
        int type = this.miner.getMineType();
        return this.miner.getStatus() == AbstractWorkerEntity.Status.WORK && type != 0 && pos != null;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.miner.resetWorkerParameters();
        this.miner.resetCounts();
        this.mineType = this.getMineType();
        this.workState = WorkState.IDLE;
        this.messageNoPickaxe = false;
        this.messageNoShovel = false;
    }

    public void done() {
        if (this.miner.m_21826_() != null) {
            this.miner.tellPlayer(this.miner.m_21826_(), Translatable.TEXT_DONE);
        }
        this.miner.clearStartPos();
        this.resetGoal();
    }

    public void resetGoal() {
        this.miner.resetCounts();
        this.miner.setChecked(false);
        this.miner.setStatus(AbstractWorkerEntity.Status.IDLE);
    }

    public void m_8037_() {
        switch (this.workState) {
            case IDLE: {
                if (this.miner.getStartPos() == null) break;
                this.workState = WorkState.TO_WORK_POS;
                break;
            }
            case TO_WORK_POS: {
                this.miner.m_21573_().m_26519_((double)this.miner.getStartPos().m_123341_(), (double)this.miner.getStartPos().m_123342_(), (double)this.miner.getStartPos().m_123343_(), 1.0);
                if (!this.miner.getStartPos().m_123314_((Vec3i)this.miner.m_20097_(), 3.0)) break;
                this.workState = WorkState.WORKING;
                break;
            }
            case WORKING: {
                if (this.miner.isPickingUp) break;
                this.working();
                break;
            }
            case DONE: {
                if (!this.miner.getChecked()) {
                    this.miner.resetCounts();
                    this.miner.setChecked(true);
                    this.workState = WorkState.WORKING;
                    break;
                }
                this.walkTowards(this.miner.getStartPos());
                if (!this.miner.getStartPos().m_123314_((Vec3i)this.miner.m_20097_(), 4.0)) break;
                this.done();
                this.workState = WorkState.IDLE;
            }
        }
    }

    private void working() {
        if (!this.miner.hasMainToolInInv()) {
            if (!this.messageNoPickaxe && this.miner.m_21826_() != null) {
                this.miner.tellPlayer(this.miner.m_21826_(), Translatable.TEXT_NO_PICKAXE);
                this.messageNoPickaxe = true;
            }
            this.miner.needsMainTool = true;
            return;
        }
        if (!this.miner.hasSecondToolInInv()) {
            if (!this.messageNoShovel && this.miner.m_21826_() != null) {
                this.miner.tellPlayer(this.miner.m_21826_(), Translatable.TEXT_OUT_OF_TOOLS());
                this.messageNoShovel = true;
            }
            this.miner.needsSecondTool = true;
            return;
        }
        if (this.miner.getMineDirection().equals((Object)Direction.EAST)) {
            this.minePos = new BlockPos(this.miner.getStartPos().m_123341_() + this.miner.blocks, this.miner.getStartPos().m_123342_() - this.miner.depth, this.miner.getStartPos().m_123343_() - this.miner.side);
        } else if (this.miner.getMineDirection().equals((Object)Direction.WEST)) {
            this.minePos = new BlockPos(this.miner.getStartPos().m_123341_() - this.miner.blocks, this.miner.getStartPos().m_123342_() - this.miner.depth, this.miner.getStartPos().m_123343_() + this.miner.side);
        } else if (this.miner.getMineDirection().equals((Object)Direction.NORTH)) {
            this.minePos = new BlockPos(this.miner.getStartPos().m_123341_() - this.miner.side, this.miner.getStartPos().m_123342_() - this.miner.depth, this.miner.getStartPos().m_123343_() - this.miner.blocks);
        } else if (this.miner.getMineDirection().equals((Object)Direction.SOUTH)) {
            this.minePos = new BlockPos(this.miner.getStartPos().m_123341_() + this.miner.side, this.miner.getStartPos().m_123342_() - this.miner.depth, this.miner.getStartPos().m_123343_() + this.miner.blocks);
        }
        this.walkTowards(this.minePos);
        if (this.miner.m_20193_().m_45524_(this.miner.m_20097_().m_7494_(), 0) <= 7) {
            BlockState onPosState = this.miner.m_20193_().m_8055_(this.miner.m_20097_());
            BlockState stateAbove = this.miner.m_20193_().m_8055_(this.miner.m_20097_().m_7494_());
            if (stateAbove.m_60795_() && !onPosState.m_60795_()) {
                this.placeTorch();
            }
        }
        if (this.minePos.m_123314_((Vec3i)this.miner.m_20097_(), 3.0)) {
            this.miner.m_21563_().m_24950_((double)this.minePos.m_123341_(), (double)(this.minePos.m_123342_() + 1), (double)this.minePos.m_123343_(), 10.0f, (float)this.miner.m_8132_());
        }
        BlockState blockstate = this.miner.f_19853_.m_8055_(this.minePos);
        Block block1 = blockstate.m_60734_();
        AttributeInstance movSpeed = this.miner.m_21051_(Attributes.f_22279_);
        if (movSpeed != null) {
            movSpeed.m_22100_(0.3);
        }
        if (this.minePos.m_123314_((Vec3i)this.miner.m_20097_(), 6.0)) {
            if (this.mineBlock(this.minePos)) {
                if (block1 instanceof FallingBlock || block1 instanceof Fallable) {
                    this.miner.blocks /= 2;
                    this.miner.side /= 2;
                    this.miner.depth /= 2;
                }
                this.miner.increaseFarmedItems();
            }
            switch (this.mineType) {
                case PIT_8X8X8: {
                    if (this.miner.shouldIgnoreBlock(blockstate) || block1 == Blocks.f_50705_) {
                        ++this.miner.blocks;
                        if (block1 != Blocks.f_50705_) {
                            this.placePlanks(blockstate);
                        }
                    }
                    if (this.miner.blocks == 8) {
                        this.miner.blocks = 0;
                        ++this.miner.side;
                    }
                    if (this.miner.side == 8) {
                        this.miner.side = 0;
                        ++this.miner.depth;
                    }
                    if (this.miner.depth < 8) break;
                    this.workState = WorkState.DONE;
                    break;
                }
                case ROOM_8X8X3: {
                    if (this.miner.shouldIgnoreBlock(blockstate)) {
                        --this.miner.depth;
                    }
                    if (this.miner.depth == -3) {
                        this.miner.depth = 0;
                        ++this.miner.side;
                    }
                    if (this.miner.side == 8) {
                        this.miner.side = 0;
                        ++this.miner.blocks;
                    }
                    if (this.miner.blocks < 8) break;
                    this.workState = WorkState.DONE;
                    break;
                }
                case FLAT_8X8X1: {
                    if (this.miner.shouldIgnoreBlock(blockstate)) {
                        ++this.miner.blocks;
                    }
                    if (this.miner.blocks == 8) {
                        this.miner.blocks = 0;
                        ++this.miner.side;
                    }
                    if (this.miner.side < 8) break;
                    this.workState = WorkState.DONE;
                    break;
                }
                case PIT_16X16X16: {
                    if (this.miner.shouldIgnoreBlock(blockstate) || block1 == Blocks.f_50705_) {
                        ++this.miner.blocks;
                        if (block1 != Blocks.f_50705_) {
                            this.placePlanks(blockstate);
                        }
                    }
                    if (this.miner.blocks == 16) {
                        this.miner.blocks = 0;
                        ++this.miner.side;
                    }
                    if (this.miner.side == 16) {
                        this.miner.side = 0;
                        ++this.miner.depth;
                    }
                    if (this.miner.depth < 16) break;
                    this.workState = WorkState.DONE;
                    break;
                }
                case ROOM_16X16X3: {
                    if (this.miner.shouldIgnoreBlock(blockstate)) {
                        --this.miner.depth;
                    }
                    if (this.miner.depth == -3) {
                        this.miner.depth = 0;
                        ++this.miner.side;
                    }
                    if (this.miner.side == 16) {
                        this.miner.side = 0;
                        ++this.miner.blocks;
                    }
                    if (this.miner.blocks < 16) break;
                    this.workState = WorkState.DONE;
                    break;
                }
                case FLAT_16X16X1: {
                    if (this.miner.shouldIgnoreBlock(blockstate)) {
                        ++this.miner.blocks;
                    }
                    if (this.miner.blocks == 16) {
                        this.miner.blocks = 0;
                        ++this.miner.side;
                    }
                    if (this.miner.side < 16) break;
                    this.workState = WorkState.DONE;
                    break;
                }
                case TUNNEL_3X3: {
                    if (this.miner.shouldIgnoreBlock(blockstate)) {
                        --this.miner.depth;
                    }
                    if (this.miner.depth == -3) {
                        this.miner.depth = 0;
                        ++this.miner.side;
                    }
                    if (this.miner.side == 3) {
                        this.miner.side = 0;
                        ++this.miner.blocks;
                    }
                    if (this.miner.blocks < this.miner.getMineDepth()) break;
                    this.workState = WorkState.DONE;
                    break;
                }
                case TUNNEL_1X2: {
                    if (this.miner.shouldIgnoreBlock(blockstate)) {
                        --this.miner.depth;
                    }
                    if (this.miner.depth == -2) {
                        this.miner.depth = 0;
                        ++this.miner.blocks;
                    }
                    if (this.miner.blocks < this.miner.getMineDepth()) break;
                    this.workState = WorkState.DONE;
                }
            }
        }
    }

    private void walkTowards(BlockPos minePos) {
        BlockPos workerPos = this.miner.m_20097_();
        int heightDiff = Math.abs(workerPos.m_123342_() - minePos.m_123342_());
        double distance = this.miner.m_20275_(minePos.m_123341_(), minePos.m_123342_(), minePos.m_123343_());
        if (heightDiff >= 4) {
            this.miner.walkTowards(minePos, 1.0);
        } else if (distance > 6.0) {
            this.miner.m_21566_().m_6849_((double)minePos.m_123341_(), (double)this.miner.m_20097_().m_123342_(), (double)minePos.m_123343_(), 1.0);
        } else {
            this.miner.m_21573_().m_26573_();
        }
    }

    private MineType getMineType() {
        return switch (this.miner.getMineType()) {
            case 1 -> MineType.TUNNEL_1X2;
            case 2 -> MineType.TUNNEL_3X3;
            case 3 -> MineType.PIT_8X8X8;
            case 4 -> MineType.FLAT_8X8X1;
            case 5 -> MineType.ROOM_8X8X3;
            case 6 -> MineType.PIT_16X16X16;
            case 7 -> MineType.FLAT_16X16X1;
            case 8 -> MineType.ROOM_16X16X3;
            default -> throw new IllegalStateException("Unexpected value: " + this.miner.getMineType());
        };
    }

    private boolean mineBlock(BlockPos blockPos) {
        if (this.miner.m_6084_() && ForgeEventFactory.getMobGriefingEvent((Level)this.miner.f_19853_, (Entity)this.miner)) {
            BlockState blockstate = this.miner.f_19853_.m_8055_(blockPos);
            this.miner.changeTool(blockstate);
            ItemStack heldItem = this.miner.m_21120_(InteractionHand.MAIN_HAND);
            if (!this.miner.shouldIgnoreBlock(blockstate)) {
                if (this.miner.getCurrentTimeBreak() % 5 == 4) {
                    this.miner.f_19853_.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), blockstate.m_60827_().m_56778_(), SoundSource.BLOCKS, 1.0f, 0.75f, false);
                }
                int bp = (int)(blockstate.m_60800_((BlockGetter)this.miner.f_19853_, blockPos) * 30.0f);
                this.miner.setBreakingTime(bp);
                this.miner.setCurrentTimeBreak(this.miner.getCurrentTimeBreak() + (int)(1.0f * heldItem.m_41691_(blockstate)));
                float f = (float)this.miner.getCurrentTimeBreak() / (float)this.miner.getBreakingTime();
                int i = (int)(f * 10.0f);
                if (i != this.miner.getPreviousTimeBreak()) {
                    this.miner.f_19853_.m_6801_(1, blockPos, i);
                    this.miner.setPreviousTimeBreak(i);
                }
                if (this.miner.getCurrentTimeBreak() >= this.miner.getBreakingTime()) {
                    this.miner.f_19853_.m_46953_(blockPos, true, (Entity)this.miner);
                    this.miner.setCurrentTimeBreak(-1);
                    this.miner.setBreakingTime(0);
                    this.miner.consumeToolDurability();
                    return true;
                }
                this.miner.workerSwingArm();
            }
        }
        return false;
    }

    public boolean shouldPlacePlanks() {
        if (this.miner.side == 0) {
            return this.miner.blocks - 1 == this.miner.depth;
        }
        return false;
    }

    public void placePlanks(BlockState state) {
        boolean should = this.shouldPlacePlanks();
        if (should) {
            this.miner.m_20193_().m_7731_(this.minePos, Blocks.f_50705_.m_49966_(), 3);
            this.miner.m_20193_().m_6263_(null, (double)this.minePos.m_123341_(), (double)this.minePos.m_123342_(), (double)this.minePos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void placeTorch() {
        if (this.hasTorchInInv()) {
            this.miner.f_19853_.m_7731_(this.miner.m_20097_().m_7494_(), Blocks.f_50081_.m_49966_(), 3);
            this.miner.f_19853_.m_6263_(null, (double)this.minePos.m_123341_(), (double)this.minePos.m_123342_(), (double)this.minePos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < this.miner.getInventory().m_6643_(); ++i) {
                ItemStack itemstack = this.miner.getInventory().m_8020_(i);
                if (!itemstack.m_150930_(Items.f_42000_)) continue;
                itemstack.m_41774_(1);
            }
        }
    }

    public boolean hasTorchInInv() {
        return this.miner.getInventory().m_18949_((Set)ImmutableSet.of((Object)Items.f_42000_));
    }

    private static enum MineType {
        TUNNEL_1X2,
        TUNNEL_3X3,
        PIT_8X8X8,
        FLAT_8X8X1,
        ROOM_8X8X3,
        PIT_16X16X16,
        FLAT_16X16X1,
        ROOM_16X16X3;

    }

    private static enum WorkState {
        IDLE,
        TO_WORK_POS,
        WORKING,
        DONE;

    }
}

