/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.Translatable;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.FarmerEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.ForgeEventFactory;

public class FarmerAI
extends Goal {
    private final FarmerEntity farmer;
    private BlockPos workPos;
    private BlockPos waterPos;
    private boolean messageNoHoe;
    private State state;

    public FarmerAI(FarmerEntity farmer) {
        this.farmer = farmer;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.farmer.getStatus() == AbstractWorkerEntity.Status.WORK;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.state = State.PLOWING;
        this.messageNoHoe = true;
        this.farmer.resetWorkerParameters();
    }

    public void m_8041_() {
        super.m_8041_();
        this.state = State.PLOWING;
    }

    public void m_8037_() {
        if (!this.farmer.f_20911_) {
            this.waterPos = this.farmer.getStartPos();
            if (this.workPos != null && !this.workPos.m_123314_((Vec3i)this.farmer.m_20183_(), 10.0)) {
                this.farmer.walkTowards(this.workPos, 1.0);
            }
            switch (this.state) {
                case PLOWING: {
                    if (this.farmer.hasMainToolInInv()) {
                        if (!this.startPosIsWater()) {
                            this.farmer.walkTowards(this.waterPos, 1.2);
                            if (this.waterPos.m_123314_((Vec3i)this.farmer.m_20183_(), 4.0)) {
                                this.farmer.workerSwingArm();
                                this.prepareWaterPos();
                            }
                        }
                        this.workPos = this.getHoePos();
                        if (this.workPos != null) {
                            this.farmer.walkTowards(this.workPos, 1.0);
                            if (!this.workPos.m_123314_((Vec3i)this.farmer.m_20183_(), 3.0)) break;
                            this.farmer.workerSwingArm();
                            this.prepareFarmLand(this.workPos);
                            break;
                        }
                        this.state = State.PLANTING;
                        break;
                    }
                    if (this.messageNoHoe && this.farmer.m_21826_() != null) {
                        this.farmer.tellPlayer(this.farmer.m_21826_(), Translatable.TEXT_OUT_OF_TOOLS());
                        this.messageNoHoe = false;
                    }
                    this.farmer.needsMainTool = true;
                    break;
                }
                case PLANTING: {
                    if (!this.hasSeedInInv()) {
                        this.state = State.FERTILIZING;
                        break;
                    }
                    this.workPos = this.getPlantPos();
                    if (this.workPos == null) {
                        this.state = State.FERTILIZING;
                        break;
                    }
                    this.farmer.walkTowards(this.workPos, 0.7);
                    if (!this.workPos.m_123314_((Vec3i)this.farmer.m_20183_(), 3.0)) break;
                    this.farmer.workerSwingArm();
                    this.plantSeedsFromInv(this.workPos);
                    break;
                }
                case FERTILIZING: {
                    if (!this.hasBone()) {
                        this.state = State.HARVESTING;
                        break;
                    }
                    this.workPos = this.getFertilizePos();
                    if (this.workPos == null) {
                        this.state = State.HARVESTING;
                        break;
                    }
                    this.farmer.walkTowards(this.workPos, 0.7);
                    if (!this.workPos.m_123314_((Vec3i)this.farmer.m_20183_(), 3.0)) break;
                    this.farmer.workerSwingArm();
                    this.fertilizeSeeds(this.workPos);
                    break;
                }
                case HARVESTING: {
                    if (this.hasSpaceInInv()) {
                        this.workPos = this.getHarvestPos();
                    }
                    if (this.workPos != null) {
                        this.farmer.walkTowards(this.workPos, 0.6);
                        if (!this.workPos.m_123314_((Vec3i)this.farmer.m_20183_(), 3.0)) break;
                        this.farmer.workerSwingArm();
                        boolean blockWasMined = this.mineBlock(this.workPos);
                        if (!blockWasMined) break;
                        this.farmer.increaseFarmedItems();
                        this.farmer.consumeToolDurability();
                        break;
                    }
                    this.state = State.PLOWING;
                }
            }
        }
    }

    private boolean hasBone() {
        SimpleContainer inventory = this.farmer.getInventory();
        return inventory.m_216874_(item -> item.m_41720_() instanceof BoneMealItem);
    }

    private void fertilizeSeeds(BlockPos workPos) {
        BlockState state = this.farmer.m_9236_().m_8055_(workPos);
        Block block = state.m_60734_();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock crop = (BonemealableBlock)block;
            if (!this.farmer.m_9236_().m_5776_()) {
                crop.m_214148_((ServerLevel)this.farmer.m_9236_(), this.farmer.m_217043_(), workPos, state);
                if (crop.m_214167_((Level)((ServerLevel)this.farmer.m_9236_()), this.farmer.m_217043_(), workPos, state)) {
                    for (int i = 0; i < this.farmer.getInventory().m_6643_(); ++i) {
                        ItemStack itemstack = this.farmer.getInventory().m_8020_(i);
                        if (!(itemstack.m_41720_() instanceof BoneMealItem)) continue;
                        itemstack.m_41774_(1);
                        break;
                    }
                }
            }
        }
    }

    private boolean hasSeedInInv() {
        SimpleContainer inventory = this.farmer.getInventory();
        return inventory.m_18949_(FarmerEntity.WANTED_SEEDS);
    }

    private boolean hasSpaceInInv() {
        SimpleContainer inventory = this.farmer.getInventory();
        return inventory.m_19183_(((Item)this.farmer.WANTED_ITEMS.stream().findAny().get()).m_7968_());
    }

    private boolean startPosIsWater() {
        if (this.waterPos != null) {
            FluidState waterBlockState = this.farmer.f_19853_.m_6425_(this.waterPos);
            return waterBlockState.m_192917_((Fluid)Fluids.f_76193_) || waterBlockState.m_192917_((Fluid)Fluids.f_76192_);
        }
        return false;
    }

    private void plantSeedsFromInv(BlockPos blockPos) {
        SimpleContainer inventory = this.farmer.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            boolean flag = false;
            if (!itemstack.m_41619_()) {
                if (itemstack.m_41720_() == Items.f_42619_) {
                    this.farmer.f_19853_.m_7731_(blockPos, Blocks.f_50249_.m_49966_(), 3);
                    flag = true;
                } else if (itemstack.m_41720_() == Items.f_42620_) {
                    this.farmer.f_19853_.m_7731_(blockPos, Blocks.f_50250_.m_49966_(), 3);
                    flag = true;
                } else if (itemstack.m_41720_() == Items.f_42404_) {
                    this.farmer.f_19853_.m_7731_(blockPos, Blocks.f_50092_.m_49966_(), 3);
                    flag = true;
                } else if (itemstack.m_41720_() == Items.f_42733_) {
                    this.farmer.f_19853_.m_7731_(blockPos, Blocks.f_50444_.m_49966_(), 3);
                    flag = true;
                }
            }
            if (!flag) continue;
            this.farmer.f_19853_.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
            itemstack.m_41774_(1);
            if (!itemstack.m_41619_()) break;
            inventory.m_6836_(i, ItemStack.f_41583_);
            break;
        }
    }

    private void prepareWaterPos() {
        if (this.waterPos != null) {
            BlockState blockState = this.farmer.m_20193_().m_8055_(this.waterPos);
            FluidState waterBlockState = this.farmer.m_20193_().m_6425_(this.waterPos);
            if (waterBlockState != Fluids.f_76193_.m_76145_() || waterBlockState != Fluids.f_76192_.m_76145_()) {
                if (FarmerEntity.TILLABLES.contains(blockState.m_60734_())) {
                    this.farmer.m_20193_().m_7731_(this.waterPos, Blocks.f_49990_.m_49966_(), 3);
                    this.farmer.m_20193_().m_6263_(null, (double)this.waterPos.m_123341_(), (double)this.waterPos.m_123342_(), (double)this.waterPos.m_123343_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.farmer.consumeToolDurability();
                } else {
                    return;
                }
            }
            this.farmer.workerSwingArm();
        }
    }

    private void prepareFarmLand(BlockPos blockPos) {
        BlockState blockState = this.farmer.m_20193_().m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (blockPos != this.waterPos && FarmerEntity.TILLABLES.contains(block)) {
            this.farmer.m_20193_().m_7731_(blockPos, Blocks.f_50093_.m_49966_(), 3);
            this.farmer.m_20193_().m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState blockStateAbove = this.farmer.m_20193_().m_8055_(blockPos.m_7494_());
            Block blockAbove = blockStateAbove.m_60734_();
            this.farmer.workerSwingArm();
            this.farmer.consumeToolDurability();
            if (blockAbove instanceof BushBlock || blockAbove instanceof GrowingPlantBlock) {
                this.farmer.m_20193_().m_46961_(blockPos.m_7494_(), false);
                this.farmer.m_20193_().m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11988_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public BlockPos getHoePos() {
        for (int j = 0; j <= 8; ++j) {
            for (int i = 0; i <= 8; ++i) {
                boolean hasSpaceAbove;
                BlockPos blockPos = this.waterPos.m_7918_(j - 4, 0, i - 4);
                BlockPos aboveBlockPos = blockPos.m_7494_();
                BlockState blockState = this.farmer.f_19853_.m_8055_(blockPos);
                BlockState aboveBlockState = this.farmer.f_19853_.m_8055_(aboveBlockPos);
                Block block = blockState.m_60734_();
                boolean canSustainSeeds = FarmerEntity.TILLABLES.contains(block);
                boolean bl = hasSpaceAbove = aboveBlockState.m_60713_(Blocks.f_50016_) || aboveBlockState.m_204336_(BlockTags.f_198158_);
                if (!canSustainSeeds || !hasSpaceAbove) continue;
                return blockPos;
            }
        }
        return null;
    }

    public BlockPos getPlantPos() {
        for (int j = 0; j <= 8; ++j) {
            for (int i = 0; i <= 8; ++i) {
                BlockPos blockPos = this.waterPos.m_7918_(j - 4, 0, i - 4);
                BlockPos aboveBlockPos = blockPos.m_7494_();
                BlockState blockState = this.farmer.f_19853_.m_8055_(blockPos);
                BlockState aboveBlockState = this.farmer.f_19853_.m_8055_(aboveBlockPos);
                Block block = blockState.m_60734_();
                Block aboveBlock = aboveBlockState.m_60734_();
                if (block != Blocks.f_50093_ || aboveBlock != Blocks.f_50016_) continue;
                return aboveBlockPos;
            }
        }
        return null;
    }

    public BlockPos getHarvestPos() {
        for (int j = 0; j <= 8; ++j) {
            for (int i = 0; i <= 8; ++i) {
                BlockPos blockPos = this.waterPos.m_7918_(j - 4, 1, i - 4);
                BlockState blockState = this.farmer.f_19853_.m_8055_(blockPos);
                Block block = blockState.m_60734_();
                if (!FarmerEntity.CROP_BLOCKS.contains(block)) continue;
                BlockPos belowBlockPos = blockPos.m_7495_();
                BlockState belowBlockState = this.farmer.f_19853_.m_8055_(belowBlockPos);
                if (!(block instanceof CropBlock)) continue;
                CropBlock crop = (CropBlock)block;
                if (!belowBlockState.m_60713_(Blocks.f_50093_) || !crop.m_52307_(blockState)) continue;
                return blockPos;
            }
        }
        return null;
    }

    public BlockPos getFertilizePos() {
        for (int j = 0; j <= 8; ++j) {
            for (int i = 0; i <= 8; ++i) {
                BlockPos blockPos = this.waterPos.m_7918_(j - 4, 1, i - 4);
                BlockState blockState = this.farmer.f_19853_.m_8055_(blockPos);
                Block block = blockState.m_60734_();
                if (!FarmerEntity.CROP_BLOCKS.contains(block)) continue;
                BlockPos belowBlockPos = blockPos.m_7495_();
                BlockState belowBlockState = this.farmer.f_19853_.m_8055_(belowBlockPos);
                if (!(block instanceof CropBlock)) continue;
                CropBlock crop = (CropBlock)block;
                if (!belowBlockState.m_60713_(Blocks.f_50093_) || crop.m_52307_(blockState)) continue;
                return blockPos;
            }
        }
        return null;
    }

    private boolean mineBlock(BlockPos blockPos) {
        BlockState blockstate;
        Block block;
        if (this.farmer.m_6084_() && ForgeEventFactory.getMobGriefingEvent((Level)this.farmer.f_19853_, (Entity)this.farmer) && (block = (blockstate = this.farmer.f_19853_.m_8055_(blockPos)).m_60734_()) != Blocks.f_50016_) {
            if (this.farmer.getCurrentTimeBreak() % 5 == 4) {
                this.farmer.f_19853_.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), blockstate.m_60827_().m_56778_(), SoundSource.BLOCKS, 1.0f, 0.75f, false);
            }
            int bp = (int)(blockstate.m_60800_((BlockGetter)this.farmer.f_19853_, blockPos) * 30.0f);
            this.farmer.setBreakingTime(bp);
            this.farmer.setCurrentTimeBreak(this.farmer.getCurrentTimeBreak() + (int)(1.0f * this.farmer.m_21211_().m_41691_(blockstate)));
            float f = (float)this.farmer.getCurrentTimeBreak() / (float)this.farmer.getBreakingTime();
            int i = (int)(f * 10.0f);
            if (i != this.farmer.getPreviousTimeBreak()) {
                this.farmer.f_19853_.m_6801_(1, blockPos, i);
                this.farmer.setPreviousTimeBreak(i);
            }
            if (this.farmer.getCurrentTimeBreak() == this.farmer.getBreakingTime()) {
                this.farmer.f_19853_.m_46953_(blockPos, true, (Entity)this.farmer);
                this.farmer.setCurrentTimeBreak(-1);
                this.farmer.setBreakingTime(0);
                return true;
            }
            this.farmer.workerSwingArm();
        }
        return false;
    }

    private static enum State {
        PLOWING,
        PLANTING,
        FERTILIZING,
        HARVESTING;

    }
}

