/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.google.common.base.Predicates;
import com.talhanation.workers.entities.AbstractAnimalFarmerEntity;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.ChickenFarmerEntity;
import com.talhanation.workers.entities.ai.AnimalFarmerAI;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ChickenFarmerAI
extends AnimalFarmerAI {
    private Optional<Chicken> chicken;
    private boolean breeding;
    private boolean slaughtering;
    private boolean throwEggs;
    private BlockPos workPos;

    public ChickenFarmerAI(ChickenFarmerEntity worker) {
        this.animalFarmer = worker;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.animalFarmer.getStatus() == AbstractWorkerEntity.Status.WORK;
    }

    public void m_8056_() {
        super.m_8056_();
        this.workPos = this.animalFarmer.getStartPos();
        this.breeding = true;
        this.throwEggs = false;
        this.slaughtering = false;
    }

    @Override
    public void performWork() {
        ChickenFarmerEntity chickenFarmer;
        AbstractAnimalFarmerEntity abstractAnimalFarmerEntity;
        if (this.workPos != null && !this.workPos.m_123314_((Vec3i)this.animalFarmer.m_20097_(), 10.0)) {
            this.animalFarmer.m_21573_().m_26519_((double)this.workPos.m_123341_(), (double)this.workPos.m_123342_(), (double)this.workPos.m_123343_(), 1.0);
        }
        if (this.breeding) {
            this.chicken = this.findChickenBreeding();
            if (this.chicken.isPresent()) {
                int i = this.chicken.get().m_146764_();
                if (i == 0 && this.hasSeeds()) {
                    this.animalFarmer.changeToBreedItem(Items.f_42404_);
                    this.animalFarmer.m_21573_().m_5624_((Entity)this.chicken.get(), 1.0);
                    if (this.chicken.get().m_19950_((Entity)this.animalFarmer, 2.0)) {
                        this.consumeSeed();
                        this.animalFarmer.m_21563_().m_24950_(this.chicken.get().m_20185_(), this.chicken.get().m_20188_(), this.chicken.get().m_20189_(), 10.0f, (float)this.animalFarmer.m_8132_());
                        this.chicken.get().m_27595_(null);
                        this.animalFarmer.workerSwingArm();
                        this.chicken = Optional.empty();
                    }
                } else {
                    this.breeding = false;
                    this.throwEggs = false;
                    this.slaughtering = true;
                }
            } else {
                this.breeding = false;
                this.throwEggs = false;
                this.slaughtering = true;
            }
        }
        if (this.slaughtering) {
            List<Chicken> chickens = this.findChickenSlaughtering();
            if (chickens.size() > this.animalFarmer.getMaxAnimalCount() && this.animalFarmer.hasMainToolInInv()) {
                this.chicken = chickens.stream().findFirst();
                if (this.chicken.isPresent()) {
                    if (!this.animalFarmer.isRequiredMainTool(this.animalFarmer.m_21205_())) {
                        this.animalFarmer.changeToTool(true);
                    }
                    this.animalFarmer.m_21573_().m_26519_(this.chicken.get().m_20185_(), this.chicken.get().m_20186_(), this.chicken.get().m_20189_(), 1.0);
                    if (this.chicken.get().m_19950_((Entity)this.animalFarmer, 2.0)) {
                        this.chicken.get().m_6074_();
                        this.animalFarmer.workerSwingArm();
                        this.animalFarmer.m_216990_(SoundEvents.f_12316_);
                        this.animalFarmer.consumeToolDurability();
                        this.animalFarmer.increaseFarmedItems();
                    }
                }
            } else {
                if (!this.animalFarmer.hasMainToolInInv()) {
                    this.animalFarmer.needsMainTool = true;
                }
                this.slaughtering = false;
                this.breeding = false;
                this.throwEggs = true;
            }
        }
        if (this.throwEggs && (abstractAnimalFarmerEntity = this.animalFarmer) instanceof ChickenFarmerEntity && (chickenFarmer = (ChickenFarmerEntity)abstractAnimalFarmerEntity).getUseEggs()) {
            if (this.hasEggs()) {
                this.animalFarmer.m_21563_().m_24950_((double)this.animalFarmer.getStartPos().m_123341_(), (double)this.animalFarmer.getStartPos().m_123342_(), (double)this.animalFarmer.getStartPos().m_123343_(), 10.0f, (float)this.animalFarmer.m_8132_());
                double distance = this.animalFarmer.getStartPos().m_123331_((Vec3i)this.animalFarmer.m_20097_());
                if (distance <= 15.0) {
                    this.animalFarmer.f_19853_.m_6263_(null, this.animalFarmer.m_20185_(), this.animalFarmer.m_20186_(), this.animalFarmer.m_20189_(), SoundEvents.f_11877_, SoundSource.PLAYERS, 0.5f, 0.4f / (this.animalFarmer.m_217043_().m_188501_() * 0.4f + 0.8f));
                    ThrownEgg thrownegg = new ThrownEgg(this.animalFarmer.f_19853_, (LivingEntity)this.animalFarmer);
                    thrownegg.m_37446_(new ItemStack((ItemLike)Items.f_42521_));
                    double d0 = (double)this.animalFarmer.getStartPos().m_123341_() - this.animalFarmer.m_20185_();
                    double d2 = (double)this.animalFarmer.getStartPos().m_123343_() - this.animalFarmer.m_20189_();
                    thrownegg.m_6686_(d0, 0.0, d2, 0.1f, 0.0f);
                    if (this.animalFarmer.m_20193_().m_7967_((Entity)thrownegg)) {
                        this.animalFarmer.workerSwingArm();
                        this.consumeEggs();
                    } else {
                        this.slaughtering = false;
                        this.breeding = true;
                        this.throwEggs = false;
                    }
                } else {
                    this.animalFarmer.walkTowards(this.animalFarmer.getStartPos(), 1.0);
                }
            } else {
                this.slaughtering = false;
                this.breeding = true;
                this.throwEggs = false;
            }
        }
    }

    private void consumeSeed() {
        SimpleContainer inventory = this.animalFarmer.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(Items.f_42404_) && !itemStack.m_41720_().equals(Items.f_42578_) && !itemStack.m_41720_().equals(Items.f_42733_) && !itemStack.m_41720_().equals(Items.f_42577_)) continue;
            itemStack.m_41774_(1);
            break;
        }
    }

    private void consumeEggs() {
        SimpleContainer inventory = this.animalFarmer.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(Items.f_42521_)) continue;
            itemStack.m_41774_(1);
            break;
        }
    }

    private Optional<Chicken> findChickenBreeding() {
        return this.animalFarmer.f_19853_.m_6443_(Chicken.class, this.animalFarmer.m_20191_().m_82400_(8.0), LivingEntity::m_6084_).stream().filter(Predicates.not(AgeableMob::m_6162_)).filter(Predicates.not(Animal::m_27593_)).findAny();
    }

    private List<Chicken> findChickenSlaughtering() {
        return this.animalFarmer.f_19853_.m_6443_(Chicken.class, this.animalFarmer.m_20191_().m_82400_(8.0), LivingEntity::m_6084_).stream().filter(Predicates.not(AgeableMob::m_6162_)).filter(Predicates.not(Animal::m_27593_)).collect(Collectors.toList());
    }

    private boolean hasSeeds() {
        SimpleContainer inventory = this.animalFarmer.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(Items.f_42404_) && !itemStack.m_41720_().equals(Items.f_42578_) && !itemStack.m_41720_().equals(Items.f_42733_) && !itemStack.m_41720_().equals(Items.f_42577_) || itemStack.m_41613_() < 2) continue;
            return true;
        }
        return false;
    }

    private boolean hasEggs() {
        SimpleContainer inventory = this.animalFarmer.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(Items.f_42521_)) continue;
            return true;
        }
        return false;
    }
}

