/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities;

import com.google.common.collect.ImmutableSet;
import com.talhanation.workers.Main;
import com.talhanation.workers.config.WorkersModConfig;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.ai.MinerAI;
import com.talhanation.workers.inventory.MinerInventoryContainer;
import com.talhanation.workers.network.MessageOpenGuiMiner;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class MinerEntity
extends AbstractWorkerEntity {
    private final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && this.m_7243_(item.m_32055_());
    private static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.m_135353_(MinerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Integer> MINE_TYPE = SynchedEntityData.m_135353_(MinerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DEPTH = SynchedEntityData.m_135353_(MinerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHECKED = SynchedEntityData.m_135353_(MinerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Set<Item> WANTED_ITEMS = ImmutableSet.of((Object)Items.f_42413_, (Object)Items.f_150965_, (Object)Items.f_41834_, (Object)Items.f_41833_, (Object)Items.f_42415_, (Object)Items.f_42616_, (Object[])new Item[]{Items.f_41905_, Items.f_42594_, Items.f_42170_, Items.f_41958_, Items.f_41832_, Items.f_41830_, Items.f_41856_, Items.f_41831_, Items.f_42451_, Items.f_42329_, Items.f_42064_, Items.f_42382_, Items.f_151051_, Items.f_151050_, Items.f_151053_, Items.f_151048_, Items.f_42755_, Items.f_151034_, Items.f_151020_, Items.f_42051_, Items.f_42000_});
    public static final Set<Block> IGNORING_BLOCKS = ImmutableSet.of((Object)Blocks.f_50627_, (Object)Blocks.f_50016_, (Object)Blocks.f_50081_, (Object)Blocks.f_50082_, (Object)Blocks.f_50140_, (Object)Blocks.f_50088_, (Object[])new Block[]{Blocks.f_50683_, Blocks.f_50145_, Blocks.f_50151_, Blocks.f_50149_, Blocks.f_50150_, Blocks.f_50153_, Blocks.f_50152_, Blocks.f_50095_, Blocks.f_50161_, Blocks.f_50159_, Blocks.f_50160_, Blocks.f_50163_, Blocks.f_50162_, Blocks.f_50158_, Blocks.f_50682_, Blocks.f_50681_, Blocks.f_50031_, Blocks.f_50156_, Blocks.f_49990_});
    public int blocks;
    public int side;
    public int depth;

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DIRECTION, (Object)Direction.NORTH);
        this.f_19804_.m_135372_(MINE_TYPE, (Object)1);
        this.f_19804_.m_135372_(DEPTH, (Object)16);
        this.f_19804_.m_135372_(CHECKED, (Object)false);
    }

    public MinerEntity(EntityType<? extends AbstractWorkerEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean canWorkWithoutTool() {
        return false;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return MinerEntity.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(2, (Goal)new MinerAI(this));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficultyInstance, @NotNull MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        this.m_213946_(this.f_19796_, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        super.initSpawn();
        MutableComponent name = Component.m_237113_((String)"Miner");
        this.setProfessionName(name.getString());
        this.m_6593_((Component)name);
    }

    public boolean m_7243_(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return WANTED_ITEMS.contains(item) || itemStack.m_204117_(Tags.Items.ORES) || itemStack.m_204117_(Tags.Items.STONE);
    }

    @Override
    public boolean wantsToKeep(ItemStack itemStack) {
        return super.wantsToKeep(itemStack) || itemStack.m_150930_(Items.f_42000_) || itemStack.m_41720_() instanceof ShovelItem || itemStack.m_41720_() instanceof PickaxeItem;
    }

    public boolean shouldIgnoreBlock(BlockState blockState) {
        return IGNORING_BLOCKS.contains(blockState.m_60734_()) || !this.canBreakBlock(blockState);
    }

    @Override
    public void setEquipment() {
        ItemStack initialTool = new ItemStack((ItemLike)Items.f_42427_);
        this.updateInventory(0, initialTool);
        this.equipTool(initialTool);
        ItemStack initialTool2 = new ItemStack((ItemLike)Items.f_42426_);
        this.updateInventory(1, initialTool2);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel world, @NotNull AgeableMob ageable) {
        return null;
    }

    @Override
    public int workerCosts() {
        return (Integer)WorkersModConfig.MinerCost.get();
    }

    public int getMaxMineDepth() {
        return 64;
    }

    public boolean getChecked() {
        return (Boolean)this.f_19804_.m_135370_(CHECKED);
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return this.ALLOWED_ITEMS;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("MineType", this.getMineType());
        nbt.m_128405_("Depth", this.getMineDepth());
        nbt.m_128379_("Checked", this.getChecked());
        nbt.m_128359_("MineDirection", this.getMineDirection().m_122433_());
        ListTag waypoints = new ListTag();
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setMineType(nbt.m_128451_("MineType"), false);
        this.setMineDepth(nbt.m_128451_("Depth"));
        this.setChecked(nbt.m_128471_("Checked"));
        this.setMineDirection(Direction.m_122402_((String)nbt.m_128461_("MineDirection")));
    }

    public void setMineDirection(Direction dir) {
        this.f_19804_.m_135381_(DIRECTION, (Object)dir);
    }

    public Direction getMineDirection() {
        return (Direction)this.f_19804_.m_135370_(DIRECTION);
    }

    public void setChecked(boolean checked) {
        this.f_19804_.m_135381_(CHECKED, (Object)checked);
    }

    public void setMineType(int x, boolean clear) {
        if (clear) {
            this.clearStartPos();
        }
        this.f_19804_.m_135381_(MINE_TYPE, (Object)x);
    }

    @Override
    public void setStartPos(BlockPos pos) {
        this.resetCounts();
        super.setStartPos(pos);
    }

    public int getMineType() {
        return (Integer)this.f_19804_.m_135370_(MINE_TYPE);
    }

    public void setMineDepth(int x) {
        this.f_19804_.m_135381_(DEPTH, (Object)x);
    }

    public int getMineDepth() {
        return (Integer)this.f_19804_.m_135370_(DEPTH);
    }

    public void changeTool(BlockState blockState) {
        if (blockState != null) {
            if (blockState.m_204336_(BlockTags.f_144283_)) {
                for (int i = 0; i < this.getInventory().f_19147_.size(); ++i) {
                    ItemStack stack = (ItemStack)this.getInventory().f_19147_.get(i);
                    if (!(stack.m_41720_() instanceof ShovelItem)) continue;
                    this.equipTool(stack);
                }
            } else if (blockState.m_204336_(BlockTags.f_144282_)) {
                for (int i = 0; i < this.getInventory().f_19147_.size(); ++i) {
                    ItemStack stack = (ItemStack)this.getInventory().f_19147_.get(i);
                    if (!(stack.m_41720_() instanceof PickaxeItem)) continue;
                    this.equipTool(stack);
                }
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemStack.f_41583_.m_41720_()));
            }
        }
    }

    @Override
    public void openGUI(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return MinerEntity.this.m_7755_();
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new MinerInventoryContainer(i, MinerEntity.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenGuiMiner(player, this.m_20148_()));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    public void resetCounts() {
        this.blocks = 0;
        this.side = 0;
        this.depth = 0;
    }

    @Override
    public boolean isRequiredMainTool(ItemStack tool) {
        return tool.m_41720_() instanceof PickaxeItem;
    }

    @Override
    public boolean isRequiredSecondTool(ItemStack tool) {
        return tool.m_41720_() instanceof ShovelItem;
    }

    @Override
    public boolean hasAMainTool() {
        return true;
    }

    @Override
    public boolean hasASecondTool() {
        return true;
    }

    public boolean canBreakBlock(BlockState state) {
        ItemStack tool = this.m_21205_();
        Item item = tool.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem diggerItem = (DiggerItem)item;
            return TierSortingRegistry.isCorrectTierForDrops((Tier)diggerItem.m_43314_(), (BlockState)state);
        }
        return false;
    }

    @Override
    public int getFarmedItemsDepositAmount() {
        return 128;
    }

    @Override
    public List<Item> inventoryInputHelp() {
        return Arrays.asList(Items.f_42385_, Items.f_42384_, Items.f_42000_);
    }
}

