/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities;

import com.google.common.collect.ImmutableSet;
import com.talhanation.workers.Main;
import com.talhanation.workers.Translatable;
import com.talhanation.workers.config.WorkersModConfig;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.IBoatController;
import com.talhanation.workers.entities.ai.ControlBoatAI;
import com.talhanation.workers.entities.ai.MerchantAI;
import com.talhanation.workers.inventory.MerchantInventoryContainer;
import com.talhanation.workers.inventory.MerchantTradeContainer;
import com.talhanation.workers.inventory.MerchantWaypointContainer;
import com.talhanation.workers.network.MessageOpenGuiMerchant;
import com.talhanation.workers.network.MessageOpenGuiWorker;
import com.talhanation.workers.network.MessageToClientUpdateMerchantScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class MerchantEntity
extends AbstractWorkerEntity
implements IBoatController {
    private static final EntityDataAccessor<Boolean> TRAVELING = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TRAVEL_SPEED_STATE = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<BlockPos>> CURRENT_WAYPOINT = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> CURRENT_WAYPOINT_INDEX = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CURRENT_RETURNING_TIME = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RETURNING_TIME = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<BlockPos>> SAIL_POS = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_CREATIVE = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_DAY_COUNTED = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> HORSE_ID = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> BOAT_ID = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> AUTO_START_TRAVEL = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INFO = SynchedEntityData.m_135353_(MerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final SimpleContainer tradeInventory = new SimpleContainer(8);
    public boolean isTrading;
    private List<Integer> TRADE_LIMITS = new ArrayList<Integer>();
    private List<Integer> CURRENT_TRADES = new ArrayList<Integer>();
    public List<BlockPos> WAYPOINTS = new ArrayList<BlockPos>();
    public List<ItemStack> WAYPOINT_ITEMS = new ArrayList<ItemStack>();
    private static final Set<Block> ALLOWED_WATER_BLOCKS = ImmutableSet.of((Object)Blocks.f_49990_, (Object)Blocks.f_50575_, (Object)Blocks.f_50576_, (Object)Blocks.f_50037_, (Object)Blocks.f_50038_);

    public MerchantEntity(EntityType<? extends AbstractWorkerEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRAVELING, (Object)false);
        this.f_19804_.m_135372_(RETURNING, (Object)false);
        this.f_19804_.m_135372_(RETURNING_TIME, (Object)1);
        this.f_19804_.m_135372_(TRAVEL_SPEED_STATE, (Object)1);
        this.f_19804_.m_135372_(CURRENT_RETURNING_TIME, (Object)0);
        this.f_19804_.m_135372_(CURRENT_WAYPOINT_INDEX, (Object)0);
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(CURRENT_WAYPOINT, Optional.empty());
        this.f_19804_.m_135372_(SAIL_POS, Optional.empty());
        this.f_19804_.m_135372_(HORSE_ID, Optional.empty());
        this.f_19804_.m_135372_(BOAT_ID, Optional.empty());
        this.f_19804_.m_135372_(IS_CREATIVE, (Object)false);
        this.f_19804_.m_135372_(IS_DAY_COUNTED, (Object)false);
        this.f_19804_.m_135372_(AUTO_START_TRAVEL, (Object)true);
        this.f_19804_.m_135372_(INFO, (Object)true);
    }

    @Override
    public boolean needsToSleep() {
        return !this.getTraveling() && super.needsToSleep();
    }

    private void initTradeLimits() {
        if (this.TRADE_LIMITS.isEmpty()) {
            this.TRADE_LIMITS = Arrays.asList(16, 16, 16, 16);
        }
    }

    private void initCurrentTrades() {
        if (this.CURRENT_TRADES.isEmpty()) {
            this.CURRENT_TRADES = Arrays.asList(0, 0, 0, 0);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public int workerCosts() {
        return (Integer)WorkersModConfig.MerchantCost.get();
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.f_19853_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (this.isCreative()) {
            if (player.m_7500_() && player.m_20203_().m_6761_(4)) {
                if (player.m_6047_()) {
                    this.openGUI(player);
                    return InteractionResult.PASS;
                }
                if (this.status == AbstractWorkerEntity.Status.FOLLOW) {
                    this.setStatus(this.prevStatus);
                    return InteractionResult.SUCCESS;
                }
                this.setStatus(AbstractWorkerEntity.Status.FOLLOW, true);
                return InteractionResult.SUCCESS;
            }
            this.openTradeGUI(player);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && player.m_20148_().equals(this.m_21805_())) {
            if (player.m_6047_()) {
                this.openGUI(player);
            }
            if (player.m_6047_()) return InteractionResult.PASS;
            if (this.status == AbstractWorkerEntity.Status.FOLLOW) {
                this.setStatus(Objects.requireNonNullElse(this.prevStatus, AbstractWorkerEntity.Status.IDLE), true);
                return InteractionResult.SUCCESS;
            }
            this.setStatus(AbstractWorkerEntity.Status.FOLLOW, true);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && !player.m_20148_().equals(this.m_21805_())) {
            this.tellPlayer((LivingEntity)player, Translatable.TEXT_HELLO_OWNED(this.getProfessionName(), this.getOwnerName()));
            if (player.m_6047_()) return InteractionResult.PASS;
            this.openTradeGUI(player);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) return InteractionResult.PASS;
        this.tellPlayer((LivingEntity)player, Translatable.TEXT_HELLO(this.getProfessionName()));
        this.openHireGUI(player);
        this.f_21344_.m_26573_();
        return InteractionResult.SUCCESS;
    }

    public void setFollow(boolean bool) {
        Boat boat;
        Entity entity;
        if (!this.getReturning() && !this.getTraveling() && !bool && (entity = this.m_20202_()) instanceof Boat && (boat = (Boat)entity).m_20078_().contains("smallships")) {
            this.setSmallShipsSailState(boat, 0);
            this.setSailPos(null);
        }
    }

    public void openTradeGUI(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return MerchantEntity.this.m_7755_();
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new MerchantTradeContainer(i, MerchantEntity.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenGuiMerchant(player, this.m_20148_()));
        }
    }

    public void openWaypointsGUI(final Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return MerchantEntity.this.m_7755_();
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new MerchantWaypointContainer(i, player, MerchantEntity.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenGuiMerchant(player, this.m_20148_()));
        }
        if (player instanceof ServerPlayer) {
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientUpdateMerchantScreen(this.WAYPOINTS, this.WAYPOINT_ITEMS, this.getCurrentTrades(), this.getTradeLimits(), this.getTraveling(), this.getReturning()));
        }
    }

    @Override
    public void openGUI(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return MerchantEntity.this.m_7755_();
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new MerchantInventoryContainer(i, MerchantEntity.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenGuiWorker(player, this.m_20148_()));
        }
        if (player instanceof ServerPlayer) {
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientUpdateMerchantScreen(this.WAYPOINTS, this.WAYPOINT_ITEMS, this.getCurrentTrades(), this.getTradeLimits(), this.getTraveling(), this.getReturning()));
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return MerchantEntity.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new ControlBoatAI(this));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new MerchantAI(this));
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel p_241840_1_, @NotNull AgeableMob p_241840_2_) {
        return null;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficultyInstance, @NotNull MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        this.m_213946_(this.f_19796_, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        super.initSpawn();
        MutableComponent name = Component.m_237113_((String)"Merchant");
        this.setProfessionName(name.getString());
        this.m_6593_((Component)name);
        this.m_5634_(100.0f);
    }

    @Override
    public boolean isRequiredMainTool(ItemStack tool) {
        return false;
    }

    @Override
    public boolean hasAMainTool() {
        return false;
    }

    @Override
    public boolean isRequiredSecondTool(ItemStack tool) {
        return false;
    }

    @Override
    public boolean hasASecondTool() {
        return false;
    }

    @Override
    public void setEquipment() {
        int i = this.f_19796_.m_188503_(9);
        if (i == 0) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42517_));
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42516_));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        CompoundTag compoundnbt;
        super.m_7380_(nbt);
        ListTag list = new ListTag();
        for (int i = 0; i < this.tradeInventory.m_6643_(); ++i) {
            ItemStack itemstack = this.tradeInventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt2 = new CompoundTag();
            compoundnbt2.m_128344_("TradeSlot", (byte)i);
            itemstack.m_41739_(compoundnbt2);
            list.add((Object)compoundnbt2);
        }
        nbt.m_128365_("TradeInventory", (Tag)list);
        if (this.getHorseUUID() != null) {
            nbt.m_128362_("HorseUUID", this.getHorseUUID());
        }
        if (this.getBoatUUID() != null) {
            nbt.m_128362_("BoatUUID", this.getBoatUUID());
        }
        nbt.m_128379_("Traveling", this.getTraveling());
        nbt.m_128379_("AutoStartTravel", this.getAutoStartTravel());
        nbt.m_128379_("Returning", this.getReturning());
        nbt.m_128405_("CurrentWayPointIndex", this.getCurrentWayPointIndex());
        nbt.m_128405_("ReturningTime", this.getReturningTime());
        nbt.m_128405_("CurrentReturningTime", this.getCurrentReturningTime());
        nbt.m_128379_("isCreative", this.isCreative());
        nbt.m_128379_("isDayCounted", this.isDayCounted());
        BlockPos currentWayPoint = this.getCurrentWayPoint();
        if (currentWayPoint != null) {
            this.setNbtPosition(nbt, "CurrentWayPoint", currentWayPoint);
        }
        ListTag waypointItems = new ListTag();
        for (int i = 0; i < this.WAYPOINT_ITEMS.size(); ++i) {
            ItemStack itemstack = this.WAYPOINT_ITEMS.get(i);
            if (itemstack.m_41619_()) continue;
            compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("WaypointItem", (byte)i);
            itemstack.m_41739_(compoundnbt);
            waypointItems.add((Object)compoundnbt);
        }
        nbt.m_128365_("WaypointItems", (Tag)waypointItems);
        ListTag waypoints = new ListTag();
        for (int i = 0; i < this.WAYPOINTS.size(); ++i) {
            compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Waypoint", (byte)i);
            BlockPos pos = this.WAYPOINTS.get(i);
            compoundnbt.m_128347_("PosX", (double)pos.m_123341_());
            compoundnbt.m_128347_("PosY", (double)pos.m_123342_());
            compoundnbt.m_128347_("PosZ", (double)pos.m_123343_());
            waypoints.add((Object)compoundnbt);
        }
        nbt.m_128365_("Waypoints", (Tag)waypoints);
        ListTag limits = new ListTag();
        for (int i = 0; i < 4; ++i) {
            CompoundTag compoundnbt3 = new CompoundTag();
            compoundnbt3.m_128344_("TradeLimit_" + i, (byte)i);
            int limit = this.getTradeLimits().get(i);
            compoundnbt3.m_128405_("Limit", limit);
            limits.add((Object)compoundnbt3);
        }
        nbt.m_128365_("TradeLimits", (Tag)limits);
        ListTag trades = new ListTag();
        for (int i = 0; i < 4; ++i) {
            CompoundTag compoundnbt4 = new CompoundTag();
            compoundnbt4.m_128344_("Trade_" + i, (byte)i);
            int trade = this.getCurrentTrades().get(i);
            compoundnbt4.m_128405_("Trade", trade);
            trades.add((Object)compoundnbt4);
        }
        nbt.m_128365_("Trades", (Tag)trades);
        nbt.m_128405_("State", this.getState());
        nbt.m_128405_("TravelSpeedState", this.getTravelSpeedState());
        nbt.m_128379_("InfoTravel", this.getSendInfo());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        ListTag trades;
        super.m_7378_(nbt);
        ListTag tradeList = nbt.m_128437_("TradeInventory", 10);
        for (int i = 0; i < tradeList.size(); ++i) {
            CompoundTag compoundnbt = tradeList.m_128728_(i);
            int j = compoundnbt.m_128445_("TradeSlot") & 0xFF;
            this.tradeInventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
        if (nbt.m_128441_("HorseUUID")) {
            Optional<UUID> uuid = Optional.of(nbt.m_128342_("HorseUUID"));
            this.setHorseUUID(uuid);
        }
        if (nbt.m_128441_("BoatUUID")) {
            Optional<UUID> uuid = Optional.of(nbt.m_128342_("BoatUUID"));
            this.setBoatUUID(uuid);
        }
        this.setTraveling(nbt.m_128471_("Traveling"));
        this.setAutoStartTravel(nbt.m_128471_("AutoStartTravel"));
        this.setReturning(nbt.m_128471_("Returning"));
        this.setCurrentWayPointIndex(nbt.m_128451_("CurrentWayPointIndex"));
        this.setReturningTime(nbt.m_128451_("ReturningTime"));
        this.setCurrentReturningTime(nbt.m_128451_("CurrentReturningTime"));
        this.setCreative(nbt.m_128471_("isCreative"));
        this.setIsDayCounted(nbt.m_128471_("isDayCounted"));
        BlockPos startPos = this.getNbtPosition(nbt, "CurrentWayPoint");
        if (startPos != null) {
            this.setCurrentWayPoint(startPos);
        }
        ListTag waypointItems = nbt.m_128437_("WaypointItems", 10);
        for (int i = 0; i < waypointItems.size(); ++i) {
            CompoundTag compoundnbt = waypointItems.m_128728_(i);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundnbt);
            this.WAYPOINT_ITEMS.add(itemStack);
        }
        ListTag waypoints = nbt.m_128437_("Waypoints", 10);
        for (int i = 0; i < waypoints.size(); ++i) {
            CompoundTag compoundnbt = waypoints.m_128728_(i);
            BlockPos pos = new BlockPos(compoundnbt.m_128459_("PosX"), compoundnbt.m_128459_("PosY"), compoundnbt.m_128459_("PosZ"));
            this.WAYPOINTS.add(pos);
        }
        ListTag limits = nbt.m_128437_("TradeLimits", 10);
        if (!limits.isEmpty()) {
            for (int i = 0; i < 4; ++i) {
                CompoundTag compoundnbt = limits.m_128728_(i);
                int limit = compoundnbt.m_128451_("Limit");
                this.getTradeLimits().set(i, limit);
            }
        }
        if (!(trades = nbt.m_128437_("Trades", 10)).isEmpty()) {
            for (int i = 0; i < 4; ++i) {
                CompoundTag compoundnbt = trades.m_128728_(i);
                int trade = compoundnbt.m_128451_("Trade");
                this.getCurrentTrades().set(i, trade);
            }
        }
        this.setState(nbt.m_128451_("State"));
        this.setTravelSpeedState(nbt.m_128451_("TravelSpeedState"));
        this.setSendInfo(nbt.m_128471_("InfoTravel"));
    }

    public boolean isReturnTimeElapsed() {
        int maxDays = this.getReturningTime();
        boolean isDayCounted = this.isDayCounted();
        if (this.f_19853_.m_46462_() && !isDayCounted) {
            this.setCurrentReturningTime(this.getCurrentReturningTime() + 1);
            this.setIsDayCounted(true);
        } else if (this.f_19853_.m_46461_()) {
            this.setIsDayCounted(false);
        }
        int currentDays = this.getCurrentReturningTime();
        return currentDays >= maxDays && this.f_19853_.m_46461_();
    }

    public boolean isCreative() {
        return (Boolean)this.f_19804_.m_135370_(IS_CREATIVE);
    }

    public void setCreative(boolean creative) {
        this.f_19804_.m_135381_(IS_CREATIVE, (Object)creative);
    }

    public boolean isDayCounted() {
        return (Boolean)this.f_19804_.m_135370_(IS_DAY_COUNTED);
    }

    public void setIsDayCounted(boolean counted) {
        this.f_19804_.m_135381_(IS_DAY_COUNTED, (Object)counted);
    }

    @Override
    public void setStartPos(BlockPos pos) {
        ItemStack itemStack = this.getItemStackToRender(pos);
        if (pos != null && !this.WAYPOINTS.isEmpty()) {
            boolean notNearFromWaterToCoast;
            BlockPos prevPos = this.WAYPOINTS.get(this.WAYPOINTS.size() - 1);
            double distance = pos.m_123331_((Vec3i)prevPos);
            boolean notNearFromCoastToWater = !this.isWaterBlockPos(prevPos) && this.isWaterBlockPos(pos) && distance >= 75.0;
            boolean notNearInRiverWater = this.m_9236_().m_204166_(pos).m_203656_(BiomeTags.f_207605_) && this.isWaterBlockPos(prevPos) && this.isWaterBlockPos(pos) && distance >= 5000.0;
            boolean bl = notNearFromWaterToCoast = this.isWaterBlockPos(prevPos) && !this.isWaterBlockPos(pos) && distance >= 75.0;
            if (notNearFromCoastToWater || notNearInRiverWater || notNearFromWaterToCoast) {
                if (this.m_21826_() != null) {
                    this.tellPlayer(this.m_21826_(), Translatable.TEXT_WAYPOINT_NOT_NEAR_TO_PREV);
                }
            } else {
                this.WAYPOINT_ITEMS.add(itemStack);
                this.WAYPOINTS.add(pos);
            }
        } else {
            this.WAYPOINT_ITEMS.add(itemStack);
            this.WAYPOINTS.add(pos);
        }
    }

    public ItemStack getItemStackToRender(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        ItemStack itemStack = state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50576_) ? new ItemStack((ItemLike)Items.f_42453_) : (state.m_60713_(Blocks.f_50016_) || state.m_60713_(Blocks.f_50627_) ? new ItemStack((ItemLike)Items.f_42276_) : new ItemStack((ItemLike)state.m_60734_().m_5456_()));
        return itemStack;
    }

    public boolean getAutoStartTravel() {
        return (Boolean)this.f_19804_.m_135370_(AUTO_START_TRAVEL);
    }

    public void setAutoStartTravel(boolean bool) {
        this.f_19804_.m_135381_(AUTO_START_TRAVEL, (Object)bool);
    }

    public SimpleContainer getTradeInventory() {
        return this.tradeInventory;
    }

    public boolean getTraveling() {
        return (Boolean)this.f_19804_.m_135370_(TRAVELING);
    }

    public void setTraveling(boolean traveling) {
        this.f_19804_.m_135381_(TRAVELING, (Object)traveling);
    }

    public boolean getReturning() {
        return (Boolean)this.f_19804_.m_135370_(RETURNING);
    }

    public void setReturning(boolean returning) {
        this.f_19804_.m_135381_(RETURNING, (Object)returning);
    }

    public BlockPos getCurrentWayPoint() {
        return ((Optional)this.f_19804_.m_135370_(CURRENT_WAYPOINT)).orElse(null);
    }

    public void setCurrentWayPoint(BlockPos wayPoint) {
        this.f_19804_.m_135381_(CURRENT_WAYPOINT, Optional.of(wayPoint));
    }

    public int getCurrentWayPointIndex() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_WAYPOINT_INDEX);
    }

    public void setCurrentWayPointIndex(int x) {
        this.f_19804_.m_135381_(CURRENT_WAYPOINT_INDEX, (Object)x);
    }

    public int getReturningTime() {
        return (Integer)this.f_19804_.m_135370_(RETURNING_TIME);
    }

    public void setReturningTime(int x) {
        this.f_19804_.m_135381_(RETURNING_TIME, (Object)x);
    }

    public int getCurrentReturningTime() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_RETURNING_TIME);
    }

    public void setCurrentReturningTime(int x) {
        this.f_19804_.m_135381_(CURRENT_RETURNING_TIME, (Object)x);
    }

    @Nullable
    public UUID getHorseUUID() {
        return ((Optional)this.f_19804_.m_135370_(HORSE_ID)).orElse(null);
    }

    public void setHorseUUID(Optional<UUID> id) {
        this.f_19804_.m_135381_(HORSE_ID, id);
    }

    @Nullable
    public UUID getBoatUUID() {
        return ((Optional)this.f_19804_.m_135370_(BOAT_ID)).orElse(null);
    }

    public void setBoatUUID(Optional<UUID> id) {
        this.f_19804_.m_135381_(BOAT_ID, id);
    }

    @Override
    @Nullable
    public BlockPos getSailPos() {
        return ((Optional)this.f_19804_.m_135370_(SAIL_POS)).orElse(null);
    }

    @Override
    public void setSailPos(BlockPos pos) {
        this.f_19804_.m_135381_(SAIL_POS, Optional.ofNullable(pos));
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setState(int x) {
        this.f_19804_.m_135381_(STATE, (Object)x);
    }

    public int getTravelSpeedState() {
        return (Integer)this.f_19804_.m_135370_(TRAVEL_SPEED_STATE);
    }

    public void setTravelSpeedState(int x) {
        this.f_19804_.m_135381_(TRAVEL_SPEED_STATE, (Object)x);
    }

    public void setTradeLimit(int index, int limit) {
        this.getTradeLimits().set(index, limit);
    }

    public int getTradeLimit(int index) {
        return this.getTradeLimits().get(index);
    }

    public int getCurrentTrades(int index) {
        return this.getCurrentTrades().get(index);
    }

    public List<Integer> getTradeLimits() {
        if (this.TRADE_LIMITS.isEmpty()) {
            this.initTradeLimits();
        }
        return this.TRADE_LIMITS;
    }

    public List<Integer> getCurrentTrades() {
        if (this.CURRENT_TRADES.isEmpty()) {
            this.initCurrentTrades();
        }
        return this.CURRENT_TRADES;
    }

    public void setCurrentTrades(int index, int current) {
        this.getCurrentTrades().set(index, current);
    }

    @Override
    public void m_6667_(@NotNull DamageSource dmg) {
        super.m_6667_(dmg);
        if (!this.isCreative()) {
            for (int i = 0; i < this.tradeInventory.m_6643_(); ++i) {
                Containers.m_18992_((Level)this.f_19853_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)this.tradeInventory.m_8020_(i));
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource dmg, float amt) {
        if (!this.isCreative()) {
            return super.m_6469_(dmg, amt);
        }
        return false;
    }

    public boolean isWaterBlockPos(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        return ALLOWED_WATER_BLOCKS.contains(state.m_60734_());
    }

    public boolean isFreeWater(double x, double y, double z) {
        for (int i = -2; i <= 2; ++i) {
            for (int k = -2; k <= 2; ++k) {
                BlockPos pos = new BlockPos(x, y, z).m_7918_(i, 0, k);
                BlockState state = this.f_19853_.m_8055_(pos);
                if (state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50576_) || state.m_60713_(Blocks.f_50037_) || state.m_60713_(Blocks.f_50038_)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public float getPrecisionMin() {
        int base = 50;
        if (this.m_20202_().m_20078_().contains("smallships")) {
            base = 100;
        }
        return base;
    }

    @Override
    public float getPrecisionMax() {
        int base = 150;
        if (this.m_20202_().m_20078_().contains("smallships")) {
            base = 200;
        }
        return base;
    }

    public boolean getSendInfo() {
        return (Boolean)this.f_19804_.m_135370_(INFO);
    }

    public void setSendInfo(boolean send) {
        this.f_19804_.m_135381_(INFO, (Object)send);
    }

    @Override
    public List<Item> inventoryInputHelp() {
        return null;
    }

    public static enum State {
        IDLE(0),
        HOME(1),
        MOVE_TO_BOAT(2),
        TRAVELING_GROUND(3),
        SAILING(4),
        PAUSING(5),
        ARRIVED(6);

        private final int index;

        private State(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static State fromIndex(int index) {
            for (State state : State.values()) {
                if (state.getIndex() != index) continue;
                return state;
            }
            throw new IllegalArgumentException("Invalid State index: " + index);
        }
    }
}

