/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities;

import com.talhanation.workers.Main;
import com.talhanation.workers.config.WorkersModConfig;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.ai.LumberjackAI;
import com.talhanation.workers.entities.ai.WorkerPickupWantedItemGoal;
import com.talhanation.workers.inventory.WorkerInventoryContainer;
import com.talhanation.workers.network.MessageOpenGuiWorker;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class LumberjackEntity
extends AbstractWorkerEntity {
    public final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && this.m_7243_(item.m_32055_());
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(LumberjackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> REPLANT = SynchedEntityData.m_135353_(LumberjackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public LumberjackEntity(EntityType<? extends AbstractWorkerEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return this.ALLOWED_ITEMS;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public int workerCosts() {
        return (Integer)WorkersModConfig.LumberjackCost.get();
    }

    public static AttributeSupplier.Builder setAttributes() {
        return LumberjackEntity.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WorkerPickupWantedItemGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LumberjackAI(this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(REPLANT, (Object)true);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("State", this.getState());
        nbt.m_128379_("Replant", this.getReplantSaplings());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setState(nbt.m_128451_("State"));
        this.setReplantSaplings(nbt.m_128471_("Replant"));
    }

    public AgeableMob m_142606_(@NotNull ServerLevel p_241840_1_, @NotNull AgeableMob p_241840_2_) {
        return null;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        this.m_213946_(this.f_19796_, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        super.initSpawn();
        MutableComponent name = Component.m_237113_((String)"Lumberjack");
        this.setProfessionName(name.getString());
        this.m_6593_((Component)name);
    }

    @Override
    public boolean isRequiredMainTool(ItemStack tool) {
        return tool.m_41720_() instanceof AxeItem;
    }

    @Override
    public boolean isRequiredSecondTool(ItemStack tool) {
        return false;
    }

    @Override
    public boolean hasAMainTool() {
        return true;
    }

    @Override
    public boolean hasASecondTool() {
        return false;
    }

    public boolean m_7243_(ItemStack itemStack) {
        return itemStack.m_204117_(ItemTags.f_13182_) || itemStack.m_204117_(ItemTags.f_13180_) || itemStack.m_150930_(Items.f_42398_) || itemStack.m_150930_(Items.f_42410_);
    }

    @Override
    public boolean wantsToKeep(ItemStack itemStack) {
        return super.wantsToKeep(itemStack) || itemStack.m_204117_(ItemTags.f_13180_);
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public boolean wantsToBreak(Block block) {
        BlockState blockState = block.m_49966_();
        return blockState.m_204336_(BlockTags.f_13106_);
    }

    @Override
    public void setEquipment() {
        ItemStack initialTool = new ItemStack((ItemLike)Items.f_42428_);
        this.updateInventory(0, initialTool);
        this.equipTool(initialTool);
    }

    @Override
    public void openGUI(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return LumberjackEntity.this.m_7755_();
                }

                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new WorkerInventoryContainer(i, LumberjackEntity.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenGuiWorker(player, this.m_20148_()));
        }
    }

    public void setReplantSaplings(boolean replant) {
        this.f_19804_.m_135381_(REPLANT, (Object)replant);
    }

    public boolean getReplantSaplings() {
        return (Boolean)this.f_19804_.m_135370_(REPLANT);
    }

    @Override
    public List<Item> inventoryInputHelp() {
        return Arrays.asList(Items.f_42386_, Items.f_42799_, Items.f_42801_, Items.f_42800_, Items.f_41828_, Items.f_41827_, Items.f_41826_);
    }

    public static enum State {
        IDLE(0),
        CALC_WORK_POS(1),
        WORKING(2),
        STOPPING(3),
        DEPOSIT(7),
        UPKEEP(8),
        SLEEP(9),
        STOP(10);

        private final int index;

        private State(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static State fromIndex(int index) {
            for (State state : State.values()) {
                if (state.getIndex() != index) continue;
                return state;
            }
            return IDLE;
        }
    }
}

