/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities;

import com.talhanation.workers.Main;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.MerchantEntity;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;

public interface IBoatController {
    public static final int coolDown = 0;

    default public AbstractWorkerEntity getWorker() {
        return (AbstractWorkerEntity)((Object)this);
    }

    public BlockPos getSailPos();

    public float getPrecisionMin();

    public float getPrecisionMax();

    public void setSailPos(BlockPos var1);

    default public void updateBoatControl(double posX, double posZ, double speedFactor, double turnFactor, Node node) {
        Boat boat;
        Entity entity = this.getWorker().m_20202_();
        if (entity instanceof Boat && ((Entity)(boat = (Boat)entity).m_20197_().get(0)).equals((Object)this.getWorker())) {
            String string = boat.m_20078_();
            if (Main.isSmallShipsInstalled && string.contains("smallships")) {
                AbstractWorkerEntity abstractWorkerEntity = this.getWorker();
                if (abstractWorkerEntity instanceof MerchantEntity) {
                    boolean wayPointIsDeep;
                    MerchantEntity merchant = (MerchantEntity)abstractWorkerEntity;
                    boolean onPosIsDeep = IBoatController.getWaterDepth(boat.m_20097_(), (LivingEntity)this.getWorker()) >= 7;
                    boolean bl = wayPointIsDeep = merchant.getCurrentWayPoint() != null && IBoatController.getWaterDepth(merchant.getCurrentWayPoint(), (LivingEntity)this.getWorker()) >= 7;
                    if (onPosIsDeep && merchant.getCurrentWayPoint() != null && !boat.f_19862_) {
                        if (merchant.getStatus() != AbstractWorkerEntity.Status.FOLLOW) {
                            this.updateSmallShipsBoatControl(merchant, boat, merchant.getCurrentWayPoint().m_123341_(), merchant.getCurrentWayPoint().m_123343_(), wayPointIsDeep);
                        } else if (merchant.m_21826_() != null) {
                            boolean ownerFar;
                            boolean ownerOnPosIsDeep = IBoatController.getWaterDepth(merchant.m_21826_().m_20097_(), (LivingEntity)this.getWorker()) >= 7;
                            boolean bl2 = ownerFar = merchant.m_20280_((Entity)merchant.m_21826_()) > 30.0;
                            if (ownerOnPosIsDeep) {
                                this.updateSmallShipsBoatControl(merchant, boat, merchant.m_21826_().m_20185_(), merchant.m_21826_().m_20189_(), ownerFar);
                            } else {
                                this.updateSmallShipsBoatControl(merchant, boat, posX, posZ, ownerFar);
                            }
                        }
                    } else {
                        this.updateSmallShipsBoatControl(merchant, boat, posX, posZ, false);
                    }
                }
            } else {
                this.updateVanillaBoatControl(boat, posX, posZ, speedFactor, turnFactor);
            }
        }
    }

    default public void updateVanillaBoatControl(Boat boat, double posX, double posZ, double speedFactor, double turnFactor) {
        double reff;
        Vec3 forward = boat.m_20156_().m_82524_(-90.0f).m_82541_();
        Vec3 target = new Vec3(posX, 0.0, posZ);
        Vec3 toTarget = boat.m_20182_().m_82546_(target).m_82541_();
        double phi = this.horizontalAngleBetweenVectors(forward, toTarget);
        boolean inputLeft = phi < (reff = 63.5);
        boolean inputRight = phi > reff;
        boolean inputUp = Math.abs(phi - reff) <= reff * (double)0.15f;
        float f = 0.0f;
        if (inputLeft) {
            boat.m_146922_(boat.m_146908_() - 2.5f);
        }
        if (inputRight) {
            boat.m_146922_(boat.m_146908_() + 2.5f);
        }
        if (inputRight != inputLeft && !inputUp) {
            f = (float)((double)f + (double)0.005f * speedFactor);
        }
        if (inputUp) {
            f = (float)((double)f + (double)0.02f * speedFactor);
        }
        boat.m_20256_(boat.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-boat.m_146908_() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.m_14089_((float)(boat.m_146908_() * ((float)Math.PI / 180))) * f)));
        boat.m_38339_(inputRight || inputUp, inputLeft || inputUp);
    }

    default public void updateSmallShipsBoatControl(MerchantEntity merchant, Boat boat, double posX, double posZ, boolean fast) {
        double ref;
        Vec3 forward = boat.m_20156_().m_82524_(-90.0f).m_82541_();
        Vec3 target = new Vec3(posX, 0.0, posZ);
        Vec3 toTarget = boat.m_20182_().m_82546_(target).m_82541_();
        double phi = this.horizontalAngleBetweenVectors(forward, toTarget);
        boolean inputLeft = phi < (ref = 63.5);
        boolean inputRight = phi > ref;
        boolean inputUp = Math.abs(phi - ref) <= ref * (double)0.35f;
        boolean inAngleForSail = Math.abs(phi - ref) <= ref * 0.8;
        float boatSpeed = 0.0f;
        float boatRotSpeed = 0.0f;
        float maxRotSp = 2.0f;
        float rotAcceleration = 0.35f;
        float acceleration = 0.005f;
        float setPoint = 0.0f;
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(boat)) {
                Object ship = shipClass.cast(boat);
                Method shipClassSetRotSpeed = shipClass.getMethod("setRotSpeed", Float.TYPE);
                Method shipClassGetSpeed = shipClass.getMethod("getSpeed", new Class[0]);
                Method shipClassGetRotSpeed = shipClass.getMethod("getRotSpeed", new Class[0]);
                Method shipClassUpdateControls = shipClass.getMethod("updateControls", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Player.class);
                boatSpeed = ((Float)shipClassGetSpeed.invoke(ship, new Object[0])).floatValue();
                boatRotSpeed = ((Float)shipClassGetRotSpeed.invoke(ship, new Object[0])).floatValue();
                shipClassUpdateControls.invoke(ship, inputUp, false, inputLeft, inputRight, null);
                if (!inAngleForSail) {
                    this.setSmallShipsSailState((Boat)ship, 0);
                    setPoint = 0.02f;
                } else if (inputUp) {
                    double distance = toTarget.m_82557_(boat.m_20182_());
                    int state = 3;
                    if (fast) {
                        state = 4;
                        setPoint = 0.3f;
                    } else {
                        setPoint = distance > 20.0 ? 0.15f : 0.075f;
                    }
                    this.setSmallShipsSailState((Boat)ship, state);
                } else if (merchant.getTraveling() || merchant.getReturning() || merchant.getStatus() == AbstractWorkerEntity.Status.FOLLOW) {
                    this.setSmallShipsSailState((Boat)ship, 1);
                    setPoint = 0.025f;
                } else {
                    this.setSmallShipsSailState((Boat)ship, 0);
                    setPoint = 0.0f;
                }
                this.calculateSpeed(boat, boatSpeed, acceleration, setPoint);
                float rotationSpeed = this.subtractToZero(boatRotSpeed, this.getVelocityResistance() * 2.5f);
                if (inputRight && rotationSpeed < maxRotSp) {
                    rotationSpeed = Math.min(rotationSpeed + rotAcceleration * 1.0f / 8.0f, maxRotSp);
                }
                if (inputLeft && rotationSpeed > -maxRotSp) {
                    rotationSpeed = Math.max(rotationSpeed - rotAcceleration * 1.0f / 8.0f, -maxRotSp);
                }
                boat.f_38266_ = rotationSpeed;
                boat.m_146922_(boat.m_146908_() + boat.f_38266_);
                boat.m_20334_(this.calculateMotionX(boatSpeed, boat.m_146908_()), 0.0, this.calculateMotionZ(boatSpeed, boat.m_146908_()));
                shipClassSetRotSpeed.invoke(ship, Float.valueOf(rotationSpeed));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("shipClass was not found");
        }
    }

    default public void setSmallShipsSailState(Boat boat, int state) {
        block6: {
            try {
                Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
                Field coolDownFlied = shipClass.getField("sailStateCooldown");
                int coolDown = coolDownFlied.getInt(boat);
                if (coolDown != 0) break block6;
                try {
                    Class<?> sailableClass = Class.forName("com.talhanation.smallships.world.entity.ship.abilities.Sailable");
                    if (sailableClass.isInstance(boat)) {
                        Object sailable = sailableClass.cast(boat);
                        Method sailableClassGetSailStateCooldown = sailableClass.getMethod("getSailStateCooldown", new Class[0]);
                        int configCoolDown = (Integer)sailableClassGetSailStateCooldown.invoke(sailable, new Object[0]);
                        Method sailableClassSetSailState = sailableClass.getMethod("setSailState", Byte.TYPE);
                        Method sailableClassGetSailState = sailableClass.getMethod("getSailState", new Class[0]);
                        byte currentSail = (Byte)sailableClassGetSailState.invoke(sailable, new Object[0]);
                        if (currentSail != (byte)state) {
                            sailableClassSetSailState.invoke(sailable, (byte)state);
                        }
                        coolDownFlied.setInt(boat, configCoolDown);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    Main.LOGGER.info("SailableClass was not found");
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                Main.LOGGER.info("shipClass was not found");
            }
        }
    }

    default public float getVelocityResistance() {
        return 0.007f;
    }

    private void calculateSpeed(Boat boat, float speed, float acceleration, float setPoint) {
        speed = speed < setPoint ? this.addToSetPoint(speed, acceleration, setPoint) : this.subtractToZero(speed, this.getVelocityResistance() * 2.2f);
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(boat)) {
                Object ship = shipClass.cast(boat);
                Method shipClassSetSpeed = shipClass.getMethod("setSpeed", Float.TYPE);
                shipClassSetSpeed.invoke(ship, Float.valueOf(speed));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("shipClass was not found");
        }
    }

    private float addToSetPoint(float current, float positiveChange, float setPoint) {
        if (current < setPoint) {
            current += positiveChange;
        }
        return current;
    }

    private double calculateMotionX(float speed, float rotationYaw) {
        return Mth.m_14031_((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    private double calculateMotionZ(float speed, float rotationYaw) {
        return Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    private float subtractToZero(float num, float sub) {
        float erg;
        if (num < 0.0f) {
            erg = num + sub;
            if (erg > 0.0f) {
                erg = 0.0f;
            }
        } else {
            erg = num - sub;
            if (erg < 0.0f) {
                erg = 0.0f;
            }
        }
        return erg;
    }

    private double horizontalAngleBetweenVectors(Vec3 vector1, Vec3 vector2) {
        double dotProduct = vector1.f_82479_ * vector2.f_82479_ + vector1.f_82481_ * vector2.f_82481_;
        double magnitude1 = Math.sqrt(vector1.f_82479_ * vector1.f_82479_ + vector1.f_82481_ * vector1.f_82481_);
        double magnitude2 = Math.sqrt(vector2.f_82479_ * vector2.f_82479_ + vector2.f_82481_ * vector2.f_82481_);
        double cosTheta = dotProduct / (magnitude1 * magnitude2);
        return Math.toDegrees(Math.acos(cosTheta));
    }

    public static int getWaterDepth(BlockPos pos, LivingEntity worker) {
        BlockState state;
        int depth = 0;
        for (int i = 0; i < 10 && ((state = worker.f_19853_.m_8055_(pos.m_6625_(i))).m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_50576_) || state.m_60713_(Blocks.f_50575_)); ++i) {
            ++depth;
        }
        return depth;
    }
}

