/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities;

import com.google.common.collect.ImmutableSet;
import com.talhanation.workers.Main;
import com.talhanation.workers.config.WorkersModConfig;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.ai.FarmerAI;
import com.talhanation.workers.entities.ai.WorkerPickupWantedItemGoal;
import com.talhanation.workers.inventory.WorkerInventoryContainer;
import com.talhanation.workers.network.MessageOpenGuiWorker;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class FarmerEntity
extends AbstractWorkerEntity {
    private final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && this.m_7243_(item.m_32055_());
    public static final Set<Item> WANTED_SEEDS = ImmutableSet.of((Object)Items.f_42404_, (Object)Items.f_42578_, (Object)Items.f_42620_, (Object)Items.f_42733_, (Object)Items.f_42619_);
    public final Set<Item> WANTED_ITEMS = ImmutableSet.of((Object)Items.f_42405_, (Object)Items.f_42575_, (Object)Items.f_42620_, (Object)Items.f_42732_, (Object)Items.f_42619_);
    public static final Set<Block> CROP_BLOCKS = ImmutableSet.of((Object)Blocks.f_50092_, (Object)Blocks.f_50250_, (Object)Blocks.f_50249_, (Object)Blocks.f_50444_, (Object)Blocks.f_50186_, (Object)Blocks.f_50133_, (Object[])new Block[0]);
    public static final Set<Block> TILLABLES = ImmutableSet.of((Object)Blocks.f_50493_, (Object)Blocks.f_152549_, (Object)Blocks.f_50546_, (Object)Blocks.f_50440_);

    public FarmerEntity(EntityType<? extends AbstractWorkerEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
    }

    @Override
    public boolean canWorkWithoutTool() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public int workerCosts() {
        return (Integer)WorkersModConfig.FarmerCost.get();
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return this.ALLOWED_ITEMS;
    }

    @Override
    public void openGUI(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return FarmerEntity.this.m_7755_();
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new WorkerInventoryContainer(i, FarmerEntity.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenGuiWorker(player, this.m_20148_()));
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return FarmerEntity.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WorkerPickupWantedItemGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FarmerAI(this));
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel p_241840_1_, @NotNull AgeableMob p_241840_2_) {
        return null;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficultyInstance, @NotNull MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        this.m_213946_(this.f_19796_, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        super.initSpawn();
        MutableComponent name = Component.m_237113_((String)"Farmer");
        this.setProfessionName(name.getString());
        this.m_6593_((Component)name);
    }

    @Override
    public boolean isRequiredMainTool(ItemStack tool) {
        return tool.m_41720_() instanceof HoeItem;
    }

    @Override
    public boolean isRequiredSecondTool(ItemStack tool) {
        return false;
    }

    @Override
    public boolean hasAMainTool() {
        return true;
    }

    @Override
    public boolean hasASecondTool() {
        return false;
    }

    public boolean m_7243_(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return this.WANTED_ITEMS.contains(item) || WANTED_SEEDS.contains(item);
    }

    @Override
    public boolean wantsToKeep(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return super.wantsToKeep(itemStack) || WANTED_SEEDS.contains(item);
    }

    @Override
    public void setEquipment() {
        ItemStack initialTool = new ItemStack((ItemLike)Items.f_42424_);
        this.updateInventory(0, initialTool);
        this.equipTool(initialTool);
    }

    @Override
    public List<Item> inventoryInputHelp() {
        return Arrays.asList(Items.f_42387_, Items.f_42499_, Items.f_42404_, Items.f_42733_, Items.f_42619_, Items.f_42620_);
    }
}

