/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities;

import com.google.common.collect.ImmutableSet;
import com.talhanation.workers.config.WorkersModConfig;
import com.talhanation.workers.entities.AbstractAnimalFarmerEntity;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.ai.ChickenFarmerAI;
import com.talhanation.workers.entities.ai.WorkerPickupWantedItemGoal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class ChickenFarmerEntity
extends AbstractAnimalFarmerEntity {
    private static final EntityDataAccessor<Boolean> USE_EGGS = SynchedEntityData.m_135353_(ChickenFarmerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && this.m_7243_(item.m_32055_());
    public final ItemStack MAIN_TOOL = new ItemStack((ItemLike)Items.f_42428_);
    private static final Set<Item> WANTED_ITEMS = ImmutableSet.of((Object)Items.f_42402_, (Object)Items.f_42581_, (Object)Items.f_42521_, (Object)Items.f_42404_, (Object)Items.f_42733_, (Object)Items.f_42578_, (Object[])new Item[]{Items.f_42577_});

    public ChickenFarmerEntity(EntityType<? extends AbstractAnimalFarmerEntity> entityType, Level world) {
        super((EntityType<? extends AbstractWorkerEntity>)entityType, world);
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(USE_EGGS, (Object)true);
        super.m_8097_();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("UseEggs", this.getUseEggs());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setUseEggs(nbt.m_128471_("UseEggs"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public int workerCosts() {
        return (Integer)WorkersModConfig.ChickenFarmerCost.get();
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return this.ALLOWED_ITEMS;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ChickenFarmerEntity.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WorkerPickupWantedItemGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ChickenFarmerAI(this));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        this.m_213946_(this.f_19796_, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        super.initSpawn();
        MutableComponent name = Component.m_237113_((String)"Chicken Farmer");
        this.setProfessionName(name.getString());
        this.m_6593_((Component)name);
    }

    public boolean m_7243_(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return WANTED_ITEMS.contains(item);
    }

    @Override
    public boolean wantsToKeep(ItemStack itemStack) {
        return super.wantsToKeep(itemStack) || this.isBreedItem(itemStack) || this.getUseEggs() && itemStack.m_41720_().equals(Items.f_42521_);
    }

    @Override
    public void setEquipment() {
        ItemStack initialTool = this.MAIN_TOOL;
        this.updateInventory(0, initialTool);
        this.equipTool(initialTool);
    }

    @Override
    public boolean isRequiredMainTool(ItemStack tool) {
        return tool.m_41720_() instanceof AxeItem;
    }

    @Override
    public boolean isRequiredSecondTool(ItemStack tool) {
        return false;
    }

    @Override
    public boolean hasAMainTool() {
        return true;
    }

    @Override
    public boolean hasASecondTool() {
        return false;
    }

    public boolean isBreedItem(ItemStack itemStack) {
        return itemStack.m_41720_().equals(Items.f_42404_) || itemStack.m_41720_().equals(Items.f_42578_) || itemStack.m_41720_().equals(Items.f_42733_) || itemStack.m_41720_().equals(Items.f_42577_);
    }

    public void setUseEggs(boolean useEggs) {
        this.f_19804_.m_135381_(USE_EGGS, (Object)useEggs);
    }

    public boolean getUseEggs() {
        return (Boolean)this.f_19804_.m_135370_(USE_EGGS);
    }

    @Override
    public List<Item> inventoryInputHelp() {
        return Arrays.asList(Items.f_42386_, Items.f_42521_, Items.f_42404_, Items.f_42733_, Items.f_42578_, Items.f_42577_);
    }
}

