/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.CattleFarmerEntity;
import com.talhanation.workers.entities.ChickenFarmerEntity;
import com.talhanation.workers.entities.FarmerEntity;
import com.talhanation.workers.entities.FishermanEntity;
import com.talhanation.workers.entities.LumberjackEntity;
import com.talhanation.workers.entities.MinerEntity;
import com.talhanation.workers.entities.ShepherdEntity;
import com.talhanation.workers.entities.SwineherdEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInventoryEntity
extends TamableAnimal {
    private final SimpleContainer inventory = new SimpleContainer(18);

    public AbstractInventoryEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21205_().m_41619_()) {
            this.upgradeTool();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag list = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundnbt);
            list.add((Object)compoundnbt);
        }
        nbt.m_128365_("Inventory", (Tag)list);
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        ListTag list = nbt.m_128437_("Inventory", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compoundnbt = list.m_128728_(i);
            int j = compoundnbt.m_128445_("Slot") & 0xFF;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public void updateInventory(int slot, ItemStack stack) {
        this.inventory.m_6836_(slot, stack);
    }

    public void upgradeTool() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack item = this.inventory.m_8020_(i);
            Item itemType = item.m_41720_();
            if (itemType instanceof AxeItem && this instanceof LumberjackEntity) {
                this.handleToolUpgrade(item, i);
            }
            if (itemType instanceof PickaxeItem && this instanceof MinerEntity) {
                this.handleToolUpgrade(item, i);
            }
            if (itemType instanceof HoeItem && this instanceof FarmerEntity) {
                this.handleToolUpgrade(item, i);
            }
            if (itemType instanceof FishingRodItem && this instanceof FishermanEntity) {
                this.handleToolUpgrade(item, i);
            }
            if ((itemType instanceof ShearsItem || itemType instanceof AxeItem) && this instanceof ShepherdEntity) {
                this.handleToolUpgrade(item, i);
            }
            if (!(itemType instanceof AxeItem) || !(this instanceof CattleFarmerEntity) && !(this instanceof ChickenFarmerEntity) && !(this instanceof SwineherdEntity)) continue;
            this.handleToolUpgrade(item, i);
        }
    }

    public void upgradeArmor() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            Item item = itemStack.m_41720_();
            if (!(item instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)item;
            EquipmentSlot slot = armorItem.m_40402_();
            this.m_8061_(slot, itemStack);
        }
    }

    private void handleToolUpgrade(ItemStack tool, int inventoryIndex) {
        if (tool.m_41773_() >= tool.m_41776_()) {
            this.inventory.m_6836_(inventoryIndex, ItemStack.f_41583_);
        } else {
            this.equipTool(tool);
        }
    }

    public void equipTool(ItemStack tool) {
        this.m_21008_(InteractionHand.MAIN_HAND, tool);
        this.m_142106_(tool);
        AbstractInventoryEntity abstractInventoryEntity = this;
        if (abstractInventoryEntity instanceof AbstractWorkerEntity) {
            AbstractWorkerEntity worker = (AbstractWorkerEntity)abstractInventoryEntity;
            if (worker.isRequiredMainTool(tool)) {
                worker.needsMainTool = false;
            }
            if (worker.isRequiredSecondTool(tool)) {
                worker.needsSecondTool = false;
            }
        }
    }

    public boolean m_21540_(ItemStack p_21541_) {
        return super.m_21540_(p_21541_);
    }

    public void m_6667_(@NotNull DamageSource dmg) {
        Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this.inventory);
        super.m_6667_(dmg);
    }
}

