/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities;

import com.talhanation.workers.config.WorkersModConfig;
import com.talhanation.workers.entities.AbstractInventoryEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChunkLoaderEntity
extends AbstractInventoryEntity {
    private Optional<WorkersChunk> loadedChunk = Optional.empty();

    public AbstractChunkLoaderEntity(EntityType<? extends AbstractChunkLoaderEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.updateChunkLoading();
    }

    public void updateChunkLoading() {
        if (((Boolean)WorkersModConfig.WorkerChunkLoading.get()).booleanValue() && !this.f_19853_.f_46443_) {
            WorkersChunk currentChunk = new WorkersChunk(this.m_146902_().f_45578_, this.m_146902_().f_45579_);
            if (this.loadedChunk.isEmpty()) {
                this.setForceChunk(currentChunk, true);
                this.loadedChunk = Optional.of(currentChunk);
            } else if (!currentChunk.equals(this.loadedChunk.get())) {
                Set<WorkersChunk> toForce = this.getSetOfChunks(currentChunk);
                Set<WorkersChunk> toUnForce = this.getSetOfChunks(this.loadedChunk.get());
                toUnForce.removeAll(toForce);
                Set<WorkersChunk> forced = this.getSetOfChunks(this.loadedChunk.get());
                toForce.removeAll(forced);
                toUnForce.forEach(chunk -> this.setForceChunk((WorkersChunk)chunk, false));
                toForce.forEach(chunk -> this.setForceChunk((WorkersChunk)chunk, true));
                this.loadedChunk = Optional.of(currentChunk);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.loadedChunk.isPresent()) {
            nbt.m_128405_("chunkX", this.loadedChunk.get().x);
            nbt.m_128405_("chunkZ", this.loadedChunk.get().z);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("chunkX")) {
            int x = nbt.m_128451_("chunkX");
            int z = nbt.m_128451_("chunkZ");
            this.loadedChunk = Optional.of(new WorkersChunk(x, z));
        }
    }

    private Set<WorkersChunk> getSetOfChunks(WorkersChunk chunk) {
        HashSet<WorkersChunk> set = new HashSet<WorkersChunk>();
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                set.add(new WorkersChunk(chunk.x + i, chunk.z + k));
            }
        }
        return set;
    }

    private void setForceChunk(WorkersChunk chunk, boolean add) {
        ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_19853_), (String)"workers", (Entity)this, (int)chunk.x, (int)chunk.z, (boolean)add, (boolean)false);
    }

    public void m_6074_() {
        super.m_6074_();
        if (!this.f_19853_.f_46443_) {
            this.loadedChunk.ifPresent(chunk -> this.getSetOfChunks((WorkersChunk)chunk).forEach(chunk1 -> this.setForceChunk((WorkersChunk)chunk1, false)));
        }
    }

    public static class WorkersChunk {
        int x;
        int z;

        public WorkersChunk(ChunkPos chunkPosition) {
            this(chunkPosition.f_45578_, chunkPosition.f_45579_);
        }

        public WorkersChunk(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean isSame(WorkersChunk otherChunk) {
            if (otherChunk != null) {
                return this.x == otherChunk.x && this.z == otherChunk.z;
            }
            return false;
        }

        public WorkersChunk getNextChunk(Direction direction) {
            WorkersChunk workersChunk = null;
            switch (direction) {
                case NORTH: {
                    workersChunk = new WorkersChunk(this.x, this.z - 1);
                    break;
                }
                case EAST: {
                    workersChunk = new WorkersChunk(this.x + 1, this.z);
                    break;
                }
                case SOUTH: {
                    workersChunk = new WorkersChunk(this.x, this.z + 1);
                    break;
                }
                case WEST: {
                    workersChunk = new WorkersChunk(this.x - 1, this.z);
                    break;
                }
            }
            return workersChunk;
        }

        public static List<WorkersChunk> getSurroundingChunks(@NotNull WorkersChunk currentChunk) {
            ArrayList<WorkersChunk> list = new ArrayList<WorkersChunk>();
            for (int i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    WorkersChunk newChunk = new WorkersChunk(currentChunk.x + i, currentChunk.z + k);
                    list.add(newChunk);
                }
            }
            return list;
        }

        public static List<WorkersChunk> getChunksToUnload(List<WorkersChunk> currentChunks, List<WorkersChunk> prevChunks) {
            ArrayList<WorkersChunk> list = new ArrayList<WorkersChunk>();
            for (WorkersChunk prevChunk : prevChunks) {
                for (WorkersChunk currentChunk : currentChunks) {
                    if (currentChunk.isSame(prevChunk)) continue;
                    list.add(prevChunk);
                }
            }
            return list;
        }
    }
}

