/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.workers.Main;
import com.talhanation.workers.Translatable;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.LumberjackEntity;
import com.talhanation.workers.entities.MinerEntity;
import com.talhanation.workers.inventory.WorkerInventoryContainer;
import com.talhanation.workers.network.MessageLumberjackReplant;
import de.maxhenkel.workers.corelib.inventory.ScreenBase;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class WorkerInventoryScreen
extends ScreenBase<WorkerInventoryContainer> {
    private static final ResourceLocation GUI_TEXTURE_3 = new ResourceLocation("workers", "textures/gui/worker_gui.png");
    private final AbstractWorkerEntity worker;
    private final Inventory playerInventory;
    private boolean replantSaplings;

    public WorkerInventoryScreen(WorkerInventoryContainer container, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE_3, container, playerInventory, (Component)Component.m_237113_((String)""));
        Main.LOGGER.info("WorkerInventoryScreen loaded");
        this.worker = container.getWorker();
        this.playerInventory = playerInventory;
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        AbstractWorkerEntity abstractWorkerEntity = this.worker;
        if (abstractWorkerEntity instanceof LumberjackEntity) {
            LumberjackEntity lumberjack = (LumberjackEntity)abstractWorkerEntity;
            this.replantSaplings = lumberjack.getReplantSaplings();
        }
        this.setButtons();
    }

    private void setButtons() {
        this.m_169413_();
        if (this.worker instanceof LumberjackEntity) {
            String string = this.replantSaplings ? "True" : "False";
            this.setReplantSaplingsButton(string);
        }
    }

    private void setReplantSaplingsButton(String string) {
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 190, this.f_97736_ + 57, 40, 20, (Component)Component.m_237113_((String)string), button1 -> {
            this.replantSaplings = !this.replantSaplings;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageLumberjackReplant(this.worker.m_20148_(), this.replantSaplings));
            this.setButtons();
        }, (button1, poseStack, i, i1) -> this.m_96602_(poseStack, Translatable.TOOLTIP_LUMBER_REPLANT, i, i1)));
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        int offset;
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.f_96547_.m_92877_(matrixStack, this.worker.m_5446_().m_7532_(), 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92877_(matrixStack, this.playerInventory.m_5446_().m_7532_(), 8.0f, (float)(this.f_97727_ - 152 + 3), 0x404040);
        int n = offset = this.worker instanceof MinerEntity ? 10 : 0;
        if (this.worker.inventoryInputHelp() != null) {
            for (int i = 0; i < this.worker.inventoryInputHelp().size(); ++i) {
                this.renderItemAt(this.worker.inventoryInputHelp().get(i).m_7968_(), 60 - offset + 15 * i, this.f_97727_ - 165);
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
    }

    private void renderItemAt(ItemStack itemStack, int x, int y) {
        if (itemStack != null) {
            this.f_96542_.m_115203_(itemStack, x, y);
        }
    }
}

