/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.workers.Main;
import com.talhanation.workers.Translatable;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.inventory.MerchantWaypointContainer;
import com.talhanation.workers.network.MessageMerchantAddWayPoint;
import com.talhanation.workers.network.MessageMerchantRemoveWayPoint;
import com.talhanation.workers.network.MessageMerchantReturnTime;
import com.talhanation.workers.network.MessageMerchantSetAutoStartTravel;
import com.talhanation.workers.network.MessageMerchantSetSendInfo;
import com.talhanation.workers.network.MessageMerchantSetTravelSpeed;
import com.talhanation.workers.network.MessageMerchantTravel;
import de.maxhenkel.workers.corelib.inventory.ScreenBase;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class MerchantWaypointScreen
extends ScreenBase<MerchantWaypointContainer> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("workers", "textures/gui/waypoint_list_gui.png");
    private int leftPos;
    private int topPos;
    private int page = 1;
    public static List<BlockPos> waypoints;
    public static List<ItemStack> waypointItems;
    private final MerchantEntity merchant;
    private final Player player;
    private int returnTime;
    public static boolean isStarted;
    public static boolean isReturning;
    public static boolean isStopped;
    public boolean autoStart;
    public boolean sendInfo;
    public int travelSpeedState;

    public MerchantWaypointScreen(MerchantWaypointContainer container, Inventory playerInventory, Component title) {
        super(RESOURCE_LOCATION, container, playerInventory, (Component)Component.m_237113_((String)""));
        this.f_97726_ = 211;
        this.f_97727_ = 250;
        this.merchant = (MerchantEntity)container.getWorkerEntity();
        this.player = playerInventory.f_35978_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.f_97726_) / 2;
        this.topPos = (this.f_96544_ - this.f_97727_) / 2;
        this.returnTime = this.merchant.getReturningTime();
        this.autoStart = this.merchant.getAutoStartTravel();
        this.sendInfo = this.merchant.getSendInfo();
        this.travelSpeedState = this.merchant.getTravelSpeedState();
        this.setButtons();
    }

    private void setButtons() {
        this.m_169413_();
        this.setStartButtons();
        this.setPageButtons();
        this.setWaypointButtons();
        this.setDaysButtons();
        String s = "";
        switch (this.travelSpeedState) {
            case 0: {
                s = "Slow";
                break;
            }
            case 1: {
                s = "Medium";
                break;
            }
            case 2: {
                s = "Fast";
            }
        }
        this.createSetTravelSpeedButton(s);
        String ss = this.autoStart ? "True" : "False";
        this.createSetAutoStartTravelButton(ss);
        String sss = this.sendInfo ? "True" : "False";
        this.createSetSendInfoButton(sss);
    }

    private void createSetTravelSpeedButton(String s) {
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 240, this.topPos + 32, 40, 20, (Component)Component.m_237113_((String)s), button -> {
            ++this.travelSpeedState;
            if (this.travelSpeedState > 2) {
                this.travelSpeedState = 0;
            }
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantSetTravelSpeed(this.merchant.m_20148_(), this.travelSpeedState));
            this.setButtons();
        }, (button1, poseStack, i, i1) -> this.m_96602_(poseStack, Translatable.TOOLTIP_TRAVEL_SPEED, i, i1)));
    }

    private void createSetAutoStartTravelButton(String ss) {
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 240, this.topPos + 57, 40, 20, (Component)Component.m_237113_((String)ss), button -> {
            this.autoStart = !this.autoStart;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantSetAutoStartTravel(this.merchant.m_20148_(), this.autoStart));
            this.setButtons();
        }, (button1, poseStack, i, i1) -> this.m_96602_(poseStack, Translatable.TOOLTIP_AUTO_START_TRAVEL, i, i1)));
    }

    private void createSetSendInfoButton(String ss) {
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 240, this.topPos + 82, 40, 20, (Component)Component.m_237113_((String)ss), button -> {
            this.sendInfo = !this.sendInfo;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantSetSendInfo(this.merchant.m_20148_(), this.sendInfo));
            this.setButtons();
        }, (button1, poseStack, i, i1) -> this.m_96602_(poseStack, Translatable.TOOLTIP_SEND_INFO, i, i1)));
    }

    public void setStartButtons() {
        Button start = this.createTravelStartButton();
        start.f_93623_ = true;
        Button stop = this.createTravelStopButton();
        stop.f_93623_ = true;
        Button returnButton = this.createTravelReturnButton();
        returnButton.f_93623_ = true;
    }

    public void setPageButtons() {
        Button pageForwardButton = this.createPageForwardButton();
        pageForwardButton.f_93623_ = waypoints.size() > 9;
        Button pageBackButton = this.createPageBackButton();
        pageBackButton.f_93623_ = this.page != 1;
    }

    public void setWaypointButtons() {
        Button addButton = this.createAddWaypointButton(this.leftPos + 171, this.topPos + 32);
        Button removeButton = this.createRemoveWaypointButton(this.leftPos + 148, this.topPos + 32);
        addButton.f_93623_ = true;
        removeButton.f_93623_ = true;
        Button info = this.createTravelInfoButton(this.leftPos + 215, this.topPos + 32);
    }

    public void setDaysButtons() {
        ExtendedButton addButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 186, this.topPos + 8, 9, 9, (Component)Component.m_237113_((String)"+"), button -> {
            this.returnTime = this.merchant.getReturningTime();
            this.returnTime = this.player.m_6144_() ? (this.returnTime += 5) : ++this.returnTime;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantReturnTime(this.returnTime, this.merchant.m_20148_()));
            this.setButtons();
        }));
        ExtendedButton removeButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 175, this.topPos + 8, 9, 9, (Component)Component.m_237113_((String)"-"), button -> {
            this.returnTime = this.merchant.getReturningTime();
            this.returnTime = this.player.m_6144_() ? (this.returnTime -= 5) : --this.returnTime;
            if (this.returnTime < 0) {
                this.returnTime = 0;
            }
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantReturnTime(this.returnTime, this.merchant.m_20148_()));
            this.setButtons();
        }));
        removeButton.f_93623_ = this.returnTime > 0;
    }

    private Button createTravelStartButton() {
        return (Button)this.m_142416_((GuiEventListener)new Button(this.leftPos + 19, this.topPos + 32, 40, 20, Translatable.TEXT_BUTTON_TRAVEL_START, button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTravel(this.merchant.m_20148_(), true, false));
            this.setButtons();
        }, (button1, poseStack, i, i1) -> this.m_96602_(poseStack, Translatable.TOOLTIP_TRAVEL_START, i, i1)));
    }

    private Button createTravelStopButton() {
        return (Button)this.m_142416_((GuiEventListener)new Button(this.leftPos + 62, this.topPos + 32, 40, 20, Translatable.TEXT_BUTTON_TRAVEL_STOP, button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTravel(this.merchant.m_20148_(), false, false));
            this.setButtons();
        }, (button1, poseStack, i, i1) -> this.m_96602_(poseStack, Translatable.TOOLTIP_TRAVEL_STOP, i, i1)));
    }

    private Button createTravelReturnButton() {
        return (Button)this.m_142416_((GuiEventListener)new Button(this.leftPos + 105, this.topPos + 32, 40, 20, Translatable.TEXT_BUTTON_TRAVEL_RETURN, button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTravel(this.merchant.m_20148_(), true, true));
            this.setButtons();
        }, (button1, poseStack, i, i1) -> this.m_96602_(poseStack, Translatable.TOOLTIP_TRAVEL_RETURN, i, i1)));
    }

    private Button createTravelInfoButton(int x, int y) {
        Button button = (Button)this.m_142416_((GuiEventListener)new Button(x, y, 20, 20, (Component)Component.m_237113_((String)"i"), press -> {
            this.setButtons();
            this.player.m_213846_(Translatable.TEXT_TRAVEL_INFO);
            this.m_7379_();
        }, (button1, poseStack, i, i1) -> this.m_96602_(poseStack, Translatable.TOOLTIP_TRAVEL_INFO, i, i1)));
        return button;
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        int fontColor = 0x404040;
        int waypointsPerPage = 10;
        this.returnTime = this.merchant.getReturningTime();
        int currentReturningTime = this.merchant.getCurrentReturningTime();
        this.f_96547_.m_92883_(matrixStack, "Days:", 20.0f, 9.0f, 0x404040);
        this.f_96547_.m_92883_(matrixStack, currentReturningTime + " / " + this.merchant.getReturningTime(), 110.0f, 9.0f, 0x404040);
        int currentWayPoint = waypoints.size() == 0 ? 0 : this.merchant.getCurrentWayPointIndex() + 1;
        this.f_96547_.m_92883_(matrixStack, "Waypoints:", 20.0f, 20.0f, 0x404040);
        this.f_96547_.m_92883_(matrixStack, currentWayPoint + " / " + waypoints.size(), 110.0f, 20.0f, 0x404040);
        int startIndex = (this.page - 1) * waypointsPerPage;
        int endIndex = Math.min(startIndex + waypointsPerPage, waypoints.size());
        if (!waypoints.isEmpty()) {
            for (int i = startIndex; i < endIndex; ++i) {
                BlockPos pos = waypoints.get(i);
                int x = pos.m_123341_();
                int y = pos.m_123342_();
                int z = pos.m_123343_();
                String coordinates = String.format("%d:  (%d,  %d,  %d)", i + 1, x, y, z);
                if (!waypointItems.isEmpty() && waypointItems.get(i) != null) {
                    this.renderItemAt(waypointItems.get(i), 15, 58 + (i - startIndex) * 17);
                } else {
                    BlockPos pos1 = waypoints.get(i);
                    ItemStack itemStack = this.merchant.getItemStackToRender(pos1);
                    this.renderItemAt(itemStack, 15, 58 + (i - startIndex) * 17);
                }
                this.f_96547_.m_92883_(matrixStack, coordinates, 35.0f, (float)(60 + (i - startIndex) * 17), fontColor);
            }
            if (waypoints.size() > waypointsPerPage) {
                this.f_96547_.m_92883_(matrixStack, "Page: " + this.page, 90.0f, 230.0f, fontColor);
            }
        }
    }

    private void renderItemAt(ItemStack itemStack, int x, int y) {
        if (itemStack != null) {
            this.f_96542_.m_115203_(itemStack, x, y);
        }
    }

    public Button createPageBackButton() {
        return (Button)this.m_142416_((GuiEventListener)new Button(this.leftPos + 15, this.topPos + 230, 12, 12, (Component)Component.m_237113_((String)"<"), button -> {
            if (this.page > 1) {
                --this.page;
            }
            this.setButtons();
        }));
    }

    public Button createPageForwardButton() {
        return (Button)this.m_142416_((GuiEventListener)new Button(this.leftPos + 184, this.topPos + 230, 12, 12, (Component)Component.m_237113_((String)">"), button -> {
            ++this.page;
            this.setButtons();
        }));
    }

    private Button createAddWaypointButton(int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new Button(x, y, 20, 20, (Component)Component.m_237113_((String)"+"), button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantAddWayPoint(this.merchant.m_20148_()));
            this.setButtons();
        }));
    }

    private Button createRemoveWaypointButton(int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new Button(x, y, 20, 20, (Component)Component.m_237113_((String)"-"), button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantRemoveWayPoint(this.merchant.m_20148_()));
            this.setButtons();
        }));
    }
}

