/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.workers.Main;
import com.talhanation.workers.Translatable;
import com.talhanation.workers.config.WorkersModConfig;
import com.talhanation.workers.inventory.CommandMenu;
import com.talhanation.workers.network.MessageBedPos;
import com.talhanation.workers.network.MessageChestPos;
import com.talhanation.workers.network.MessageFollow;
import com.talhanation.workers.network.MessageMerchantTravel;
import com.talhanation.workers.network.MessageStartPos;
import de.maxhenkel.workers.corelib.inventory.ScreenBase;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class CommandScreen
extends ScreenBase<CommandMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("workers", "textures/gui/command_gui.png");
    private static final int fontColor = 0xF7F7F7;
    public static List<UUID> worker_ids;
    public static List<String> worker_names;
    public final Player player;
    private byte index;
    private String name = "";
    private BlockPos blockpos;
    private Button rightButton;
    private Button leftButton;
    private Button workPosButton;
    private Button followButton;
    private Button startTravelButton;
    private Button stopTravelButton;
    private Button returnTravelButton;
    private Button sleepPosButton;
    private Button chestPosButton;

    public CommandScreen(CommandMenu commandContainer, Inventory playerInventory, Component title) {
        super(RESOURCE_LOCATION, commandContainer, playerInventory, (Component)Component.m_237113_((String)""));
        this.f_97726_ = 201;
        this.f_97727_ = 170;
        this.player = playerInventory.f_35978_;
    }

    public boolean m_7920_(int x, int y, int z) {
        super.m_7920_(x, y, z);
        if (!((Boolean)WorkersModConfig.CommandScreenToggle.get()).booleanValue()) {
            this.m_7379_();
        }
        return true;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setButtons();
    }

    private void setButtons() {
        this.m_169413_();
        if (worker_ids != null && worker_ids.size() > 0) {
            if (!worker_names.isEmpty() && this.index < worker_names.size()) {
                this.name = worker_names.get(this.index);
            }
            int zeroLeftPos = this.f_97735_ + 150;
            int zeroTopPos = this.f_97736_ - 40;
            this.rightButton = this.cycleButtonRight(zeroLeftPos, zeroTopPos);
            this.leftButton = this.cycleButtonLeft(zeroLeftPos, zeroTopPos);
            this.blockpos = this.getBlockPos();
            this.followButton = this.setFollow(zeroLeftPos, zeroTopPos);
            this.workPosButton = this.setWorkPosition(this.blockpos, zeroLeftPos, zeroTopPos);
            this.sleepPosButton = this.setSleepPosition(this.blockpos, zeroLeftPos, zeroTopPos);
            this.chestPosButton = this.setChestPosition(this.blockpos, zeroLeftPos, zeroTopPos);
            this.leftButton.f_93623_ = this.canCycleLeft();
            this.rightButton.f_93623_ = this.canCycleRight();
            this.workPosButton.f_93623_ = this.blockpos != null;
            this.sleepPosButton.f_93623_ = this.blockpos != null && this.getBlockState().isBed((BlockGetter)this.player.m_20193_(), this.blockpos, (LivingEntity)this.player);
            boolean bl = this.chestPosButton.f_93623_ = this.blockpos != null && this.player.m_20193_().m_7702_(this.blockpos) instanceof Container;
            if (this.name != null && this.name.contains("Merchant")) {
                this.startTravelButton = this.setStartTravel(zeroLeftPos, zeroTopPos);
                this.stopTravelButton = this.setStopTravel(zeroLeftPos, zeroTopPos);
                this.returnTravelButton = this.setReturnTravel(zeroLeftPos, zeroTopPos);
            }
        }
    }

    protected void m_181908_() {
        super.m_181908_();
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        int size = worker_ids == null ? 0 : worker_ids.size();
        int k = 85;
        int l = 65;
        String workers = "Workers: ";
        String worker = this.index + 1 + ": " + this.name;
        if (size > 0) {
            this.f_96547_.m_92883_(matrixStack, workers + size, (float)(k - workers.length()), (float)l, 0xF7F7F7);
            this.f_96547_.m_92883_(matrixStack, worker, (float)(k - worker.length() - 15), (float)(l + 25), 0xF7F7F7);
        }
    }

    private Button setFollow(int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x - 90, y + 160, 80, 18, Translatable.TEXT_BUTTON_FOLLOW, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageFollow(this.player.m_20148_(), this.getCurrentWorker()))));
    }

    private Button setReturnTravel(int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x - 20, y + 180, 40, 18, Translatable.TEXT_BUTTON_TRAVEL_RETURN, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTravel(this.getCurrentWorker(), true, true))));
    }

    private Button setStopTravel(int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x - 70, y + 180, 40, 18, Translatable.TEXT_BUTTON_TRAVEL_STOP, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTravel(this.getCurrentWorker(), false, false))));
    }

    private Button setStartTravel(int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x - 120, y + 180, 40, 18, Translatable.TEXT_BUTTON_TRAVEL_START, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTravel(this.getCurrentWorker(), true, false))));
    }

    private Button setWorkPosition(BlockPos pos, int x, int y) {
        Object component = this.name != null ? (this.name.contains("Merchant") ? Translatable.TEXT_BUTTON_ADD_WAYPOINT : Translatable.TEXT_BUTTON_WORK_POS) : Component.m_237113_((String)"null");
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x - 90, y + 140, 80, 18, (Component)component, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageStartPos(this.player.m_20148_(), pos, this.getCurrentWorker()))));
    }

    private Button setChestPosition(BlockPos pos, int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x - 180, y + 140, 80, 18, Translatable.TEXT_BUTTON_CHEST_POS, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageChestPos(this.player.m_20148_(), pos, this.getCurrentWorker()))));
    }

    private Button setSleepPosition(BlockPos pos, int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x, y + 140, 80, 18, Translatable.TEXT_BUTTON_SLEEP_POS, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageBedPos(this.player.m_20148_(), pos, this.getCurrentWorker()))));
    }

    private Button cycleButtonLeft(int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x - 150, y + 50, 50, 18, (Component)Component.m_237113_((String)"<"), button -> {
            if (this.canCycleLeft()) {
                this.index = (byte)(this.index - 1);
                this.setButtons();
            }
        }));
    }

    private Button cycleButtonRight(int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x, y + 50, 50, 18, (Component)Component.m_237113_((String)">"), button -> {
            if (this.canCycleRight()) {
                this.index = (byte)(this.index + 1);
                this.setButtons();
            }
        }));
    }

    private boolean canCycleLeft() {
        return !worker_ids.isEmpty() && this.index > 0;
    }

    private boolean canCycleRight() {
        return !worker_ids.isEmpty() && this.index + 1 != worker_ids.size();
    }

    private UUID getCurrentWorker() {
        return worker_ids.get(this.index);
    }

    private BlockPos getBlockPos() {
        HitResult rayTraceResult = this.player.m_19907_(50.0, 1.0f, true);
        if (rayTraceResult != null && rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockraytraceresult = (BlockHitResult)rayTraceResult;
            return blockraytraceresult.m_82425_();
        }
        return null;
    }

    private BlockState getBlockState() {
        return this.player.f_19853_.m_8055_(this.blockpos);
    }
}

