/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers;

import com.talhanation.workers.Main;
import com.talhanation.workers.Translatable;
import com.talhanation.workers.config.WorkersModConfig;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.FishermanEntity;
import com.talhanation.workers.entities.IBoatController;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.entities.MinerEntity;
import com.talhanation.workers.inventory.CommandMenu;
import com.talhanation.workers.network.MessageOpenCommandScreen;
import com.talhanation.workers.network.MessageToClientUpdateCommandScreen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CommandEvents {
    public static void setStartPosWorker(UUID player_uuid, AbstractWorkerEntity worker, BlockPos blockpos) {
        LivingEntity owner = worker.m_21826_();
        if (worker.m_21824_() && Objects.equals(worker.m_21805_(), player_uuid)) {
            if (owner != null) {
                Direction playerDirection;
                if (worker instanceof MinerEntity) {
                    MinerEntity miner = (MinerEntity)worker;
                    playerDirection = owner.m_6350_();
                    miner.setMineDirection(playerDirection);
                }
                if (worker instanceof FishermanEntity) {
                    FishermanEntity fisherman = (FishermanEntity)worker;
                    playerDirection = owner.m_6350_();
                    fisherman.setFishingDirection(playerDirection);
                }
            }
            worker.setStartPos(blockpos);
            if (!(worker instanceof MerchantEntity)) {
                worker.setStatus(AbstractWorkerEntity.Status.WORK, true);
            }
            if (worker instanceof IBoatController) {
                IBoatController sailor = (IBoatController)((Object)worker);
                sailor.setSailPos(blockpos);
            }
        }
    }

    public static void setChestPosWorker(UUID player_uuid, AbstractWorkerEntity worker, BlockPos blockpos) {
        LivingEntity owner = worker.m_21826_();
        UUID expectedOwnerUuid = worker.m_21805_();
        if (!worker.m_21824_() || expectedOwnerUuid == null || owner == null) {
            return;
        }
        if (expectedOwnerUuid.equals(player_uuid)) {
            BlockState selectedBlock = worker.f_19853_.m_8055_(blockpos);
            if (selectedBlock.m_60713_(Blocks.f_50087_) || selectedBlock.m_60713_(Blocks.f_50618_)) {
                worker.setChestPos(blockpos);
                worker.tellPlayer(owner, Translatable.TEXT_CHEST);
                worker.setStatus(AbstractWorkerEntity.Status.DEPOSIT);
            } else {
                worker.tellPlayer(owner, Translatable.TEXT_CHEST_ERROR);
            }
        }
    }

    public static void setBedPosWorker(UUID player_uuid, AbstractWorkerEntity worker, BlockPos blockpos) {
        LivingEntity owner = worker.m_21826_();
        UUID expectedOwnerUuid = worker.m_21805_();
        if (!worker.m_21824_() || expectedOwnerUuid == null || owner == null) {
            return;
        }
        if (expectedOwnerUuid.equals(player_uuid)) {
            BlockState selectedBlock = worker.f_19853_.m_8055_(blockpos);
            if (selectedBlock.isBed((BlockGetter)worker.f_19853_, blockpos, owner)) {
                BlockPos bedHead = selectedBlock.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.HEAD ? blockpos : blockpos.m_121945_((Direction)selectedBlock.m_61143_((Property)BlockStateProperties.f_61374_));
                worker.setBedPos(bedHead);
                worker.tellPlayer(owner, Translatable.TEXT_BED);
            } else {
                worker.tellPlayer(owner, Translatable.TEXT_BED_ERROR);
            }
        }
    }

    public static void setHomePosWorker(UUID player_uuid, AbstractWorkerEntity worker, BlockPos blockpos) {
        LivingEntity owner = worker.m_21826_();
        UUID expectedOwnerUuid = worker.m_21805_();
        if (!worker.m_21824_() || expectedOwnerUuid == null || owner == null) {
            return;
        }
        if (expectedOwnerUuid.equals(player_uuid)) {
            worker.setHomePos(blockpos);
            worker.tellPlayer(owner, Translatable.TEXT_HOME);
            CommandEvents.setChestPosWorker(worker, blockpos, owner);
            CommandEvents.setBedPosWorker(worker, blockpos, owner);
        }
    }

    public static void setChestPosWorker(AbstractWorkerEntity worker, BlockPos homePos, LivingEntity owner) {
        int range = 8;
        for (int x = -range; x < range; ++x) {
            for (int y = -range; y < range; ++y) {
                for (int z = -range; z < range; ++z) {
                    BlockPos chestPos = homePos.m_7918_(x, y, z);
                    BlockState block = worker.f_19853_.m_8055_(chestPos);
                    if (block == null || !block.m_60713_(Blocks.f_50087_) && !block.m_60713_(Blocks.f_50618_)) continue;
                    worker.setChestPos(chestPos);
                    return;
                }
            }
        }
        worker.tellPlayer(owner, Translatable.NEED_CHEST);
    }

    public static void setBedPosWorker(AbstractWorkerEntity worker, BlockPos homePos, LivingEntity owner) {
        int range = 8;
        for (int x = -range; x < range; ++x) {
            for (int y = -range; y < range; ++y) {
                for (int z = -range; z < range; ++z) {
                    BlockPos bedPos = homePos.m_7918_(x, y, z);
                    BlockState block = worker.f_19853_.m_8055_(bedPos);
                    if (block == null || !block.isBed((BlockGetter)worker.f_19853_, bedPos, (LivingEntity)worker) || block.m_61143_((Property)BlockStateProperties.f_61391_) != BedPart.HEAD) continue;
                    worker.setBedPos(bedPos);
                    return;
                }
            }
        }
        worker.tellPlayer(owner, Translatable.NEED_BED);
    }

    public static void handleMerchantTrade(Player player, MerchantEntity merchant, int tradeID) {
        if (merchant.isCreative()) {
            CommandEvents.handleCreativeMerchantTrade(player, merchant, tradeID);
        } else {
            CommandEvents.handleSurvivalMerchantTrade(player, merchant, tradeID);
        }
    }

    public static void handleSurvivalMerchantTrade(Player player, MerchantEntity merchant, int tradeID) {
        boolean merchantWantsTrade;
        Item itemInSlot;
        ItemStack itemStackInSlot;
        int i;
        int[] PRICE_SLOT = new int[]{0, 2, 4, 6};
        int[] TRADE_SLOT = new int[]{1, 3, 5, 7};
        Inventory playerInv = player.m_150109_();
        SimpleContainer merchantInv = merchant.getInventory();
        SimpleContainer merchantTradeInv = merchant.getTradeInventory();
        int playerEmeralds = 0;
        int merchantEmeralds = 0;
        int playerTradeItem = 0;
        int merchantTradeItem = 0;
        ItemStack emeraldItemStack = merchantTradeInv.m_8020_(PRICE_SLOT[tradeID]);
        Item emerald = emeraldItemStack.m_41720_();
        int sollPrice = emeraldItemStack.m_41613_();
        ItemStack tradeItemStack = merchantTradeInv.m_8020_(TRADE_SLOT[tradeID]);
        Item tradeItem = tradeItemStack.m_41720_();
        int tradeCount = tradeItemStack.m_41613_();
        for (i = 0; i < playerInv.m_6643_(); ++i) {
            itemStackInSlot = playerInv.m_8020_(i);
            itemInSlot = itemStackInSlot.m_41720_();
            if (itemInSlot != emerald) continue;
            playerEmeralds += itemStackInSlot.m_41613_();
        }
        for (i = 0; i < merchantInv.m_6643_(); ++i) {
            itemStackInSlot = merchantInv.m_8020_(i);
            itemInSlot = itemStackInSlot.m_41720_();
            if (itemInSlot != emerald) continue;
            merchantEmeralds += itemStackInSlot.m_41613_();
        }
        for (i = 0; i < playerInv.m_6643_(); ++i) {
            itemStackInSlot = playerInv.m_8020_(i);
            itemInSlot = itemStackInSlot.m_41720_();
            if (itemInSlot != tradeItem) continue;
            playerTradeItem += itemStackInSlot.m_41613_();
        }
        for (i = 0; i < merchantInv.m_6643_(); ++i) {
            itemStackInSlot = merchantInv.m_8020_(i);
            itemInSlot = itemStackInSlot.m_41720_();
            if (itemInSlot != tradeItem) continue;
            merchantTradeItem += itemStackInSlot.m_41613_();
        }
        boolean merchantHasItems = merchantTradeItem >= tradeCount;
        boolean playerCanPay = playerEmeralds >= sollPrice;
        boolean canAddItemToInv = merchantInv.m_19183_(emeraldItemStack);
        boolean bl = merchantWantsTrade = merchant.getTradeLimit(tradeID) == -1 || merchant.getCurrentTrades(tradeID) < merchant.getTradeLimit(tradeID);
        if (merchantWantsTrade) {
            if (canAddItemToInv && merchantHasItems && playerCanPay) {
                if (playerInv.m_36062_() != -1) {
                    merchantTradeItem -= tradeCount;
                    for (int i2 = 0; i2 < merchantInv.m_6643_(); ++i2) {
                        ItemStack itemStackInSlot2 = merchantInv.m_8020_(i2);
                        Item itemInSlot2 = itemStackInSlot2.m_41720_();
                        if (itemInSlot2 != tradeItem) continue;
                        merchantInv.m_8016_(i2);
                    }
                    ItemStack tradeGoodLeft = tradeItemStack.m_41777_();
                    for (int i3 = 0; i3 < 18; ++i3) {
                        if (merchantTradeItem > 64) {
                            tradeGoodLeft.m_41764_(merchantTradeItem);
                            merchantInv.m_19173_(tradeGoodLeft);
                            merchantTradeItem -= 64;
                            continue;
                        }
                        tradeGoodLeft.m_41764_(merchantTradeItem);
                        merchantInv.m_19173_(tradeGoodLeft);
                        break;
                    }
                    ItemStack tradeGood = tradeItemStack.m_41777_();
                    tradeGood.m_41764_(tradeCount);
                    playerInv.m_36054_(tradeGood);
                    playerEmeralds -= sollPrice;
                    for (int i4 = 0; i4 < playerInv.m_6643_(); ++i4) {
                        ItemStack itemStackInSlot3 = playerInv.m_8020_(i4);
                        Item itemInSlot3 = itemStackInSlot3.m_41720_();
                        if (itemInSlot3 != emerald) continue;
                        playerInv.m_8016_(i4);
                    }
                    ItemStack emeraldsKar = emeraldItemStack.m_41777_();
                    emeraldsKar.m_41764_(sollPrice);
                    merchantInv.m_19173_(emeraldsKar);
                    ItemStack emeraldsLeft = emeraldItemStack.m_41777_();
                    emeraldsLeft.m_41764_(playerEmeralds);
                    playerInv.m_36054_(emeraldsLeft);
                    merchant.setCurrentTrades(tradeID, merchant.getCurrentTrades(tradeID) + 1);
                } else {
                    merchant.tellPlayer((LivingEntity)player, Translatable.TEXT_NO_SPACE_FOR_TRADE);
                }
            } else {
                LivingEntity owner = merchant.m_21826_();
                if (!merchantHasItems) {
                    merchant.tellPlayer((LivingEntity)player, Translatable.TEXT_OUT_OF_STOCK);
                    if (owner != null) {
                        merchant.tellPlayer(owner, Translatable.TEXT_OUT_OF_STOCK_OWNER);
                    }
                } else if (!playerCanPay) {
                    merchant.tellPlayer((LivingEntity)player, Translatable.TEXT_NEED(sollPrice, emerald));
                } else if (!canAddItemToInv) {
                    merchant.tellPlayer((LivingEntity)player, Translatable.TEXT_INV_FULL);
                    if (owner != null) {
                        merchant.tellPlayer(owner, Translatable.TEXT_INV_FULL_OWNER);
                    }
                }
            }
        } else {
            merchant.tellPlayer((LivingEntity)player, Translatable.TEXT_NO_NEED(tradeItem));
        }
    }

    public static void handleRecruiting(Player player, AbstractWorkerEntity worker, String name) {
        boolean playerCanPay;
        int sollPrice = worker.workerCosts();
        Inventory playerInv = player.m_150109_();
        int playerEmeralds = 0;
        ItemStack currencyItemStack = CommandEvents.getWorkersCurrency();
        for (int i = 0; i < playerInv.m_6643_(); ++i) {
            ItemStack itemStackInSlot = playerInv.m_8020_(i);
            Item itemInSlot = itemStackInSlot.m_41720_();
            if (!itemInSlot.equals(currencyItemStack.m_41720_())) continue;
            playerEmeralds += itemStackInSlot.m_41613_();
        }
        boolean bl = playerCanPay = playerEmeralds >= sollPrice;
        if (playerCanPay) {
            if (worker.hire(player)) {
                playerEmeralds -= sollPrice;
                for (int i = 0; i < playerInv.m_6643_(); ++i) {
                    ItemStack itemStackInSlot = playerInv.m_8020_(i);
                    Item itemInSlot = itemStackInSlot.m_41720_();
                    if (!itemInSlot.equals(currencyItemStack.m_41720_())) continue;
                    playerInv.m_8016_(i);
                }
                ItemStack emeraldsLeft = currencyItemStack.m_41777_();
                emeraldsLeft.m_41764_(playerEmeralds);
                playerInv.m_36054_(emeraldsLeft);
                worker.m_6593_((Component)Component.m_237113_((String)name));
            }
        } else {
            worker.tellPlayer((LivingEntity)player, Translatable.TEXT_HIRE_COSTS(sollPrice, currencyItemStack.m_41720_().m_41466_().getString()));
        }
    }

    public static ItemStack getWorkersCurrency() {
        String str = (String)WorkersModConfig.WorkersCurrency.get();
        Optional holder = ForgeRegistries.ITEMS.getHolder(ResourceLocation.m_135820_((String)str));
        return holder.map(itemHolder -> ((Item)itemHolder.m_203334_()).m_7968_()).orElseGet(() -> ((Item)Items.f_42616_).m_7968_());
    }

    public static void handleCreativeMerchantTrade(Player player, MerchantEntity merchant, int tradeID) {
        boolean merchantWantsTrade;
        Item itemInSlot;
        ItemStack itemStackInSlot;
        int i;
        int[] PRICE_SLOT = new int[]{0, 2, 4, 6};
        int[] TRADE_SLOT = new int[]{1, 3, 5, 7};
        Inventory playerInv = player.m_150109_();
        SimpleContainer merchantTradeInv = merchant.getTradeInventory();
        int playerEmeralds = 0;
        int playerTradeItem = 0;
        ItemStack emeraldItemStack = merchantTradeInv.m_8020_(PRICE_SLOT[tradeID]);
        Item emerald = emeraldItemStack.m_41720_();
        int sollPrice = emeraldItemStack.m_41613_();
        ItemStack tradeItemStack = merchantTradeInv.m_8020_(TRADE_SLOT[tradeID]);
        Item tradeItem = tradeItemStack.m_41720_();
        int tradeCount = tradeItemStack.m_41613_();
        for (i = 0; i < playerInv.m_6643_(); ++i) {
            itemStackInSlot = playerInv.m_8020_(i);
            itemInSlot = itemStackInSlot.m_41720_();
            if (itemInSlot != emerald) continue;
            playerEmeralds += itemStackInSlot.m_41613_();
        }
        for (i = 0; i < playerInv.m_6643_(); ++i) {
            itemStackInSlot = playerInv.m_8020_(i);
            itemInSlot = itemStackInSlot.m_41720_();
            if (itemInSlot != tradeItem) continue;
            playerTradeItem += itemStackInSlot.m_41613_();
        }
        boolean playerCanPay = playerEmeralds >= sollPrice;
        boolean bl = merchantWantsTrade = merchant.getTradeLimit(tradeID) == -1 || merchant.getCurrentTrades(tradeID) < merchant.getTradeLimit(tradeID);
        if (merchantWantsTrade) {
            if (playerCanPay) {
                if (playerInv.m_36062_() != -1) {
                    ItemStack tradeGood = tradeItemStack.m_41777_();
                    tradeGood.m_41764_(tradeCount);
                    playerInv.m_36054_(tradeGood);
                    playerEmeralds -= sollPrice;
                    for (int i2 = 0; i2 < playerInv.m_6643_(); ++i2) {
                        ItemStack itemStackInSlot2 = playerInv.m_8020_(i2);
                        Item itemInSlot2 = itemStackInSlot2.m_41720_();
                        if (itemInSlot2 != emerald) continue;
                        playerInv.m_8016_(i2);
                    }
                    ItemStack emeraldsLeft = emeraldItemStack.m_41777_();
                    emeraldsLeft.m_41764_(playerEmeralds);
                    playerInv.m_36054_(emeraldsLeft);
                    merchant.setCurrentTrades(tradeID, merchant.getCurrentTrades(tradeID) + 1);
                } else {
                    merchant.tellPlayer((LivingEntity)player, Translatable.TEXT_NO_SPACE_FOR_TRADE);
                }
            } else {
                merchant.tellPlayer((LivingEntity)player, Translatable.TEXT_NEED(sollPrice, emerald));
            }
        } else {
            merchant.tellPlayer((LivingEntity)player, Translatable.TEXT_NO_NEED(tradeItem));
        }
    }

    public static void openCommandScreen(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return Component.m_237113_((String)"command_screen");
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new CommandMenu(i, playerEntity);
                }
            }, packetBuffer -> packetBuffer.m_130077_(player.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenCommandScreen(player));
        }
    }

    public static void updateCommandScreen(ServerPlayer player, ServerLevel level) {
        List list = Objects.requireNonNull(player.f_19853_.m_45976_(AbstractWorkerEntity.class, player.m_20191_().m_82400_(64.0)));
        ArrayList<UUID> workers = new ArrayList<UUID>();
        ArrayList<String> names = new ArrayList<String>();
        list.sort(Comparator.comparing(AbstractWorkerEntity::getDistanceToOwner));
        for (AbstractWorkerEntity worker : list) {
            if (!Objects.equals(worker.m_21805_(), player.m_20148_())) continue;
            workers.add(worker.m_20148_());
            String name = worker.m_7755_().getString() + " / " + worker.getProfessionName();
            names.add(name);
        }
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageToClientUpdateCommandScreen(workers, names));
    }
}

