/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.registry.helper;

import com.teamabnormals.blueprint.client.ChestManager;
import com.teamabnormals.blueprint.client.renderer.block.ChestBlockEntityWithoutLevelRenderer;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.entity.BlueprintChestBlockEntity;
import com.teamabnormals.blueprint.common.block.entity.BlueprintTrappedChestBlockEntity;
import com.teamabnormals.blueprint.common.item.BEWLRBlockItem;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public class WoodworksBlockSubRegistryHelper
extends BlockSubRegistryHelper {
    public WoodworksBlockSubRegistryHelper(RegistryHelper parent) {
        super(parent);
    }

    public RegistryObject<BlueprintChestBlock> createNonFuelChestBlock(String name, BlockBehaviour.Properties properties, @Nullable CreativeModeTab group) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register(name + "_chest", () -> new BlueprintChestBlock(modId + ":" + name, properties));
        ChestManager.putChestInfo((String)modId, (String)name, (boolean)false);
        this.itemRegister.register(name + "_chest", () -> new BEWLRBlockItem((Block)block.get(), new Item.Properties().m_41491_(group), () -> () -> WoodworksBlockSubRegistryHelper.chestBEWLR(false)));
        return block;
    }

    public RegistryObject<BlueprintTrappedChestBlock> createNonFuelTrappedChestBlock(String name, BlockBehaviour.Properties properties, @Nullable CreativeModeTab group) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register(name + "_trapped_chest", () -> new BlueprintTrappedChestBlock(modId + ":" + name + "_trapped", properties));
        ChestManager.putChestInfo((String)modId, (String)name, (boolean)true);
        this.itemRegister.register(name + "_trapped_chest", () -> new BEWLRBlockItem((Block)block.get(), new Item.Properties().m_41491_(group), () -> () -> WoodworksBlockSubRegistryHelper.chestBEWLR(true)));
        return block;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BEWLRBlockItem.LazyBEWLR chestBEWLR(boolean trapped) {
        return trapped ? new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer(dispatcher, entityModelSet, (BlockEntity)new BlueprintTrappedChestBlockEntity(BlockPos.f_121853_, Blocks.f_50325_.m_49966_()))) : new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer(dispatcher, entityModelSet, (BlockEntity)new BlueprintChestBlockEntity(BlockPos.f_121853_, Blocks.f_50087_.m_49966_())));
    }
}

