/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.data.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodworksLootTableProvider
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(WoodworksBlockLoot::new, (Object)LootContextParamSets.f_81421_));

    public WoodworksLootTableProvider(DataGenerator generator) {
        super(generator);
    }

    public List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
    }

    private static class WoodworksBlockLoot
    extends BlockLoot {
        private WoodworksBlockLoot() {
        }

        public void addTables() {
            this.m_124288_((Block)WoodworksBlocks.SAWMILL.get());
            this.m_124288_((Block)WoodworksBlocks.OAK_BOARDS.get());
            this.m_124175_((Block)WoodworksBlocks.OAK_LEAF_PILE.get(), WoodworksBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)WoodworksBlocks.OAK_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.OAK_TRAPPED_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124288_((Block)WoodworksBlocks.SPRUCE_BOARDS.get());
            this.m_124175_((Block)WoodworksBlocks.SPRUCE_LEAF_PILE.get(), WoodworksBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)WoodworksBlocks.SPRUCE_BOOKSHELF.get(), WoodworksBlockLoot::createBookshelfDrops);
            this.m_124288_((Block)WoodworksBlocks.SPRUCE_LADDER.get());
            this.m_124175_((Block)WoodworksBlocks.SPRUCE_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.SPRUCE_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.SPRUCE_TRAPPED_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124288_((Block)WoodworksBlocks.BIRCH_BOARDS.get());
            this.m_124175_((Block)WoodworksBlocks.BIRCH_LEAF_PILE.get(), WoodworksBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)WoodworksBlocks.BIRCH_BOOKSHELF.get(), WoodworksBlockLoot::createBookshelfDrops);
            this.m_124288_((Block)WoodworksBlocks.BIRCH_LADDER.get());
            this.m_124175_((Block)WoodworksBlocks.BIRCH_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.BIRCH_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.BIRCH_TRAPPED_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124288_((Block)WoodworksBlocks.JUNGLE_BOARDS.get());
            this.m_124175_((Block)WoodworksBlocks.JUNGLE_LEAF_PILE.get(), WoodworksBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)WoodworksBlocks.JUNGLE_BOOKSHELF.get(), WoodworksBlockLoot::createBookshelfDrops);
            this.m_124288_((Block)WoodworksBlocks.JUNGLE_LADDER.get());
            this.m_124175_((Block)WoodworksBlocks.JUNGLE_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.JUNGLE_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.JUNGLE_TRAPPED_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124288_((Block)WoodworksBlocks.ACACIA_BOARDS.get());
            this.m_124175_((Block)WoodworksBlocks.ACACIA_LEAF_PILE.get(), WoodworksBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)WoodworksBlocks.ACACIA_BOOKSHELF.get(), WoodworksBlockLoot::createBookshelfDrops);
            this.m_124288_((Block)WoodworksBlocks.ACACIA_LADDER.get());
            this.m_124175_((Block)WoodworksBlocks.ACACIA_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.ACACIA_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.ACACIA_TRAPPED_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124288_((Block)WoodworksBlocks.DARK_OAK_BOARDS.get());
            this.m_124175_((Block)WoodworksBlocks.DARK_OAK_LEAF_PILE.get(), WoodworksBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)WoodworksBlocks.DARK_OAK_BOOKSHELF.get(), WoodworksBlockLoot::createBookshelfDrops);
            this.m_124288_((Block)WoodworksBlocks.DARK_OAK_LADDER.get());
            this.m_124175_((Block)WoodworksBlocks.DARK_OAK_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.DARK_OAK_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.DARK_OAK_TRAPPED_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124288_((Block)WoodworksBlocks.MANGROVE_BOARDS.get());
            this.m_124175_((Block)WoodworksBlocks.MANGROVE_LEAF_PILE.get(), WoodworksBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)WoodworksBlocks.MANGROVE_BOOKSHELF.get(), WoodworksBlockLoot::createBookshelfDrops);
            this.m_124288_((Block)WoodworksBlocks.MANGROVE_LADDER.get());
            this.m_124175_((Block)WoodworksBlocks.MANGROVE_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.MANGROVE_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.MANGROVE_TRAPPED_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124288_((Block)WoodworksBlocks.CRIMSON_BOARDS.get());
            this.m_124175_((Block)WoodworksBlocks.CRIMSON_BOOKSHELF.get(), WoodworksBlockLoot::createBookshelfDrops);
            this.m_124288_((Block)WoodworksBlocks.CRIMSON_LADDER.get());
            this.m_124175_((Block)WoodworksBlocks.CRIMSON_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.CRIMSON_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.CRIMSON_TRAPPED_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124288_((Block)WoodworksBlocks.WARPED_BOARDS.get());
            this.m_124175_((Block)WoodworksBlocks.WARPED_BOOKSHELF.get(), WoodworksBlockLoot::createBookshelfDrops);
            this.m_124288_((Block)WoodworksBlocks.WARPED_LADDER.get());
            this.m_124175_((Block)WoodworksBlocks.WARPED_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.WARPED_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.WARPED_TRAPPED_CHEST.get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)WoodworksBlocks.AZALEA_LEAF_PILE.get(), WoodworksBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)WoodworksBlocks.FLOWERING_AZALEA_LEAF_PILE.get(), WoodworksBlockLoot::createLeafPileDrops);
        }

        protected static LootTable.Builder createLeafPileDrops(Block block) {
            return WoodworksBlockLoot.m_236227_((Block)block, (LootItemCondition.Builder)MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS)));
        }

        protected static LootTable.Builder createBookshelfDrops(Block block) {
            return WoodworksBlockLoot.m_176042_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f));
        }

        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("woodworks")).collect(Collectors.toSet());
        }
    }
}

