/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.config.ConfigCommon;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerStatusManagerServer
extends PlayerStatusManager {
    @Override
    public void tickPlayer(Player player) {
        this.getStatus(player).setTicksToMarkPlayerIdleSyncedForClient(ConfigCommon.ticksToMarkPlayerIdle);
        super.tickPlayer(player);
    }

    public void receiveAny(Player player, CompoundTag data) {
        data.m_128359_(WatutNetworking.NBTDataPlayerUUID, player.m_20148_().toString());
        if (data.m_128441_(WatutNetworking.NBTDataPlayerStatus)) {
            PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.m_128451_(WatutNetworking.NBTDataPlayerStatus));
            this.getStatus(player).setPlayerGuiState(playerGuiState);
        }
        if (data.m_128441_(WatutNetworking.NBTDataPlayerIdleTicks)) {
            this.handleIdleState(player, data.m_128451_(WatutNetworking.NBTDataPlayerIdleTicks));
            data.m_128405_(WatutNetworking.NBTDataPlayerTicksToGoIdle, ConfigCommon.ticksToMarkPlayerIdle);
        }
        if (data.m_128441_(WatutNetworking.NBTDataPlayerMouseX)) {
            float x = data.m_128457_(WatutNetworking.NBTDataPlayerMouseX);
            float y = data.m_128457_(WatutNetworking.NBTDataPlayerMouseY);
            boolean pressed = data.m_128471_(WatutNetworking.NBTDataPlayerMousePressed);
            this.setMouse(player.m_20148_(), x, y, pressed);
        }
        this.getStatus(player).getNbtCache().m_128391_(data);
        if (data.m_128441_(WatutNetworking.NBTDataPlayerStatus) || data.m_128441_(WatutNetworking.NBTDataPlayerIdleTicks)) {
            WatutNetworking.instance().serverSendToClientAll(data);
        } else {
            WatutNetworking.instance().serverSendToClientNear(data, player.m_20182_(), this.nearbyPlayerDataSendDist, player.f_19853_);
        }
    }

    public void handleIdleState(Player player, int idleTicks) {
        PlayerStatus status = this.getStatus(player);
        if (WatutMod.instance().getPlayerList().m_11309_() > 1 || this.singleplayerTesting) {
            if (idleTicks > ConfigCommon.ticksToMarkPlayerIdle) {
                if (!status.isIdle()) {
                    this.broadcast(player.m_5446_().getString() + " has gone idle");
                }
            } else if (status.isIdle()) {
                this.broadcast(player.m_5446_().getString() + " is no longer idle");
            }
        }
        status.setTicksSinceLastAction(idleTicks);
    }

    public void broadcast(String msg) {
        if (ConfigCommon.announceIdleStatesInChat) {
            WatutMod.instance().getPlayerList().m_240416_((Component)Component.m_237113_((String)msg), false);
        }
    }

    @Override
    public void playerLoggedIn(Player player) {
        super.playerLoggedIn(player);
        WatutMod.dbg("player logged in");
        if (player instanceof ServerPlayer) {
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("sending update all packet for " + ((UUID)entry.getKey()).toString() + " to " + player.m_5446_().getString() + " with status " + PlayerStatus.PlayerGuiState.get(((PlayerStatus)entry.getValue()).getNbtCache().m_128451_(WatutNetworking.NBTDataPlayerStatus)));
                WatutNetworking.instance().serverSendToClientPlayer(((PlayerStatus)entry.getValue()).getNbtCache(), player);
            }
        }
    }
}

