/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.wares.config.Config;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import org.slf4j.Logger;

public class VillageStructures {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
    private static final ResourceKey<StructureProcessorList> MOSSIFY_10_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "mossify_10_percent"));

    public static void addVillageStructures(ServerAboutToStartEvent event) {
        if (!((Boolean)Config.GENERATE_WAREHOUSES.get()).booleanValue()) {
            return;
        }
        Registry templatePools = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122884_).get();
        Registry processorListsRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122883_).get();
        Holder mossify10ProcessorList = processorListsRegistry.m_206081_(MOSSIFY_10_PROCESSOR_LIST_KEY);
        int weight = (Integer)Config.WAREHOUSE_WEIGHT.get();
        VillageStructures.addStructureToPoolSingle((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)mossify10ProcessorList, new ResourceLocation("minecraft:village/plains/houses"), "wares:village/houses/plains_warehouse", StructureTemplatePool.Projection.RIGID, weight);
        VillageStructures.addStructureToPoolSingle((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)mossify10ProcessorList, new ResourceLocation("minecraft:village/taiga/houses"), "wares:village/houses/taiga_warehouse", StructureTemplatePool.Projection.RIGID, weight);
        VillageStructures.addStructureToPoolSingle((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)mossify10ProcessorList, new ResourceLocation("minecraft:village/desert/houses"), "wares:village/houses/desert_warehouse", StructureTemplatePool.Projection.RIGID, weight);
        VillageStructures.addStructureToPoolSingle((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)mossify10ProcessorList, new ResourceLocation("minecraft:village/savanna/houses"), "wares:village/houses/savanna_warehouse", StructureTemplatePool.Projection.RIGID, weight);
        VillageStructures.addStructureToPoolSingle((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)mossify10ProcessorList, new ResourceLocation("minecraft:village/snowy/houses"), "wares:village/houses/snowy_warehouse", StructureTemplatePool.Projection.RIGID, weight);
    }

    private static void addStructureToPoolLegacy(Registry<StructureTemplatePool> templatePoolRegistry, Holder<StructureProcessorList> processorListHolder, ResourceLocation poolRL, String nbtPieceRL, StructureTemplatePool.Projection projection, int weight) {
        Logger logger = LogUtils.getLogger();
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            logger.error("Pool '{}' not found.", (Object)poolRL);
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)nbtPieceRL, processorListHolder).apply(projection);
        VillageStructures.addPieceToPool(piece, pool, weight);
    }

    private static void addStructureToPoolSingle(Registry<StructureTemplatePool> templatePoolRegistry, Holder<StructureProcessorList> processorListHolder, ResourceLocation poolRL, String nbtPieceRL, StructureTemplatePool.Projection projection, int weight) {
        Logger logger = LogUtils.getLogger();
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            logger.error("Pool '{}' not found.", (Object)poolRL);
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210531_((String)nbtPieceRL, processorListHolder).apply(projection);
        VillageStructures.addPieceToPool(piece, pool, weight);
    }

    private static void addPieceToPool(SinglePoolElement piece, StructureTemplatePool pool, int weight) {
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }
}

