/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.menu;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.data.Package;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class CardboardBoxMenu
extends AbstractContainerMenu {
    public static final int PACK_BUTTON_ID = 0;
    public static final int SLOTS = 6;
    public final int openedBoxSlotId;
    public Pair<Integer, Integer> cardboardBoxSlotPos = Pair.of((Object)Integer.MIN_VALUE, (Object)Integer.MIN_VALUE);
    private final IItemHandler cardboardBoxItemHandler = new ItemStackHandler(6){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return !stack.m_204117_(Wares.Tags.Items.CARDBOARD_BOX_BLACKLISTED);
        }
    };
    private boolean itemsPacked = false;

    public CardboardBoxMenu(int containerId, Inventory playerInventory) {
        super((MenuType)Wares.MenuTypes.CARDBOARD_BOX.get(), containerId);
        int column;
        int row;
        int boxSlotsX = 62;
        int boxSlotsY = 26;
        for (row = 0; row < 2; ++row) {
            for (column = 0; column < 3; ++column) {
                this.m_38897_((Slot)new SlotItemHandler(this.cardboardBoxItemHandler, column + row * 3, boxSlotsX + column * 18, boxSlotsY + row * 18));
            }
        }
        this.openedBoxSlotId = playerInventory.f_35977_;
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, column * 18 + 8, 84 + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            if (slot == this.openedBoxSlotId) {
                this.cardboardBoxSlotPos = Pair.of((Object)(slot * 18 + 8), (Object)142);
                continue;
            }
            this.m_38897_(new Slot((Container)playerInventory, slot, slot * 18 + 8, 142));
        }
    }

    public static CardboardBoxMenu fromBuffer(int containerID, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new CardboardBoxMenu(containerID, playerInventory);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        ItemStack clickedStack = slot.m_7993_();
        if (index < 6 ? !this.m_38903_(clickedStack, 6, this.f_38839_.size(), true) : index < this.f_38839_.size() && !this.m_38903_(clickedStack, 0, 6, false)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6366_(@NotNull Player player, int buttonId) {
        assert (player instanceof ServerPlayer);
        if (buttonId == 0) {
            ItemStack boxStack = ItemStack.f_41583_;
            if (player.m_150109_().m_36056_().m_150930_((Item)Wares.Items.CARDBOARD_BOX.get())) {
                boxStack = player.m_150109_().m_36056_();
            } else {
                for (ItemStack item : player.m_150109_().f_35974_) {
                    if (!item.m_150930_((Item)Wares.Items.CARDBOARD_BOX.get())) continue;
                    boxStack = item;
                    break;
                }
            }
            if (boxStack.m_41619_()) {
                Wares.LOGGER.error("Cardboard box not found in player's inventory.");
                return true;
            }
            ArrayList<ItemStack> packedItems = new ArrayList<ItemStack>();
            for (int slot = 0; slot < this.cardboardBoxItemHandler.getSlots(); ++slot) {
                ItemStack stackInSlot = this.cardboardBoxItemHandler.getStackInSlot(slot);
                if (stackInSlot.m_41619_()) continue;
                packedItems.add(stackInSlot);
            }
            ItemStack packageStack = new ItemStack((ItemLike)Wares.Items.PACKAGE.get());
            new Package((Either<ResourceLocation, List<ItemStack>>)Either.right(packedItems), player.m_6302_()).toItemStack(packageStack);
            boxStack.m_41774_(1);
            if (!player.m_36356_(packageStack)) {
                player.m_36176_(packageStack, false);
            }
            player.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)Wares.SoundEvents.CARDBOARD_BOX_USE.get(), SoundSource.PLAYERS, 1.0f, player.f_19853_.m_213780_().m_188501_() * 0.3f + 0.85f);
            this.itemsPacked = true;
            player.m_6915_();
            return true;
        }
        return false;
    }

    public void m_6877_(@NotNull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!this.itemsPacked) {
                for (int slot = 0; slot < 6; ++slot) {
                    ItemStack stackInSlot = this.cardboardBoxItemHandler.getStackInSlot(slot);
                    if (stackInSlot.m_41619_()) continue;
                    serverPlayer.m_36176_(stackInSlot, true);
                }
            }
        }
        super.m_6877_(player);
    }

    public boolean m_6875_(Player player) {
        return player.m_150109_().m_8020_(this.openedBoxSlotId).m_150930_((Item)Wares.Items.CARDBOARD_BOX.get());
    }
}

