/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.client.gui.agreement.element;

import io.github.mortuusars.wares.Wares;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class Seal {
    public static final String SEAL_FOLDER = "textures/gui/seal/";
    public static final String DEFAULT = "default";
    public static final int WIDTH = 48;
    public static final int HEIGHT = 48;
    private final String name;
    private final ResourceLocation path;

    public Seal(String name) {
        this.name = name;
        this.path = Wares.resource(SEAL_FOLDER + name + ".png");
    }

    public static Seal defaultSeal() {
        return new Seal(DEFAULT);
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getTexturePath() {
        return this.path;
    }

    public boolean isTextureValid() {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        Map resourceLocationResourceMap = resourceManager.m_214159_(SEAL_FOLDER, resourceLocation -> resourceLocation.equals((Object)this.getTexturePath()));
        return resourceLocationResourceMap.size() > 0;
    }

    public static enum Element {
        SHADOW(0),
        STRING(1),
        BASE(2),
        LOGO(3);

        private final int index;

        private Element(int index) {
            this.index = index;
        }

        public int getVOffset() {
            return this.index * 48;
        }
    }
}

