/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.block.entity;

import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.block.entity.DeliveryTableBlockEntity;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgreementTableLock {
    protected boolean locked;
    @Nullable
    protected Component buyerNameLock = null;
    @Nullable
    protected Component buyerAddressLock = null;
    @Nullable
    protected String sealLock = null;
    protected UnlockBehavior unlockBehavior = UnlockBehavior.COMPLETED_OR_EXPIRED;
    protected final DeliveryTableBlockEntity blockEntity;

    public AgreementTableLock(DeliveryTableBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public boolean isLocked() {
        return this.shouldBeLocked() && !this.unlockBehavior.shouldUnlock(this.blockEntity.getAgreementItem());
    }

    private boolean shouldBeLocked() {
        DeliveryAgreement agreement = this.blockEntity.agreement;
        if (this.blockEntity.getAgreementItem().m_41619_()) {
            return false;
        }
        return this.locked || agreement.getBuyerName().equals(this.buyerNameLock) || agreement.getBuyerAddress().equals(this.buyerAddressLock) || agreement.getSeal().equals(this.sealLock);
    }

    public CompoundTag save(CompoundTag tag) {
        if (this.locked) {
            tag.m_128379_("Locked", true);
        }
        if (this.buyerNameLock != null) {
            tag.m_128359_("MatchBuyerName", Component.Serializer.m_130703_((Component)this.buyerNameLock));
        }
        if (this.buyerAddressLock != null) {
            tag.m_128359_("MatchBuyerAddress", Component.Serializer.m_130703_((Component)this.buyerAddressLock));
        }
        if (this.sealLock != null) {
            tag.m_128359_("MatchSeal", this.sealLock);
        }
        tag.m_128359_("UnlockBehavior", this.unlockBehavior.m_7912_());
        return tag;
    }

    public void load(CompoundTag tag) {
        String sealLock;
        String buyerAddressLock;
        this.locked = tag.m_128471_("Locked");
        String buyerNameLock = tag.m_128461_("MatchBuyerName");
        if (buyerNameLock.length() > 0) {
            this.buyerNameLock = Component.Serializer.m_130701_((String)buyerNameLock);
        }
        if ((buyerAddressLock = tag.m_128461_("MatchBuyerAddress")).length() > 0) {
            this.buyerAddressLock = Component.Serializer.m_130701_((String)buyerAddressLock);
        }
        if ((sealLock = tag.m_128461_("MatchSeal")).length() > 0) {
            this.sealLock = sealLock;
        }
        String unlockBehaviorString = tag.m_128461_("UnlockBehavior");
        this.unlockBehavior = UnlockBehavior.byName(unlockBehaviorString, UnlockBehavior.COMPLETED_OR_EXPIRED);
    }

    public static enum UnlockBehavior implements StringRepresentable
    {
        NEVER("never", stack -> false),
        WHEN_COMPLETED("completed", stack -> stack.m_150930_((Item)Wares.Items.COMPLETED_DELIVERY_AGREEMENT.get())),
        WHEN_EXPIRED("expired", stack -> stack.m_150930_((Item)Wares.Items.EXPIRED_DELIVERY_AGREEMENT.get())),
        COMPLETED_OR_EXPIRED("completed_or_expired", stack -> stack.m_150930_((Item)Wares.Items.COMPLETED_DELIVERY_AGREEMENT.get()) || stack.m_150930_((Item)Wares.Items.EXPIRED_DELIVERY_AGREEMENT.get()));

        private final String name;
        private final Predicate<ItemStack> predicate;

        private UnlockBehavior(String name, Predicate<ItemStack> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public static UnlockBehavior byName(@NotNull String name, UnlockBehavior defaultValue) {
            for (UnlockBehavior value : UnlockBehavior.values()) {
                if (!value.m_7912_().equals(name)) continue;
                return value;
            }
            return defaultValue;
        }

        public boolean shouldUnlock(ItemStack agreementStack) {
            return this.predicate.test(agreementStack);
        }
    }
}

